"propertizer.py - access dictionary's data using '.'(dot)."

def propertize(obj):
    if isinstance(obj, dict):
        for key in obj:
            d = propertize(obj[key])
            obj[key] = d
        return Propertizer(obj)
    elif isinstance(obj, list):
        for i in range(len(obj)):
            d = propertize(obj[i])
            obj[i] = d
        return obj
    else:
        return obj

class Propertizer(object):
    def __init__(self, d):
        self._dict = d

    def __getattr__(self, name):
        return self._dict[name]

    def __iter__(self):
        return self._dict.__iter__()

    def next(self):
        return self._dict.next()

    def __getitem__(self, key):
        return self._dict[key]

    def __setitem__(self, key, value):
        self._dict[key] = value
