'renderer.py - rendering html and some items'

import datetime

from mako.template import Template
from mako.lookup import TemplateLookup
from mako.exceptions import RichTraceback
import dateutil.parser

from config import config
from propertizer import propertize
from logger import log

def date_format(date):
    return date.strftime('%Y/%m/%d %H:%M')

class Renderer(object):
    def __init__(self, sources):
        self.template_dir = config['template_directory']
        self._sources = sources
        
    def _get_template(self, template_name):
        'read template file'
        tl = TemplateLookup(directories=[self.template_dir],
                            input_encoding="utf-8",
                            output_encoding="utf-8",
                            default_filters=['decode.utf8'],
                            format_exceptions=True)
        return tl.get_template(template_name)

    def render(self, template, entries, params={}):
        'rendering template'
        t = self._get_template(template)

        
        kwargs = {
            'date_format': date_format,
            'entries': entries,
            'params': params,
            'site': config['site_parameter'],
            'sources': self._sources,
            }
        kwargs['site']['last_update'] = datetime.datetime.utcnow()
        for key in kwargs:
            d = propertize(kwargs[key])
            kwargs[key] = d
        try:
            result = t.render(**kwargs)
        except:
            traceback = RichTraceback()
            for (filename, lineno, function, line) in traceback.traceback:
                log("File %s, line %s, in %s" % (filename, lineno, function))
                log(line, "\n")
            log("%s: %s" % (str(traceback.error.__class__.__name__), traceback.error))
            sys.exit(-1)
        return result

