/* toc-parser.js */

var parser = {};

function Directory(name) {
  this.name = name;
  this.contents = [];
  this.pageStart = 0;
  return this;
}

parser.parseToc = function parseToc(text) {
  var texts = text.split('\n');
  var current = new Directory('.');
  var toc = {
    directories: {}
  };
  toc.directories['.'] = current;

  for (var i = 0; i < texts.length; i++) {
    var text = texts[i];

    // コメント/プラグマ処理
    if (text.charAt(0) == '#') {
      if (text.charAt(1) == '@') {
        // @プラグマの処理
        // directoryプラグマ
        var match = text.match(/^#@directory:\s*(.*?)\s*$/);
        if (match) {
          var directory = match[1];
          if ((directory.length > 1)
              && (directory.charAt(directory.length - 1) == '/')) {
            directory = directory.slice(0, -1);
          }
          if (toc.directories[directory] !== undefined) {
            current = toc.directories[directory];
          } else {
            // create new directory data
            current = new Directory(directory);
            toc.directories[directory] = current;
          }
        }

        //pageStartプラグマ
        var match = text.match(/^#@pageStart:\s*(\d+)\s*$/);
        if (match) {
          var pageStart = Number(match[1]);
          if (!isNaN(pageStart)) {
            current.pageStart = pageStart;
          }
        }

        //chapterプラグマ
        var match = text.match(/^#@chapter:\s*(\d+)\s*$/);
        if (match) {
          var chapter = Number(match[1]);
          if (!isNaN(chapter)) {
            current.chapter = chapter;
          }
        }
      }
      continue;
    } // コメント/プラグマ処理ここまで
    if (text.match(/^\s*$/)) {
      continue;
    }

    var parsed = parseLine(text);
    current.contents.push(parsed);
  }

  return toc;
};

function parseLine(text) {
  var texts = text.replace('\n', '').split('\t');
  var ret = {
    title: '',
    pages: 2
  };
  ret.title = texts[0];
  if (texts.length < 2) {
    return ret;
  }
  var n = Number(texts[1]);
  if ((n !== NaN) && (texts[1] !== '')) {
    ret.pages = n;
  }
  return ret;
}

module.exports = parser;

// main action
if (require.main == module) {

  // test code
  var data = '';
  process.stdin.on('readable', function () {
    var chunk = process.stdin.read();
    if (chunk !== null) {
      data = data + chunk;
    }
  });
  process.stdin.on('end', function() {
    var toc = parser.parseToc(data)
    console.log(toc);
    var directory = toc.directories['chapter1'];
    var pageStart = directory.pageStart;
    directory.contents.forEach(function (content) {
      console.log(content);
    });
  });
  
}
