#!/usr/bin/python
# -*- coding: utf-8 -*-

import xmlrpclib
import sys


# xmlrpclib's ExpatParser has bug, so do not use
org_getparser = xmlrpclib.getparser
def mygetparser(use_datetime=0):
    (p, t) = org_getparser(use_datetime)
    # if parser is ExpatParser, replace to SlowParser
    if isinstance(p, xmlrpclib.ExpatParser):
        p = xmlrpclib.SlowParser(p._target)
    return (p, t)
xmlrpclib.getparser = mygetparser

HOST_PATH = 'magazine-admin.sourceforge.jp/magazine/xmlrpc.php'

class MagClient(object):
    def __init__(self, username, password, auth_user="", auth_pass="", endpoint=None):
        self.username = username
        self.password = password
        if endpoint == None:
            endpoint = HOST_PATH

        if auth_user and auth_pass:
#            self.uri = "http://{username}:{password}@{url}".format(username=auth_user, password=auth_pass, url=endpoint)
            self.uri = "http://%s:%s@%s" % (auth_user, auth_pass, endpoint)
        else:
            self.uri = "http://" + endpoint

    def _get_blog_id(self):
        try:
            return self._blog_id
        except AttributeError:
            blogs = self.get_users_blogs()
            self._blog_id = blogs[0]["blogid"]
            return self._blog_id

    def _get_proxy(self):
        return xmlrpclib.ServerProxy(self.uri)

    def get_user(self, user_id, fields=[]):
        proxy = self._get_proxy()
        return proxy.wp.getUser(self._get_blog_id(),
                                self.username,
                                self.password,
                                user_id,
                                fields)

    def new_post(self, content):
        proxy = self._get_proxy()
        return proxy.wp.newPost(self._get_blog_id(),
                                self.username,
                                self.password,
                                content)

    def upload_media(self, filename, data, mimetype, overwrite=True, parent=None):
        proxy = self._get_proxy()
        post_data = {
            "name": filename,
            "type": mimetype,
            "bits": xmlrpclib.Binary(data),
            "overwrite": overwrite
            }

        if parent != None:
            post_data["post_id"] = parent

        return proxy.wp.uploadFile(self._get_blog_id(),
                                   self.username,
                                   self.password,
                                   post_data)

    def get_users_blogs(self):
        proxy = self._get_proxy()
        return proxy.wp.getUsersBlogs(self.username, self.password)

    def get_posts(self, filter={}):
        proxy = self._get_proxy()
        try:
            return proxy.wp.getPosts(self._get_blog_id(),
                                     self.username,
                                     self.password,
                                     filter)
        except xmlrpclib.Fault, e:
#            print "error {0}: {1}".format(e.faultCode, e.faultString.encode('utf8'))
            print "error %s: %s" % (e.faultCode, e.faultString.encode('utf8'))
