package com.torn.marubatu;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.widget.Toast;

import com.torn.game.Game;
import com.torn.table.Mark;
import com.torn.table.Table;

public class MainView extends View implements OnTouchListener {
	private static final int FIELD_SIZE = 600;	
	private static final Rect fieldRect = new Rect(0, 0, FIELD_SIZE, FIELD_SIZE);
	private final Paint paint = new Paint();
	private Game game;

	public MainView(Context context) {
		super(context);
		setOnTouchListener(this);

		game = Game.getInstance();
		paint.setStyle(Style.STROKE);
		paint.setColor(Color.MAGENTA);
	}

	public boolean onTouch(View v, MotionEvent event) {
		final float tx = event.getX();
		final float ty = event.getY();
		final Table table = game.getTable();
		final int table_size = table.size();
		final int block_size = FIELD_SIZE / table_size;

		if (MotionEvent.ACTION_DOWN != event.getAction()) {
			return false;
		}
		if (null != game.isFinished()) {
			return false;
		}
		if (FIELD_SIZE < tx || FIELD_SIZE < ty) {
			return false;
		}
	
		final int idx_x = (int)(tx / block_size);
		final int idx_y = (int)(ty / block_size);
	
		if (!game.putMark(idx_x, idx_y)) {
			return false;
		}

		game.turnEnd();

		/* Q[I */
		new Thread(new Runnable() {
			public void run() {
				Mark mark = game.isFinished();
				if (null != mark) {
					final String msg = (Mark.EMPTY == mark) ?
							"" : mark.toString() + "̏";
					post(new Runnable() {
						public void run() {
							Toast.makeText(MainView.this.getContext(), msg,
									Toast.LENGTH_SHORT).show();
						}
					});

					/* Q[Oɑ҂ */
					try {
						Thread.sleep(750);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
					/* Q[ */
					game.initGame();

					/* `˗ */
					post(new Runnable() {
						public void run() {
							invalidate();
						}
					});
				}
			}
		}).start();		

		/* `˗ */
		post(new Runnable() {
			public void run() {
				invalidate();
			}
		});
		return true;
	}

	
	/********/
	/* ` */
	/********/
	@Override
	public void onDraw(Canvas canvas) {
		final Table table = game.getTable();
		final int table_size = table.size();
		final int block_size = FIELD_SIZE / table_size;
	
		/* field */
		canvas.drawRect(fieldRect, paint);
		for (int x = 1; x < table_size; x++) {
			canvas.drawLine(0, x * block_size, FIELD_SIZE, x * block_size, paint);
		}
		for (int y = 1; y < table_size; y++) {			
			canvas.drawLine(y * block_size, 0, y * block_size, FIELD_SIZE, paint);
		}

		/* mark */
		for (int x = 0; x < table_size; x++) {
			for (int y = 0; y < table_size; y++) {
				if (Mark.MARU == table.get(x, y)) {
					canvas.drawCircle(
							x * block_size + block_size / 2,
							y * block_size + block_size / 2,
							block_size / 2 - 40, paint);
				} else if (Mark.BATU == table.get(x, y)) {
					canvas.drawLine(
							x * block_size + 40,
							y * block_size + 40,
							x * block_size + block_size - 40,
							y * block_size + block_size - 40,
							paint);
					canvas.drawLine(
							x * block_size + block_size - 40,
							y * block_size + 40,
							x * block_size + 40,
							y * block_size + block_size - 40,
							paint);
				}
			}
		}
	}
}
