package com.haru.player;

import java.awt.Point;

import com.haru.component.TetraMino;

public class BlockState {

	private TetraMino block;
	private int x;
	private int y;
	private int turn;	// ]̏(0`3)

	public TetraMino getBlock() {
		return block;
	}
	public int getX() {
		return x;
	}
	public int getY() {
		return y;
	}
	public Point getPos() {
		return new Point(x, y);
	}
	public int getTurn() {
		return turn;
	}


	public void setX(int x) {
		this.x = x;
	}
	public void setY(int y) {
		this.y = y;
	}
	public void setPos(Point p) {
		this.x = p.x;
		this.y = p.y;
	}
	public void setTurn(int turn) {
		this.turn = turn;
	}

	public BlockState() {
		setDefault(TetraMino.DOT);
	}

	public void setDefault(TetraMino b) {
		block = b;
		x = 5;
		y = 3;
		turn = 0;
	}

	public int getType() {
		return block.getType();
	}
	public int[][] getInfo(int t) {
		return block.getInfo(t);
	}




}
