package com.haru.tetoru.parts;

import java.util.Random;

import com.haru.tetoru.parts.Mino.ROTATE_MINO_TYPE;


/* lNXg */
class NextTable {

	/* lNXg̊Ǘz */
	private int[] nextInfo;

	/* lNXg\pe[u */
	private int[][] nextTable;

	/* lNXgǗ */
	private int num;

	/* lNXg̊Ǘz̎̃~m̓Y */
	private int nextIdx;


	/* fobO */
	int debug = 1; /* 2ɂƁAnum2{̃lNXg悤ɂȂ */


	NextTable() {
		this(7);
	}

	NextTable(int num) {
		nextInfo = new int[7 * 2];
		nextTable = new int[4 * num * debug][5];
		this.num = num;		
		nextIdx = 0;
		
		/*  */
		initTable();
		
		/* lNXg̊ǗzKɏ */
		nextInfo[0] = 3;
		nextInfo[1] = 4;
		nextInfo[2] = 5;
		nextInfo[3] = 6;
		nextInfo[4] = 7;
		nextInfo[5] = 1;
		nextInfo[6] = 2;
		nextInfo[7] = 1;
		nextInfo[8] = 2;
		nextInfo[9] = 3;
		nextInfo[10] = 4;
		nextInfo[11] = 5;
		nextInfo[12] = 6;
		nextInfo[13] = 7;

		/* OnumVbt */
		shuffle(0, num-1);
	}


	/* lNXg̃~m擾 */
	public int getNextType() {

//		Debug.println("getNextType() nextidx:" + nextIdx);

		int retType;

		/* lNXg̃~m̎ނ擾 */
		retType = nextInfo[nextIdx];

		/* numɂPVbt */
		if (0 == nextIdx) {
			/* numVbt */
			shuffle(num, num*2-1);
		} else if (num == nextIdx) {
			/* OnumVbt */
			shuffle(0, num-1);
		}

		/* Y̍XV */
		nextIdx = (nextIdx+ 1) % (num * 2);

		return retType;
	}

	/* Vbtp̗ */
	private Random r = new Random();

	/**
	 * Vbt
	 * @param startIdx
	 * @param endIdx
	 */
	public void shuffle(int startIdx, int endIdx) {
		for (int i = startIdx; i < endIdx; i++) {
			/* ւΏێ擾((i + 1)` endIdx܂) */
			int idx = getRandom(startIdx, endIdx);
			
			/* iԖڂƓւ */
			int tmp = nextInfo[idx];
			nextInfo[idx] = nextInfo[i];
			nextInfo[i] = tmp;
		}
	}
	/* minȏmaxȉ̗ */
	private int getRandom(int min, int max) {
		return r.nextInt(max+1-min) + min;
	}


	/* lNXge[ȕ */
	private void initTable() {
		for (int y = 0; y < nextTable.length; y++) {
			for (int x = 0; x < nextTable[y].length; x++) {
				nextTable[y][x] = Mino._;
			}
		}
	}

	/**
	 * 𕶎(lNXg\p쐬
	 */
	public String toString() {
		/********************************/
		/* lNXg\e[u */
		/********************************/
		initTable();

		/********************************/
		/* lNXg\e[u쐬 */
		/********************************/
		final int x = 2;	/* ~mݒʒu */
		int y = 2;			/* ~mݒʒu */

		for (int i = 0; i < num * debug; i++) {
			/* 擾vf̓Y */
			int typeIdx = (i + nextIdx) % (num * 2);
			
			/* lNXg̎ނ擾 */
			int type = nextInfo[typeIdx];
			
			/* ~m쐬 */
			Mino mino = new Mino(type, x, y);
			
			/* ~mlNXg`e[uɐݒ */
			setMino(mino);
			
			/* e[u̐ݒʒuXV */
			y += 3;
		}

		/********************************/
		/* lNXg\p쐬     */
		/********************************/
		StringBuilder builder = new StringBuilder();
		for (int[] yoko : nextTable) {
			for (int block : yoko) {
				builder.append(block);
			}
			builder.append(System.getProperty("line.separator"));
		}

		return builder.toString();
	}

	/********************************/
	/* lNXg\e[u         */
	/********************************/
	/* ~me[uɐݒ */
	private void setMino(Mino mino) {
		int cnt;
		int type = mino.getType();
		int x = mino.getX();
		int y = mino.getY();
		int[][] info = mino.getInfo();

		/* 3_e[uɐݒ */
		for (cnt = 0; cnt < info.length; cnt++) {
			int offsetX = info[cnt][0];
			int offsetY = info[cnt][1];
			
			nextTable[y + offsetY][x + offsetX] = type;
		}
		/* Se[uɐݒ */
		nextTable[y][x] = type;
	}

}
