package com.haru.tetoru.sample.frame.AI;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

import com.haru.tetoru.parts.Mino;
import com.haru.tetoru.parts.Table;
import com.haru.tetoru.template.Player;

public class AIPlayer extends Player implements KeyListener {

	/* ͂ꂽ */
	private int inputType = OP_NO;

	/********************/
	/* [Uɂ */
	/********************/
	/**
	 *  ʂɓ̓Xi[o^
	 */
	public void registInputListener(MyGameFrame display) {
		display.addKeyListener(this);
	}


	/* ̎ނǂݎiJn҂̂Ƃj*/
	private int readStartOperate() {
		int type = OP_NO;

		/* ͂ǂݎ */
		/* ͂Ȃꍇ́AOP_NO擾ł */
		type = inputType;

		/* ͏ */
		inputType = OP_NO;

		return type;
	}


	@Override
	public void keyPressed(KeyEvent e) {
		int code = e.getKeyCode(); /* L[R[h */

		switch (code) {
		case KeyEvent.VK_DOWN:
			inputType = OP_DOWN;
			break;
		case KeyEvent.VK_RIGHT:
			inputType = OP_RIGHT;
			break;
		case KeyEvent.VK_LEFT:
			inputType = OP_LEFT;
			break;
		case KeyEvent.VK_SPACE:
		case KeyEvent.VK_Z:
			inputType = OP_ROTATE_RIGHT;
			break;
		case KeyEvent.VK_X:
			inputType = OP_ROTATE_LEFT;
			break;
		case KeyEvent.VK_ENTER:
			inputType = OP_START;
			debugFlg = !debugFlg;
			break;
		default:
			inputType = OP_NO;
			break;
		}
	}
	@Override
	public void keyReleased(KeyEvent arg0) {
	}
	@Override
	public void keyTyped(KeyEvent arg0) {
	}


	/**
	 * Q[Jn}҂
	 */
	@Override
	public boolean waitStartSign() {
		int retOperate = OP_NO;

		/* Jn͑҂ */
		while (OP_START != retOperate) {
			/* ͂҂ */
			try {
				Thread.sleep(20);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}

			retOperate = readStartOperate();
		}

		return true;
	}


	/****************/
	/* AIɂ */
	/****************/
	Table table; /* ݂̃e[ȕ */
	Mino current; /* ݂̃~m */
	Queue<Integer> ops = new LinkedBlockingQueue<Integer>(1000); /* AI̓p^[L[ */
											/* ̒ĺAL[̃TCY̏lB(Œł͂Ȃ) */

	boolean debugFlg = false;
	
	public void setTable(Table table) {
		this.table = table;
	}
	public void setCurrentMino(Mino current) {
		this.current = current;
	}
	
	MyGameFrame display;
	public void setDisplay(MyGameFrame display) {
		this.display = display;
	}
	
	private void dispMino(Mino mino, int ms) {
		int type = mino.getType();
		mino.setType(Mino.$);
		table.setMino(mino);
		display.disp(table.toString());
		try {
			Thread.sleep(ms);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		/* u~m폜 */
		table.delMino(mino);
		mino.setType(type);
	}

	
	/* ~mݒuɁAČv */
	public void plan() {

		/* ݂̃~mzu\ȂׂẴ~m̈ʒu擾 */
		/* TODO:IɈړsȈʒuɂĂ擾 */
		Mino[] minos = table.getPuttableMino(current);


		int[] points = new int[minos.length]; /* ]l */
		Mino target = null; /* ړ̃~m(ʒuƏ) */
		int maxPoint = 0;
		int maxIdx = 0;
		
		for (int i = 0; i < minos.length; i++) {
			Mino mino = minos[i];
			/* ]l߂ */
			points[i] = table.getEvalValue(mino);
			
			{
				System.out.println("p : " + points[i]);
//				dispMino(mino, 50);
			}
			
			if (maxPoint < points[i]) {
				maxPoint = points[i];
				maxIdx = i;
			}
		}
		
		/* ]ԍ~m擾(ڕW~m) */
		target = minos[maxIdx];
		
		
		/* ڕW~m݂ȂΏI */
		if (null == target) {
			return;
		}
		
		/*  */
		initializeOperates(table, current, target);
	}
	
	
	/* Iact */
	public void act() {
		if (!ops.isEmpty()) {
			inputType = ops.poll();
		}
	}
	
	/**
	 *  ̎ނǂݎ
	 */
	@Override
	public int readOperate() {
		int type = OP_NO;

		/* ͂ǂݎ */
		/* ͂Ȃꍇ́AOP_NO擾ł */
		type = inputType;

		/* ͏ */
		inputType = OP_NO;

		return type;
	}

	
	/* ɗƂm点 */
	public void notifyDowned() {
		/* ͂폜 */
		
		/* 폜łȂ */
		
			/* 폜łȂꍇA͔zď */
	}
	
	
	
	/**************************************************************************/
	/* 擾															  */
	/**************************************************************************/
	/**
	 * ݃~m(current)ڕW~m(target)Ɉʒu邽߂̑߂B
	 * DTɂŒZ߂B
	 * @̎ށFAEAAE]
	 * @param table
	 * @param current
	 * @param target
	 */
	private void initializeOperates(Table table, Mino current, Mino target) {
		
		/* TʒuɌ݃~m݂ꍇAzułȂƂ݂Ȃ */
		/* ߁Ã݂~m폜ĂB */
		table.delMino(current);

		/* fobOpɖڕW~m\ */
		{
			dispMino(target, 100);
		}

		/**************************************************************************/
		/**************************************************************************/
		Queue<Node> queue = new LinkedBlockingQueue<Node>(1000);
		List<Integer> result = null;
		NodeArray closed = new NodeArray();

		/* GL[ */
		Node root = new Node(OP_NO, current);
		queue.offer(root);
		closed.add(root);
		
		while (true) {
			Node node = queue.poll();

			if (null == node) {
				/* Ȃ߂΂ǁA
				 * uw͂ĂB
				 * 
				 */
				
				
				/* Ōɒǉnode擾 */
				/* TODO:̎dlǂȂ */
				/* I͂QB
				 * 1.targetύX邽߂ɁÅ֐ُIB
				 * 2.closedtargetɍł߂Node擾B
				 */
				Node last = closed.get(closed.size() - 1);
				
				/* fobOpɕ\ */
				{
					dispMino(last.getMino(), 500);
				}
				
				/* Kp */
				Mino tmp = operateNode(last.getMino(), last.getOp());
				if (OP_ROTATE_RIGHT == last.getOp()) {
					if (!table.isSetRotateMino(tmp, Mino.R_RIGHT)) {
						/* zułȂ΁A */
						tmp = last.getMino();
						last.delLatestHistory();
						System.err.println("]s");
						/* fobOpɕ\ */
						{
						dispMino(tmp, 500);
						}
					}
				} else {
					/* downꍇ́APȂ邯ǋCɂȂ */
				}
				
				last.set(OP_DOWN, tmp);
				
				while (true) {
					tmp = operateNode(last.getMino(), last.getOp());
					if (OP_DOWN == last.getOp()) {
						if (!table.isSetMino(tmp, tmp.getX(), tmp.getY())) {
							
							System.out.println("downłȂ̂ŏI");
							break;
						}
					}
					System.out.println("wait a minute!");
					/* fobOpɕ\ */
					{
						dispMino(tmp, 500);
					}
					last.set(OP_DOWN, tmp);
				}
				
				/* 엚擾 */
				result = last.getHistory();
				System.out.println("ߎ");
				break;
			}
			
			
			
			
			/* 擾m[hɑKp */
			Mino tmp = operateNode(node.getMino(), node.getOp());

			System.out.println(node.getMino() + " " + node.getOp());

			
			/* tmpe[uɔzu\ */
			if (OP_ROTATE_RIGHT == node.getOp()) {
				if (!table.isSetRotateMino(tmp, Mino.R_RIGHT)) {
					/* zułȂ΁ǍoHT */
					node.delLatestHistory();
					continue;
				}
			} else {
				if (!table.isSetMino(tmp, tmp.getX(), tmp.getY())) {
					/* zułȂ΁ǍoHT */
					node.delLatestHistory();
					continue;
				}
			}
			
			if (debugFlg) {			
				/* fobOpɉu */
				table.setMino(tmp);
				display.disp(table.toString());
				try {
					Thread.sleep(100);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				/* u~m폜 */
				table.delMino(tmp);
			}
			
			if (tmp.equals(target)) {
				/* v */
				result = node.getHistory(); /* ŒZoH1I */
				break;
			}
			
			
			/* ₪Kł΃GL[(ǉ鏇=̗Dx) */
			/*  */
			Node down = new Node(OP_DOWN, tmp);
			if (!closed.contains(down)) {
				Node cloned = node.clone();
				cloned.set(OP_DOWN, tmp);
				queue.offer(cloned);
				/* KƂ */
				closed.add(cloned);
			}
			Node left = new Node(OP_LEFT, tmp);
			if (!closed.contains(left)) {
//					&& OP_RIGHT != node.getOp()) {
				Node cloned = node.clone();
				cloned.set(OP_LEFT, tmp);
				queue.offer(cloned);
				/* KƂ */
				closed.add(cloned);
			}

			Node right = new Node(OP_RIGHT, tmp);
			if (!closed.contains(right)) {
//					&& OP_LEFT != node.getOp())	{
				Node cloned = node.clone();
				cloned.set(OP_RIGHT, tmp);
				queue.offer(cloned);
				/* KƂ */
				closed.add(cloned);
			}
			Node rotateR = new Node(OP_ROTATE_RIGHT, tmp);
			if (!closed.contains(rotateR)) {
				Node cloned = node.clone();
				cloned.set(OP_ROTATE_RIGHT, tmp);
				queue.offer(cloned);
				/* KƂ */
				closed.add(cloned);
			}
		}
		/**************************************************************************/
		/**************************************************************************/
		
		System.out.println(result);
		
		/* ݂̃~m𕜊 */
		table.setMino(current);
		
		/* Ts */
		if (null == result) {
			return;
		}

		/* 擾ʂL[ɕϊāAɐݒ */
		ops.addAll(result);
		/* 	ǉ(ړȂĂ邽) */
		ops.offer(OP_DOWN);
		
		return;
	}
	
	private Mino operateNode(Mino node , int op) {
		
		Mino tmp = node.clone();
		
		switch (op) {
		case OP_LEFT:
			tmp.setX(node.getX() - 1);
			break;
		case OP_RIGHT:
			tmp.setX(node.getX() + 1);
			break;
		case OP_DOWN:
			tmp.setY(node.getY() + 1);
			break;
		case OP_ROTATE_RIGHT:
			tmp.rotateMinoType(Mino.R_RIGHT);
			break;
		case OP_NO:
			/* do nothing */
			break;
		}
		
		return tmp;
	}
	
	
	class Node implements Cloneable {
		private Integer op;
		private Mino mino;
		
		private List<Integer> history;
		
		Node(Integer op, Mino mino) {
			this.op = op;
			this.mino = mino;
			
			history = new ArrayList<Integer>();
			history.add(op);
		}
		
		public boolean equals(Node node) {
			return op.equals(node.op) && mino.equals(node.mino);
		}

		public int hashCode() {
			int result = 17;
			result = 31 * result + op;
			result = 31 * result + mino.hashCode();
			return result;
		}
		
		
		public String toString() {
			return op.toString() + "(" + mino.getX() + ", " + mino.getY() +")\t" + history.toString();
		}
		
		Integer getOp() {
			return op;
		}
		Mino getMino() {
			return mino;
		}
		
		void set(Integer i, Mino p) {
			this.op = i;
			this.mino = p;
			history.add(this.op);
		}
		
		public Node clone() {  
			try {
				Node cloned = (Node)super.clone();  
				
				/* history͐mɃRs[ */
				cloned.history = new ArrayList<Integer>();
				cloned.history.addAll(history);
				
				return cloned;
			} catch (CloneNotSupportedException e) {  
				return null;  
			}  
		}
		
		List<Integer> getHistory() {
			return history;
		}
		
		void delLatestHistory() {
			history.remove(history.size() - 1);
		}
	}

	/* ArrayListcontainsOŎ */
	class NodeArray {
		ArrayList<Node> nodes;
		NodeArray() {
			nodes = new ArrayList<Node>();
		}
		boolean add(Node n) {
			return nodes.add(n);
		}
		int size() {
			return nodes.size();
		}
		Node get(int index) {
			return nodes.get(index);
		}
		
		boolean contains(Node n) {
			for (int i = 0; i < nodes.size(); i++) {
				if (n.equals(nodes.get(i))) {
					return true;
				}
			}
			return false;
		}
	}
}

