package com.torn.player;

import java.util.ArrayList;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;

import com.torn.enemy.AtomMoveManager;

public class PlayerManager {
	private static PlayerManager playerManager = new PlayerManager();
	private static final int LIMIT_SIZE = 10;
	private ArrayList<Atom> atoms = new ArrayList<Atom>();
	
	private PlayerManager() {
	}
	public static PlayerManager getInstance() {
		return playerManager;
	}

	public synchronized boolean addAtom(float x, float y) {
		if (atoms.size() > LIMIT_SIZE) {
			/*  */
			atoms.remove(0);
			if (atoms.size() > LIMIT_SIZE) {
				System.err.println("ĂȂ");
			}
		}
		atoms.add(new Atom(x, y));
		return true;
	}

	/******************/
	/* ʂ̈ړEXV */
	/******************/
	public void update() {
		if (atoms.isEmpty()) {
			return;
		}

		/* ړ */
		move();

		/* 蔻 */
		hitCheck();
		
		/* S~ */
		Atom[] array = atoms.toArray(new Atom[0]);
		for (int i = 0; i < array.length; i++) {
			if (array[i].y <  25) { // 
				atoms.remove(i);
			}
		}
	}

	private static final int VEROCITY_Y = -4;
	public  void move() {
		if (atoms.isEmpty()) {
			return;
		}

		/* ړ */
		Atom[] array = atoms.toArray(new Atom[0]);
		for (int i = 0; i < array.length; i++) {
			array[i].y = array[i].y + VEROCITY_Y;
		}
	}

	private boolean hitCheck() {
		Atom[] array = atoms.toArray(new Atom[0]);		
		boolean hitFlg = false;

		// G0ԖڂĂȂ(̏)
		Point enemyPt = AtomMoveManager.getInstance().getAtomPoint(0);
		if (null == enemyPt) {
			return false;
		}

		int enemyR = AtomMoveManager.getInstance().getAtomRadius();

		// ʂ͈_
		for (int i = 0; i < array.length; i++) {
			Atom playerPt = array[i];
	
			if (enemyPt.x - enemyR <= playerPt.x  && playerPt.x <= enemyPt.x + enemyR &&
				enemyPt.y - enemyR <= playerPt.y  && playerPt.y <= enemyPt.y + enemyR) {
				AtomMoveManager.getInstance().removeAtom(0);
				hitFlg = true;
			}
		}
	
	return hitFlg;
	}
	
	/********/
	/* ` */
	/********/
	private static final int ATOM_RADIUS = 6;
	public void paint(Canvas canvas) {
		if (atoms.isEmpty()) {
			return;
		}

		Paint paint = new Paint();
		paint.setColor(Color.GREEN);
		Atom[] array = atoms.toArray(new Atom[0]);
		for (int i = 0; i < array.length; i++) {
			canvas.drawCircle(array[i].x, array[i].y, ATOM_RADIUS, paint);
		}
	}
}
