package com.torn.toy;

import android.content.Context;
import android.graphics.Canvas;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;

import com.torn.enemy.AtomMoveManager;
import com.torn.enemy.MyEnemy;
import com.torn.player.PlayerManager;

public class MyGameView extends View implements View.OnTouchListener, Runnable {
	public MyGameView(Context context) {
		super(context);
		setOnTouchListener(this);
	}

	/********************/
	/* vC[̑ */
	/********************/
	public boolean onTouch(View v, MotionEvent event) {
		if (0 == event.getAction()) {
			PlayerManager.getInstance().addAtom(event.getX(), event.getY());
			Log.v("touch", "p:" + event.getX() + "," + event.getY());
		}
		return true;
	}

	/*************/
	/* game loop */
	/*************/
	public void run() {
		/* initialize */
		MyEnemy enemy = new MyEnemy();
		AtomMoveManager.getInstance().addAllAtom(enemy.getAtoms());

		while (true) {
			PlayerManager.getInstance().update();

			/* CXbhȊOUIXV */
			this.post(new Runnable() {
				public void run() {
					invalidate();
				}			
			});

			try {
				Thread.sleep(1000 / 40);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	/********/
	/* ` */
	/********/
	@Override
	public void onDraw(Canvas canvas) {
		PlayerManager.getInstance().paint(canvas);
		AtomMoveManager.getInstance().paint(canvas);
	}
}