# -*- mode: perl; coding: utf-8 -*-
# Keitairc::Config
# $Id: Config.pm,v 1.31 2009-01-03 07:28:15 nyan_ Exp $
# $Source: /home/ishikawa/work/keitairc/tmp/keitairc/lib/Keitairc/Config.pm,v $
#
# Copyright (c) 2008 Jun Morimoto <morimoto@mrmt.net>
# This program is covered by the GNU General Public License 2

package Keitairc::Config;
use AppConfig qw(:argcount);
use Cwd;
use strict;
use warnings;
our @ISA = qw(AppConfig);

################################################################
sub new{
	my $class = shift;
	my $arg = shift;
	my @argv = @{$arg->{argv}};
	my $me = $class->SUPER::new(
		{
			CASE => 1,
			GLOBAL => {
				ARGCOUNT => ARGCOUNT_ONE,
			}
		},
		qw(irc_nick irc_username irc_desc
		   irc_server irc_port irc_password
		   irc_keyword irc_charset
		   au_subscriber_id au_pcsv
		   docomo_foma_icc docomo_imodeid
		   softbank_serial_key emobile_userid
		   use_cookie cookie_ttl session_ttl
		   web_listen_port
		   web_port web_title web_lines web_root web_schema
		   web_username web_password web_host web_charset
		   extra_header fontsize mobile_fontsize silent_config
		   show_newmsgonly show_joinleave show_console
		   ping_delay reconnect_delay follow_nick
		   smtp_server smtp_from smtp_to debug
		   version daemonize pid_dir pid_file
		   template_dir plugin_dir public_dir
		   url_target url_redirect
		   rgeocode_server
		   reverse_message reverse_recent reverse_unread)
		);

	# set default values
	$me->version($arg->{version});
	$me->silent_config($arg->{silent});
	$me->irc_desc('keitairc');
	$me->irc_port(6667);
	$me->irc_charset('iso-2022-jp-1');
	$me->web_port(8080);
	$me->web_title('keitairc');
	$me->web_lines(100);
	$me->web_root('/');
	$me->web_charset('shiftjis');
	$me->web_schema('http');
	$me->ping_delay(30);
	$me->reconnect_delay(10);
	$me->cookie_ttl(86400 * 3);  # 3 days
	$me->session_ttl(60 * 30);  # 30 min
	$me->pid_dir('/var/run');
	$me->pid_file('keitairc.pid');
	$me->plugin_dir(getcwd() . '/lib/plugins:/usr/share/keitairc/lib/plugins');
	$me->template_dir(getcwd() . '/lib/templates:/usr/share/keitairc/lib/templates');
	$me->public_dir(getcwd() . '/lib/public:/usr/share/keitairc/lib/public');
	$me->reverse_message(1);
	$me->reverse_recent(1);
	$me->reverse_unread(1);
	$me->show_joinleave(1);
	$me->show_console(0);
	$me->fontsize('+0');
	$me->mobile_fontsize(-1);
	$me->url_target('_self');
	$me->follow_nick(1);
	$me->rgeocode_server('refits');
	$me->debug(0);
	$me->daemonize(0);

	if(-r '/etc/keitairc'){
		$me->file('/etc/keitairc');
	}
	if(-r $ENV{HOME} . '/.keitairc'){
		$me->file($ENV{HOME} . '/.keitairc');
	}

	if(defined $argv[0]){
		if(-r $argv[0]){
			$me->file($argv[0]);
			shift(@argv);
		}
	}

	$me->args(\@argv);

	if(defined $me->show_newmsgonly()){
		Keitairc::Log::log('show_newmsgonly has obsoleted from keitairc 2.0');
	}

	if(defined $me->web_username()){
		Keitairc::Log::log('web_username has obsoleted from keitairc 2.0');
	}

	if(defined $me->use_cookie()){
		Keitairc::Log::log('use_cookie has obsoleted from keitairc 2.0');
	}

	if(defined $me->au_pcsv()){
		Keitairc::Log::log('au_pcsv has obsoleted from keitairc 2.0');
	}

	if(!defined($me->irc_nick()) || !length($me->irc_nick())){
		Keitairc::Log::log_die('irc_nick does not specified');
	}

	if(!defined($me->irc_username()) || !length($me->irc_username())){
		Keitairc::Log::log_die('irc_username does not specified');
	}

	if(!defined($me->irc_server()) || !length($me->irc_server())){
		Keitairc::Log::log_die('irc_server does not specified');
	}

	if(!defined($me->web_listen_port()) || !length($me->web_listen_port())){
		$me->web_listen_port($me->web_port());
	}

	if(!defined($me->web_host()) || !length($me->web_host())){
		Keitairc::Log::log_die('web_host does not specified');
	}

	if(!defined($me->web_password()) || !length($me->web_password())){
		Keitairc::Log::log_die('web_password does not specified');
	}

	$me;
}

################################################################
sub file{
	my $me = shift;
	my $file = shift;
	if(-r $file){
		$me->SUPER::file($file);
		Keitairc::Log::log("Loaded configuration file: $file")
			unless $me->silent_config();
		return;
	}
	Keitairc::Log::log("$file does not exist");
}

1;
