package uriagesum;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author ishimizu
 */
public class UriageSum {

    private final List<MasterData> branchData;
    private final List<MasterData> brandData;
    private final List<UriageData> uriageData;

    private final String SHITEN_FILE = "shiten.csv";
    private final String SHOHIN_FILE = "shohin.csv";
    private final String URIAGE_FILE = "uriage.csv";
    private final String OUTPUT_FILE = "output.csv";

    public UriageSum() {
        String dir = "";

        // 支店ファイル読み込み
        File branchFile = new File(SHITEN_FILE);
        branchData = readCsvData(branchFile);

        // 商品ファイル読み込み
        File brandFile = new File(SHOHIN_FILE);
        brandData = readCsvData(brandFile);

        // 売上データ
        File uriageFile = new File(URIAGE_FILE);
        uriageData = getUriageData(uriageFile);

        if (uriageData != null) {
            // 並び替え（支店順で商品順）
            Collections.sort(uriageData, new UriageComparator());

            // 集計処理
            long kingaku;
            Object bc1, bc2, brc1, brc2;
            String sa1, sa2;
            for (int n = uriageData.size() - 1; n >= 1; n--) {
                bc1 = uriageData.get(n).getBranchCode();
                bc2 = uriageData.get(n - 1).getBranchCode();
                brc1 = uriageData.get(n).getBrandCode();
                brc2 = uriageData.get(n - 1).getBrandCode();
                sa1 = uriageData.get(n).getSalesAmount();
                sa2 = uriageData.get(n - 1).getSalesAmount();
                if (bc1.equals(bc2) && brc1.equals(brc2)) {
                    kingaku = Long.parseLong(sa1) + Long.parseLong(sa2);
                    uriageData.get(n - 1).setSalesAmount(String.valueOf(kingaku));
                    uriageData.remove(n);
                }
            }

            // 店名、品名セット
            int bcode;
            for (UriageData ud : uriageData) {
                bcode = getCodeSearch(branchData, ud.getBranchCode());
                if (bcode != -1) {
                    ud.setBranchName(branchData.get(bcode).getName());
                } else {
                    System.out.println(" not found");
                }
                bcode = getCodeSearch(brandData, ud.getBrandCode());
                if (bcode != -1) {
                    ud.setBrandName(brandData.get(bcode).getName());
                } else {
                    System.out.println(" not found");
                }
            }
            
            // 売上集計表示
            System.out.println("店番　：　店名　：　品番　：　品名　：　売上金額");
            for (UriageData ud : uriageData) {
                System.out.print(" " + ud.getBranchCode());
                System.out.print("    :  " + ud.getBranchName());
                System.out.print(" : " + ud.getBrandCode());
                System.out.print("   : " + ud.getBrandName());
                System.out.println("   : " + ud.getSalesAmount());
            }
            
            // CSVデータ出力
            File f = new File(OUTPUT_FILE);
            writeCsvData(f);
        }

    }

    private void writeCsvData(File f) {
        FileOutputStream fos = null;
        BufferedWriter bw = null;

        try {
            fos = new FileOutputStream(f);
            OutputStreamWriter osw = new OutputStreamWriter(fos, "utf8");
            bw = new BufferedWriter(osw);

            String str;
            int n = 0;
            for (UriageData ud : uriageData) {
                str = ud.getBranchCode() + "," + ud.getBranchName() + ","
                        + ud.getBrandCode() + "," + ud.getBrandName() + ","
                        + ud.getSalesAmount();

                bw.write(str);
                if (n != uriageData.size() - 1) {
                    bw.newLine();
                }
            }

        } catch (FileNotFoundException | UnsupportedEncodingException ex) {
            Logger.getLogger(UriageSum.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(UriageSum.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            } catch (IOException ex) {
                Logger.getLogger(UriageSum.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

    }

    private int getCodeSearch(List<MasterData> list, String cd) {
        int index = -1;
        int n = 0;
        
        for (MasterData md : list) {
            if (md.getCode().equals(cd)) {
                index = n;
                break;
            } else {
                n++;
            }
        }

        return index;
    }

    /**
     * マスターCSVデータ読み込み
     *
     * @param f
     * @return
     */
    private List<MasterData> readCsvData(File f) {

        List<MasterData> list = new ArrayList<>();

        try (BufferedReader br = new BufferedReader(new FileReader(f))) {
            String line;

            while ((line = br.readLine()) != null) {
                // 1行をデータの要素に分割
                String[] data = line.split(",");

                //配列の長さ
                if (data.length != 2 || data[0].equals("") || data[1].equals("")) {
                    System.out.println("CSVファイルフォーマットが不正です");
                    list = null;
                    break;
                } else {
                    MasterData mdata = new MasterData();
                    mdata.setCode(data[0]);
                    mdata.setName(data[1]);
                    list.add(mdata);
                }
            }

        } catch (FileNotFoundException ex) {
            Logger.getLogger(UriageSum.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(UriageSum.class.getName()).log(Level.SEVERE, null, ex);
        }
        return list;

    }

    private List<UriageData> getUriageData(File f) {
        // 売上データファイルの処理

        if (!f.exists()) {
            System.out.println("売上データファイルが存在しません");
            return null;
        }

        List<UriageData> uData = new ArrayList<>();

        try (BufferedReader br = new BufferedReader(new FileReader(f))) {
            String line;
            while ((line = br.readLine()) != null) {
                // 1行をデータの要素に分割
                String[] data = line.split(",");

                //配列の長さ
                if (data.length != 3 || data[0] == null || data[1] == null) {
                    System.out.println("売上データのフォーマットが不正です");
                    return null;
                } else if (data[0].equals("店番")) {

                } else {

                    UriageData udata = new UriageData();
                    udata.setBranchCode(data[0]);
                    udata.setBrandCode(data[1]);
                    udata.setSalesAmount(data[2]);
                    uData.add(udata);
                }
            }

        } catch (FileNotFoundException ex) {
            Logger.getLogger(UriageSum.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(UriageSum.class.getName()).log(Level.SEVERE, null, ex);
        }
        return uData;
    }

    /**
     * @param args
     */
    public static void main(String args[]) {
        UriageSum us = new UriageSum();
    }

}
