#include "TCPIPConfig.h"

#include "TCPIP Stack/TCPIP.h"
#include "TCPIP Stack/StackTsk.h"
#include "MDD File System/FSIO.h"
#include "MDD File System/FSDefs.h"


#include <stdlib.h>
#include <ctype.h>
#include "GenericTypeDefs.h"
#include "HardwareProfile.h"
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "lcd.h"
#include <time.h>
#include "node.h"

void	GetRefDateTime(void);
void	flushData(void);
BOOL	callsign_check (BYTE callsign[]);
BYTE	MsgPlay (BYTE resync, BYTE FileName[]);
BYTE	CallSignPlay (BYTE CallSign[], BYTE resync);
void	ConnectMSG (BYTE CallSign[]);
BYTE	SendConnectMsg(BYTE CallSign[], BYTE resync);
BOOL	MACWriteArray(BYTE address, BYTE AppConfig[], WORD length);
void	MACReadArray(BYTE address, BYTE AppConfig[], WORD length);
static	void	AccessFileRead(void);
static	void	DPRS_FileRead(void);
static	void	DPRS_FileWrite(void);
static	BOOL	DprsMsgCallSignCheck (void);
static	void	DprsAccessFileRead(void);
static	void	AprsSeqReadWrite(void);
static	void	AprsSeqReadWrite(void);
static	void	LoadAprsCallCheck(void);
static	void	ConvertLocalRefFile(void);

struct	AprsCallTable	*AprsCallTablePnt = NULL;
BOOL	ReqLoadAprsCallCheck;

extern	BYTE	TimeDate[20];

extern	BYTE	MACReadWriteSW;

static	SearchRec recFile;
static	BYTE	attr = ATTR_READ_ONLY | ATTR_ARCHIVE;
static	FSFILE	*LocalRefFile;
static	FSFILE	*RefFile;
static	FSFILE	*LogFile;
static	FSFILE	*accctl;
static	FSFILE	*AprsAccFile;
static	FSFILE	*AprsSeqFile;

extern	xLCDMessage xMessage;

static	BYTE	temp[120];

BOOL	CallCheck_Skip;

extern	APP_CONFIG newAppConfig;

extern	struct	RefDateTime RDateTime;
extern	BYTE	REF_IP_address[16];
BYTE	Radio_Callsign_Check_String[9];
BYTE	Inet_Callsign_Check_String[9];
BYTE	DprsMsgDstCallSign[10];
BYTE	DprsMsgSrcCallSign[10];
BOOL	DprsAccessFileReadSW;
extern	xTaskHandle FSHandle;
extern	BYTE HeaderID[2];
extern	BYTE VoiceID[2];
extern	BYTE LastFrameID[2];
extern	BYTE LinkID[2];
extern	xQueueHandle xDstarRcvQueue;
extern	xQueueHandle xDstarRefQueue;
extern	xQueueHandle xDstarLogQueue;
extern	xQueueHandle xDstarHttpQueue;
extern	xQueueHandle xDstarAccQueue;
extern	xQueueHandle xDstarDprsAccQueue;
void	GetTimeDate(void);
extern	struct	MessageSW	Msg;
extern	BYTE	RefName[8];
extern	BOOL	ReqRefList;
extern	BYTE	RefSkipSW;
extern	BOOL	FWUpdate;
extern	BOOL	AccessFileReadSW;
extern	BYTE	DPRS_SW;
extern	BYTE	AprsMsgTX[3];
extern	BYTE	EmailAddress[48];
extern	BOOL	ReqAprsSeq;
extern	DWORD	AprsSeq;
extern	BOOL	DprsOpen;
extern	BOOL	DebugSW;

extern	BOOL	ReqConvertLocalRefFile;
extern	BOOL	ReqRefDomainName;
extern	BYTE	RefDomainName[110];

int prvTaskFS ( void )
{
	static	BYTE	i;
	static	BYTE	len;

	LogFile = NULL;

    while (1)
    {
		while (xQueueReceive(xDstarRefQueue, &temp, 5 / portTICK_RATE_MS) == pdTRUE)
		{
			if(temp[0] == 'O')
			{
				RefFile = FSfopen (TempRefListFileName, FS_WRITE);
				if (!FindFirst(TempLocalRefListFileName, attr, &recFile))
				{
					LocalRefFile = FSfopen (TempLocalRefListFileName,FS_READ);
					if (LocalRefFile)
					{
						len = FSfread (temp, 26, 1, LocalRefFile);
						while (len)
						{
							for (i = 0 ; i < len ; i++)
							{
								if (temp[i] <= 0x20) temp[i] = 0x00; 
							}
							if (len <= 26)
							{	
								for (i = len ; i < 26 ; i++)
								{
									temp[i] = 0x00; 
								}
							}
							for (i = 16 ; i < 24 ; i++)
							{
								if (temp[i] == 0x00) temp[i] = 0x20; 
							}
							
							FSfwrite (temp, 26, 1, RefFile);
							len = FSfread (temp, 26, 1, LocalRefFile);
						}
					}
					if (LocalRefFile)	FSfclose (LocalRefFile);
				}
			}
			else if(temp[0] == 'C')
			{
				flushData();
				if (!FindFirst(RefListFileName, attr, &recFile))
											FSremove (RefListFileName);
				FSrename (RefListFileName, RefFile);
				FSfclose (RefFile);
				LogFile = FSfopen (LOGFILE, FS_APPEND);
				FSfprintf (LogFile, "%19.19s Gateway list replaces from old to new one.\r\n",TimeDate); 
				flushData();
				FSfclose (LogFile);
				LogFile = NULL;
				GetRefDateTime();
				if (!FindFirst(TempLocalRefListFileName, attr, &recFile)) FSremove (TempLocalRefListFileName);
			}
			else if (temp[0] == 'P')
			{
				if (FindFirst(RefListFileName, attr, &recFile))
				{								/* not found */
					flushData();
					FSrename (RefListFileName, RefFile);
					FSfclose (RefFile);
					LogFile = FSfopen (LOGFILE, FS_APPEND);
					FSfprintf (LogFile, "%19.19s Gateway list uses new one.\r\n",TimeDate); 
				} else {						/* found */
					flushData();
					FSfclose (RefFile);
					RefFile = NULL;
					FSremove (TempRefListFileName);
					LogFile = FSfopen (LOGFILE, FS_APPEND);
					FSfprintf (LogFile, "%19.19s Gateway list does not replace from old to new one.\r\n",TimeDate); 
				}
				flushData();
				FSfclose (LogFile);
				LogFile = NULL;
				GetRefDateTime();
			}
			else
			{
				FSfwrite (temp, 26, 1, RefFile);
			}
		}

		/****************/
		if(RefSkipSW == 'F')
		{
			if (!FindFirst(RefListFileName, attr, &recFile))
			{
				RefSkipSW = 'S';
				GetRefDateTime();
			}
			else
			{
				RefSkipSW = 'N';
			}
		}

		/**** log file ***********/
		while (xQueueReceive(xDstarLogQueue, &temp, 0) == pdTRUE)
		{
			if (!LogFile) LogFile = FSfopen (LOGFILE, FS_APPEND);
			FSfprintf (LogFile, "%s",temp);
		}
		if (LogFile)
		{
			flushData();
			FSfclose (LogFile);
			LogFile = NULL;
		}

		/* callsign check */
		if (Radio_Callsign_Check_String[8] == 'S')
		{
			if (callsign_check(Radio_Callsign_Check_String)) Radio_Callsign_Check_String[8] ='F';
			else Radio_Callsign_Check_String[8] = 'N';
		}

		if (Inet_Callsign_Check_String[8] == 'S')
		{
			if (callsign_check(Inet_Callsign_Check_String)) Inet_Callsign_Check_String[8] ='F';
			else Inet_Callsign_Check_String[8] = 'N';
		}

		/* Ref2IP */
		if (REF_IP_address[15] == 'S')
		{
			RefFile = FSfopen(RefListFileName,FS_READ);
			if (FSerror() == CE_GOOD)
			{
				while (FSfread (temp, 26, 1,  RefFile))
				{
					for (i = 0 ; i < 7 ; i++)
					{
						if (temp[i+16] == 0x00) temp[i+16] = 0x20;
					}
					if (!memcmp ((char *)REF_IP_address, (char *)&temp[16], 7))
					{
						if (DebugSW)
						{
							LogFile = FSfopen (LOGFILE, FS_APPEND);
							FSfprintf (LogFile, "%19.19s %8.8s found in Gate/Ref. list. (%s)\r\n",TimeDate,&temp[16],temp); 
							flushData();
							FSfclose (LogFile);
							LogFile = NULL;
						}
						memcpy (REF_IP_address, temp, 16);
						goto	next;
					}
				}
				if (DebugSW)
				{
					LogFile = FSfopen (LOGFILE, FS_APPEND);
					FSfprintf (LogFile, "%19.19s %8.8s not found in Gate/Ref. list.\r\n",TimeDate,&temp[16]); 
					flushData();
					FSfclose (LogFile);
					LogFile = NULL;
				}
				memset (REF_IP_address, 0x00, 16);
next:
				FSfclose (RefFile);
			}
			else
			{
				if (DebugSW)
				{
					LogFile = FSfopen (LOGFILE, FS_APPEND);
					FSfprintf (LogFile, "%19.19s %s not found in Gate/Ref. file.\r\n",TimeDate, RefListFileName); 
					flushData();
					FSfclose (LogFile);
					LogFile = NULL;
				}
				memset (REF_IP_address, 0x00, 16);
			}
		}

		/* callsign check for DPRS Message */
		if (DprsMsgDstCallSign[9] == 'S')
		{
			if (DprsMsgCallSignCheck()) DprsMsgDstCallSign[9] = 'F';
			else DprsMsgDstCallSign[9] = 'N';
		}


		if (MACReadWriteSW)
		{
			if (MACReadWriteSW == 1) MACReadArray (0x00,(BYTE *)&AppConfig, sizeof(AppConfig));
			else if (MACReadWriteSW == 2) MACWriteArray (0x00,(BYTE *)&AppConfig, sizeof(AppConfig));
			else if (MACReadWriteSW == 3) MACReadArray (0x00,(BYTE *)&newAppConfig, sizeof(newAppConfig));
			else if (MACReadWriteSW == 4) MACWriteArray (0x00,(BYTE *)&newAppConfig, sizeof(newAppConfig));
			MACReadWriteSW = 0;
		}

		if (Msg.connectSW)
		{
			ConnectMSG (RefName);
			Msg.connectSW = FALSE;
		}

		if (AccessFileReadSW) AccessFileRead();
		AccessFileReadSW = FALSE;
		if (DprsAccessFileReadSW) DprsAccessFileRead();
		DprsAccessFileReadSW = FALSE;

		/*****  Gate/Ref list read *****/
		if (ReqRefList)
		{
			ReqRefList = FALSE;
			RefFile = FSfopen(RefListFileName, FS_READ);
			if (FSerror() != CE_GOOD) for ( ; ; );
			if (RefFile)
			{
				while (FSfread (temp, 26, 1,  RefFile))
				{
					xQueueSend( xDstarHttpQueue, &temp[16], portMAX_DELAY );
				}
				FSfclose (RefFile);
			}
			temp[0] = 0xff;
			xQueueSend( xDstarHttpQueue, temp, portMAX_DELAY );
		}

		if (DPRS_SW == 1) DPRS_FileRead(); 
		else if (DPRS_SW == 2) DPRS_FileWrite();
		DPRS_SW = 0;

		if (ReqAprsSeq) AprsSeqReadWrite();
		ReqAprsSeq = FALSE;

		if (ReqLoadAprsCallCheck && DprsOpen) LoadAprsCallCheck();
		ReqLoadAprsCallCheck = FALSE;

		if (ReqConvertLocalRefFile) ConvertLocalRefFile();
		ReqConvertLocalRefFile = FALSE;

		GetTimeDate();
	}
} // main

void	GetRefDateTime()
{
	static	BYTE	attr = ATTR_READ_ONLY | ATTR_ARCHIVE;

   	if (FindFirst  ("REFLIST.TXT", attr, &recFile))
	{
		RDateTime.seconds = 0;
		RDateTime.minutes = 0;
		RDateTime.hours = 0;
		RDateTime.day = 0;
		RDateTime.month = 0;
		RDateTime.year = 0;
		RDateTime.cnt = 0;
	}
	else
	{	
		RDateTime.seconds = recFile.timestamp & 0x00000001f * 2;
		RDateTime.minutes =  (recFile.timestamp >> 5) & 0x00000003f;
		RDateTime.hours   =  (recFile.timestamp >> 11) & 0x00000001f;
		RDateTime.day     =  (recFile.timestamp >> 16) & 0x00000001f;
		RDateTime.month   =  (recFile.timestamp >> 21) & 0x00000000f;
		RDateTime.year    =  (recFile.timestamp >> 25);
		RDateTime.year   += 1980;
		RDateTime.cnt     = recFile.filesize/26;
	}
}

BOOL	callsign_check (BYTE CallSign[])	/* MyCallSign field Check */
{
	char	buf[15],str[15];
	static	char	*token;
	WORD	length, len, i;
	xLCDMessage xMessage;
	BOOL	skip;
	skip = FALSE;
	accctl = FSfopen (AccessCtrl, FS_READ);
	if (FSerror() != CE_GOOD) for ( ; ; );
	if (accctl == NULL)
	{
			len = sizeof(AccessCtrl);
			memcpy (&temp[0],"file not found  ", 16);
			memcpy (&temp[16], AccessCtrl, len);
			xMessage.pcMessage = (char *)&temp[0];
 			xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
			xQueueSend( xLCDQueue, &xMessage, 0 );
			if (DebugSW)
			{
				LogFile = FSfopen (LOGFILE, FS_APPEND);
				FSfprintf (LogFile, "%19.19s AccessControl file not found %s.\r\n",TimeDate, AccessCtrl);
				flushData();
				FSfclose (LogFile);
				LogFile = NULL;
			}
			CallCheck_Skip = TRUE;
			return FALSE;
	}

	len = FSfread (buf, 15, 1,  accctl);
	while (len)
	{
		memcpy ((char *)str, (char *)buf, len);
		if (str[len-1] == 0x0a)
		{
			str[len-1] = 0x00;
			len -= 1;
			skip = TRUE;
		}
		token = str;
		for (i = 0 ; i < len ; i++)
		{
			*token = toupper (*token);
			token++;
		}
		while (!skip)
		{
			len = FSfread (buf, 15, 1,  accctl);
			if (buf[len-1] == 0x0a) skip = TRUE;
		}
		length = 8;
		for (i = 0 ; i <= 7 ; i++)
		{
			if (str[7-i] == '*')
			{
				length = 7 - i;
				break;
			}		
		}
		if (length == 0) length = 8;

		if (!memcmp (str, "*", 1))
		{
			if (str[8] == 'D')
			{
				FSfclose (accctl);
				return FALSE;
			}
			if (str[8] == 'A')
			{
				FSfclose (accctl);
				return TRUE;
			}
		}
		else if (!memcmp (str, CallSign, length))
		{ 
			if (str[8] == 'D')
			{
				FSfclose (accctl);
				return FALSE;
			}
			if (str[8] == 'A')
			{
				FSfclose (accctl);
				return TRUE;
			}
		}
		len = FSfread (buf, 15, 1,  accctl);
		skip = FALSE;
	}
	FSfclose (accctl);
	return FALSE;
}


void	AccessFileRead()
{
	char	buf[15],str[15];
	static	char	*token;
	WORD	len, i;
	xLCDMessage xMessage;
	static	BOOL	skip;
	skip = FALSE;
	accctl = FSfopen (AccessCtrl, FS_READ);
	if (FSerror() != CE_GOOD)//  for ( ; ; );
//	if (accctl == NULL)
	{
			len = sizeof(AccessCtrl);
			memcpy (&temp[0],"file not found  ", 16);
			memcpy (&temp[16], AccessCtrl, len);
			xMessage.pcMessage = (char *)&temp[0];
 			xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
			xQueueSend( xLCDQueue, &xMessage, 0 );
			LogFile = FSfopen (LOGFILE, FS_APPEND);
			FSfprintf (LogFile, "%19.19s AccessControl file not found %s.\r\n",TimeDate, AccessCtrl);
			flushData();
			FSfclose (LogFile);
			LogFile = NULL;
			CallCheck_Skip = TRUE;
			str[0] = 0xff;
			xQueueSend( xDstarAccQueue, &str, portMAX_DELAY );
			return;
	}

	len = FSfread (buf, 15, 1,  accctl);
	while (len)
	{
		memcpy ((char *)str, (char *)buf, len);
		if (str[len-1] == 0x0a)
		{
			str[len-1] = 0x00;
			len -= 1;
			skip = TRUE;
		}
		token = str;
		for (i = 0 ; i < len ; i++)
		{
			*token = toupper (*token);
			token++;
		}
		while (!skip)
		{
			len = FSfread (buf, 15, 1,  accctl);
			if (buf[len-1] == 0x0a) skip = TRUE;
		}

		xQueueSend( xDstarAccQueue, &str, portMAX_DELAY );
		len = FSfread (buf, 15, 1,  accctl);
		skip = FALSE;
	}
	FSfclose (accctl);
	str[0] = 0xff;
	xQueueSend( xDstarAccQueue, &str, portMAX_DELAY );
	return;
}

static	packet	fs_pkt;
extern	BYTE	NullVoice0[12];
extern	BYTE	NullVoice1[12];
extern	BOOL	VoiceMsg;
static	BYTE 	LastFrame[15] = {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x55,0x55,0x55,0xc8,0x7a};

void	ConnectMSG (BYTE CallSign[])
{
	static	BYTE	resync;

	resync = 0;

	memset (&fs_pkt.header, 0x00, 41);
	memcpy (&fs_pkt.header[3], "DIRECT  DIRECT  ", 16);
	memcpy (&fs_pkt.header[19], CallSign, 8);
	memcpy (&fs_pkt.header[27], AppConfig.DefaultNodeName, 8);
	memcpy (&fs_pkt.header[35], "    ", 4);
	memcpy (&fs_pkt.DPlusID, LinkID, 2); 
	fs_pkt.B_header.seq = 0x80;  
	xQueueSend( xDstarRcvQueue, &fs_pkt, portMAX_DELAY );

	/* Connect Message send */
	resync = SendConnectMsg(CallSign, resync);

		if (!AppConfig.Flags.VoiceMsgSW && !VoiceMsg)
		{
			/* Node Name send */
			resync = CallSignPlay (AppConfig.DefaultNodeName, resync);

			resync = MsgPlay (resync, (BYTE *)"CONNECT.BIN");
	
			/* Ref Name send */
			resync = CallSignPlay (CallSign, resync);

		}
		memcpy (&fs_pkt.DPlusID, LastFrameID, 2);
		memcpy (&fs_pkt.lastframe, LastFrame, 15);
		fs_pkt.B_header.seq = resync | 0x40;  
		xQueueSend( xDstarRcvQueue, &fs_pkt, portMAX_DELAY );
}

BYTE	CallSignPlay (BYTE CallSign[], BYTE resync)
{
	static	FSFILE	*wave;
	static	BYTE	file_name[] = {" .BIN"};
	static	WORD	i, k, n;

	FSchdir ("AUDIO");			/* change directory to Audio */
	if (FSerror() != CE_GOOD)
	{
		memcpy (temp,"Audio File      " "      Not Found.", 32);
		xMessage.pcMessage = (char *)&temp[0];
		xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
		xQueueSend( xLCDQueue, &xMessage, 0 );
		vTaskDelay(500 / portTICK_RATE_MS);
		FSchdir ("..");
		LogFile = FSfopen (LOGFILE, FS_APPEND);
		FSfprintf (LogFile, "%19.19s Audio Directory not found.\r\n",TimeDate);
		flushData();
		FSfclose (LogFile);
		LogFile = NULL;
		return resync;
	}
	n = strlen ((char *)CallSign);
	if ( n > 8) n = 8; 
	for (i = 0 ; i < n ; i++)
	{
		if ((CallSign[i] != 0x20) && (CallSign[i] != '*'))
		{
			file_name[0] = CallSign[i];
			wave = FSfopen ((char *)file_name, FS_BINARYREAD);
			if (FSerror() != CE_GOOD)
			{
				memcpy (temp,"Audio File      " "      Not Found.", 32);
				temp[15] = CallSign[i];
				xMessage.pcMessage = (char *)&temp[0];
				xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
				xQueueSend( xLCDQueue, &xMessage, 0 );
				vTaskDelay(500 / portTICK_RATE_MS);
				FSchdir ("..");
				LogFile = FSfopen (LOGFILE, FS_APPEND);
				FSfprintf (LogFile, "%19.19s Audio File Not Found. %c\r\n",TimeDate,CallSign[i]);
				flushData();
				FSfclose (LogFile);
				LogFile = NULL;
				return resync;
			} 
			while (FSfread (&fs_pkt.voice, 12, 1, wave))
			{
				if (resync == 0)
				{
					fs_pkt.voice[ 9] = 0x55;
					fs_pkt.voice[10] = 0x2d;
					fs_pkt.voice[11] = 0x16;
				} else {
					fs_pkt.voice[ 9] = 0x16;
					fs_pkt.voice[10] = 0x29;
					fs_pkt.voice[11] = 0xf5;
				}
				fs_pkt.B_header.seq = resync;  
				xQueueSend( xDstarRcvQueue, &fs_pkt, portMAX_DELAY );
				resync++;
				if (resync == 21) resync = 0;
			}
			FSfclose (wave);
		} else {
			for (k = 0 ; k < 5 ; k++)
			{
				if (resync == 0) memcpy (&fs_pkt.voice,  NullVoice0, 12);
				else			 memcpy (&fs_pkt.voice,  NullVoice1, 12);
				fs_pkt.B_header.seq = resync;  
				xQueueSend( xDstarRcvQueue, &fs_pkt, portMAX_DELAY );
				resync++;
				if (resync == 21) resync = 0;
			}
		}
	}
	FSchdir ("..");
	return resync;
}

BYTE	MsgPlay (BYTE resync, BYTE FileName[])
{
	static	FSFILE	*reply;
	static	BYTE	len;

	FSchdir ("AUDIO");			/* change directory to Audio */
	if (FSerror() != CE_GOOD)
	{
		memcpy (temp,"Audio File      " "      Not Found.", 32);
		xMessage.pcMessage = (char *)&temp[0];
		xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
		xQueueSend( xLCDQueue, &xMessage, 0 );
		vTaskDelay(TICK_SECOND);
		FSchdir ("..");
		LogFile = FSfopen (LOGFILE, FS_APPEND);
		FSfprintf (LogFile, "%19.19s Audio Directory not found.\r\n",TimeDate);
		flushData();
		FSfclose (LogFile);
		LogFile = NULL;
		return resync;
	} 
	reply = FSfopen ((char *)FileName, FS_BINARYREAD);
	if (FSerror() != CE_GOOD)
	{
		memcpy (temp,"Audio File None ", 16);
		len = strlen((char *)FileName);
		if (len > 16) len = 16;
		strncpy ((char *)&temp[16],(char *)FileName, len); 
		xMessage.pcMessage = (char *)&temp[0];
		xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
		xQueueSend( xLCDQueue, &xMessage, 0 );
		vTaskDelay(500 / portTICK_RATE_MS);
		FSchdir ("..");
		LogFile = FSfopen (LOGFILE, FS_APPEND);
		FSfprintf (LogFile, "%19.19s Audio File Not Found. %s\r\n",TimeDate,FileName);
		flushData();
		FSfclose (LogFile);
		LogFile = NULL;
		return resync;
	} 
	while (FSfread(&fs_pkt.voice, 12, 1, reply))
	{
		if (resync == 0)
		{
			fs_pkt.voice[ 9] = 0x55;
			fs_pkt.voice[10] = 0x2d;
			fs_pkt.voice[11] = 0x16;
		} else {
			fs_pkt.voice[ 9] = 0x16;
			fs_pkt.voice[10] = 0x29;
			fs_pkt.voice[11] = 0xf5;
		}
		fs_pkt.B_header.seq = resync;  
		xQueueSend( xDstarRcvQueue, &fs_pkt, portMAX_DELAY );
		resync++;
		if (resync == 21) resync = 0;
	}
	FSfclose (reply);
	FSchdir ("..");
	return resync;	
}

extern	BYTE	ConnectedMsg[13][12];

BYTE	SendConnectMsg(BYTE CallSign[], BYTE resync)
{
	static	WORD	i;

	memcpy (&fs_pkt.DPlusID, VoiceID, 2); 
	for (i = 0 ; i < 11 ; i++)
	{
		memcpy (&fs_pkt.voice, &ConnectedMsg[i][0], 12);
		switch (i)
		{
			case 1:
				fs_pkt.voice[10] = 'L' ^ 0x4f;
				fs_pkt.voice[11] = 'I' ^ 0x93;
				break;
			case 2:
				fs_pkt.voice[ 9] = 'N' ^ 0x70;
				fs_pkt.voice[10] = 'K' ^ 0x4f;
				fs_pkt.voice[11] = 'E' ^ 0x93;
				break;
			case 3:
				fs_pkt.voice[10] = 'D' ^ 0x4f;
				fs_pkt.voice[11] = ' ' ^ 0x93;
				break;
			case 4:
				fs_pkt.voice[ 9] = '-' ^ 0x70;
				fs_pkt.voice[10] = ' ' ^ 0x4f;
				fs_pkt.voice[11] = CallSign[0] ^ 0x93;
				break;
			case 5:
				fs_pkt.voice[10] = CallSign[1] ^ 0x4f;
				fs_pkt.voice[11] = CallSign[2] ^ 0x93;
				break;
			case 6:
				fs_pkt.voice[ 9] = CallSign[3] ^ 0x70;
				fs_pkt.voice[10] = CallSign[4] ^ 0x4f;
				fs_pkt.voice[11] = CallSign[5] ^ 0x93;
				break;
			case 7:
				fs_pkt.voice[10] = CallSign[6] ^ 0x4f;
				fs_pkt.voice[11] = CallSign[7] ^ 0x93;
				break;
			case 8:
				fs_pkt.voice[ 9] = ' ' ^ 0x70;
				fs_pkt.voice[10] = ' ' ^ 0x4f;
				fs_pkt.voice[11] = ' ' ^ 0x93;
				break;
		}
		fs_pkt.B_header.seq = resync;
		xQueueSend( xDstarRcvQueue, &fs_pkt, portMAX_DELAY );
		resync++;
		if (resync == 21) resync = 0;
	}
	return resync;
}

void GetTimeDate(void)
{
	static	rtccDate dt;
	static	rtccTime tm;

		RtccGetTimeDate (&tm, &dt); 
		TimeDate[0] = '2';
		TimeDate[1] = '0';
		TimeDate[2] = (dt.year>> 4) + 0x30;
		TimeDate[3] = (dt.year & 0x0f) + 0x30;
		TimeDate[4] = '/';
		TimeDate[5] = (dt.mon>> 4) + 0x30;
		TimeDate[6] = (dt.mon & 0x0f) + 0x30;
		TimeDate[7] = '/';
		TimeDate[8] = (dt.mday>> 4) + 0x30;
		TimeDate[9] = (dt.mday & 0x0f) + 0x30;
		TimeDate[10] = 0x20;
		TimeDate[11] = (tm.hour >> 4) + 0x30;
		TimeDate[12] = (tm.hour & 0x0f) + 0x30;
		TimeDate[13] = ':';
		TimeDate[14] = (tm.min >> 4) + 0x30;
		TimeDate[15] = (tm.min & 0x0f) + 0x30;
		TimeDate[16] = ':';
		TimeDate[17] = (tm.sec >> 4) + 0x30;
		TimeDate[18] = (tm.sec & 0x0f) + 0x30;
		TimeDate[19] = 0x00;
}

BOOL	DprsMsgCallSignCheck (void)	/* Dprs Msg Destination MyCallSign field Check */
{
	char	buf[75];
	WORD	length, len, i;

	if (FindFirst(DprsMsgRecvCallFile, attr, &recFile))
	{
		len = sizeof(DprsMsgRecvCallFile);
		memcpy (&temp[0],"file not found  ", 16);
		memcpy (&temp[16], DprsMsgRecvCallFile, len);
		xMessage.pcMessage = (char *)&temp[0];
 		xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
		xQueueSend( xLCDQueue, &xMessage, 0 );
		if (DebugSW)
		{
			LogFile = FSfopen (LOGFILE, FS_APPEND);
			FSfprintf (LogFile, "%19.19s DPRS Message Control file not found %s.\r\n",TimeDate, DprsMsgRecvCallFile);
			flushData();
			FSfclose (LogFile);
			LogFile = NULL;
		}
		return FALSE;
	}
	
	AprsAccFile = FSfopen (DprsMsgRecvCallFile, FS_READ);
	while (FSfread (buf, 75, 1,  AprsAccFile))
	{
		if (buf[0] != '*')
//		{
//			FSfclose (AprsAccFile);
//			return FALSE;
//			memcpy (AprsMsgTX, &buf[9], 3);
//			for (i = 12 ; i < 70 ; i++)
//			{
//				if (buf[i] <= 0x20) buf[i] = 0x00;
//			}
//			memcpy (EmailAddress, &buf[12], 48);
//			return TRUE
//		}
		{
			for (i = 0 ; i < 9 ; i++)
			{
				buf[i] = toupper (buf[i]);
			}
	
			length = 9;
			for (i = 0 ; i < 9 ; i++)
			{
				if (buf[8-i] == '*')
				{
					length = 8 - i;
					break;
				}		
			}
			if (length == 0) length = 9;
			if (!memcmp (buf, DprsMsgDstCallSign, length))
			{ 
				FSfclose (AprsAccFile);
				memcpy (AprsMsgTX, &buf[9], 3);
				for (i = 12 ; i < 70 ; i++)
				{
					if (buf[i] <= 0x20) buf[i] = 0x00;
				}
				memcpy (EmailAddress, &buf[12], 48);
				if (DebugSW)
				{
					LogFile = FSfopen (LOGFILE, FS_APPEND);
					FSfprintf (LogFile, "%19.19s %9.9s found in APRS access control list.\r\n",TimeDate,DprsMsgDstCallSign); 
					flushData();
					FSfclose (LogFile);
					LogFile = NULL;
				}
				return TRUE;
			}
		}
	}
	FSfclose (AprsAccFile);
	if (DebugSW)
	{
		LogFile = FSfopen (LOGFILE, FS_APPEND);
		FSfprintf (LogFile, "%19.19s %9.9s not found in APRS access control list.\r\n",TimeDate,DprsMsgDstCallSign); 
		flushData();
		FSfclose (LogFile);
		LogFile = NULL;
	}
	return FALSE;
}

void	DPRS_FileRead()
{
	FSFILE	*DprsFile;
	static	BYTE	tmp[45], len, i;
	extern	struct DPRSinfo DPRS;


	if (!FindFirst(DPRSetFileName, attr, &recFile))
	{
		DprsFile = FSfopen ((char *)DPRSetFileName, FS_READ);
		FSfread(tmp, 25, 1, DprsFile);		/* DPRS On/Off */
		if (!memcmp (tmp, "ON", 2)) DPRS.DprsSW = TRUE;
		else   DPRS.DprsSW = FALSE;

		FSfread(tmp, 25, 1, DprsFile);		/* DPRS RadioOn/Off */
		if (!memcmp (tmp, "ON", 2)) DPRS.RadioSW = TRUE;
		else   DPRS.RadioSW = FALSE;

		FSfread(tmp, 25, 1, DprsFile);		/* DPRS RadioOn/Off */
		if (!memcmp (tmp, "ON", 2)) DPRS.InetSW = TRUE;
		else   DPRS.InetSW = FALSE;

		memset (tmp,0x00,20);
		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS IP address */
		tmp[len] = 0x00;
		for (i = 0 ; i < len ; i++)
		{
			if (tmp[i] <= 0x20) tmp[i] = 0x00;
		}
		memcpy (DPRS.IPaddress, tmp, 20);

		memset (tmp,0x00,20);
		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS Port */
		tmp[len] = 0x00;
		for (i = 0 ; i < len ; i++)
		{
			if (tmp[i] <= 0x20) tmp[i] = 0x00;
		}
		DPRS.Port = atoi ((char *)tmp);

		memset (tmp,0x20,20);
		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS CallSign */
		tmp[len] = 0x20;
		memcpy (DPRS.CallSign, tmp, 8);
 
		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS Validation Code */
		tmp[len] = 0x00;
		memcpy (DPRS.ValidCode, tmp, 8);

		memset (tmp,0x00,20);
		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS Client Lat */

		tmp[len] = 0x00;
		DPRS.Lat = atof ((char *)tmp);

		memset (tmp,0x00,20);
		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS Client Long */
		tmp[len] = 0x00;
		DPRS.Long = atof ((char *)tmp);

		memset (tmp,0x00,20);
		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS Client Comment */
		tmp[len] = 0x00;
		memcpy (DPRS.Comment, tmp, 20);

		len = FSfread(tmp, 25, 1, DprsFile);				/* DPRS Client ID */
		if (!memcmp (tmp, "ON", 2)) DPRS.ClientID = TRUE;
		else   DPRS.ClientID = FALSE;

		len = FSfread(tmp, 25, 1, DprsFile);				/* DPRS Auto. Link */
		if (!memcmp (tmp, "ON", 2)) DPRS.AutoLink = TRUE;
		else   DPRS.AutoLink = FALSE;

		len = FSfread(tmp, 25, 1, DprsFile);				/* DPRS Auto. ReLink */
		if (!memcmp (tmp, "ON", 2)) DPRS.AutoReLink = TRUE;
		else   DPRS.AutoReLink = FALSE;

		len = FSfread(tmp, 45, 1, DprsFile);		/* DPRS SMTP server */
		memset (DPRS.SmtpServer, 0x00, 40);
		for (i = 0 ; i < 40 ; i++)
		{
			if (tmp[i] <= 0x20) tmp[i] = 0x00;
		}
		len = strlen((char *)tmp);
		if (len > 40) len = 40;
		if (len) memcpy (DPRS.SmtpServer, tmp, len+1);

		memset (tmp,0x00,20);
		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS Port */
		tmp[len] = 0x00;
		for (i = 0 ; i < len ; i++)
		{
			if (tmp[i] <= 0x20) tmp[i] = 0x00;
		}
		DPRS.SmtpPort = atoi ((char *)tmp);

		FSfread(tmp, 25, 1, DprsFile);			/* DPRS smtpAuth */
		if (!memcmp (tmp, "ON", 2)) DPRS.smtpAuth = TRUE;
		else   DPRS.smtpAuth = FALSE;

		memset (tmp,0x00,20);
		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS User */
		for (i = 0 ; i < 16 ; i++)
		{
			if (tmp[i] <= 0x20) tmp[i] = 0x00;
		}
		if (len) memcpy (DPRS.User, tmp, 16);

		memset (tmp,0x00,20);
		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS Password */
		for (i = 0 ; i < 16 ; i++)
		{
			if (tmp[i] <= 0x20) tmp[i] = 0x00;
		}
		if (len) memcpy (DPRS.Password, tmp, 16);

		DPRS.Interval = 30;
		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS Beacon Interal */
		if (len) DPRS.Interval = atoi ((char *)tmp);

		len = FSfread(tmp, 25, 1, DprsFile);		/* DPRS Beacon Interal */
		if (len) memcpy (DPRS.AltSSID, tmp, 2);
		
		FSfclose (DprsFile);

	}
	else
	{
		DPRS.DprsSW = FALSE;
		DPRS.DprsSW = FALSE;
		DPRS.DprsSW = FALSE;
		DPRS.ClientID = FALSE;
		DPRS.AutoLink = FALSE;
		DPRS.AutoReLink = FALSE;
		memcpy (DPRS.IPaddress, "115.179.102.234",15);
		DPRS.IPaddress[15] = 0x00;
		DPRS.Port = 14579;
		memset (DPRS.CallSign, 0x20, 8);
		memset (DPRS.ValidCode, 0x20, 8);
		memset (DPRS.Comment, 0x20, 20);
		DPRS.Lat = 0;
		DPRS.Long = 0;
		memset (DPRS.SmtpServer, 0x00, 40);
		memcpy (DPRS.SmtpServer, "SMTP Server Name", 16);
		DPRS.SmtpPort = 25;
		DPRS.smtpAuth = FALSE;
		memset (DPRS.User, 0x00, 16);
		memset (DPRS.Password, 0x00, 16);
		DPRS.Interval = 30; /* 30 minutes */
		memset (DPRS.AltSSID, 0x20, 2);
	}	
}

void	DPRS_FileWrite()
{
	FSFILE	*DprsFile;
	static	BYTE	tmp[25];
	static	BYTE	i;
	extern	struct DPRSinfo DPRS;

	DprsFile = FSfopen ((char *)DPRSetFileName, FS_WRITE);
	if (FSerror() == CE_GOOD)
	{
		if (DPRS.DprsSW) FSfprintf(DprsFile,"ON\r\n");
		else FSfprintf(DprsFile,"OFF\r\n");

		if (DPRS.RadioSW) FSfprintf(DprsFile,"ON\r\n");
		else FSfprintf(DprsFile,"OFF\r\n");

		if (DPRS.InetSW) FSfprintf(DprsFile,"ON\r\n");
		else FSfprintf(DprsFile,"OFF\r\n");

		FSfprintf (DprsFile, "%s\r\n", DPRS.IPaddress);

		FSfprintf (DprsFile, "%d\r\n", DPRS.Port);

		FSfprintf (DprsFile, "%8.8s\r\n", DPRS.CallSign);

		FSfprintf (DprsFile, "%s\r\n", DPRS.ValidCode);

		FSfprintf (DprsFile, "%ld\r\n", DPRS.Lat);
 
		FSfprintf (DprsFile, "%ld\r\n", DPRS.Long);

		memcpy (tmp, DPRS.Comment, 20);
		tmp[20] = 0x00;
		for (i = 0 ; i < 20 ; i++)
		{
			if (tmp[i] <= 0x20) tmp[i] = 0x20;
		}
		FSfprintf (DprsFile, "%20s\r\n", tmp);

		if (DPRS.ClientID) FSfprintf(DprsFile,"ON\r\n");
		else FSfprintf(DprsFile,"OFF\r\n");

		if (DPRS.AutoLink) FSfprintf(DprsFile,"ON\r\n");
		else FSfprintf(DprsFile,"OFF\r\n");

		if (DPRS.AutoReLink) FSfprintf(DprsFile,"ON\r\n");
		else FSfprintf(DprsFile,"OFF\r\n");

		for (i = 0 ; i < 40 ; i++)
		{
			if (DPRS.SmtpServer[i] <= 0x20) DPRS.SmtpServer[i] = 0x00;
		}
		FSfprintf (DprsFile, "%s\r\n", DPRS.SmtpServer);

		FSfprintf (DprsFile, "%d\r\n", DPRS.SmtpPort);

		if (DPRS.smtpAuth) FSfprintf(DprsFile,"ON\r\n");
		else FSfprintf(DprsFile,"OFF\r\n");

		FSfprintf (DprsFile, "%s\r\n", DPRS.User);

		FSfprintf (DprsFile, "%s\r\n", DPRS.Password);

		FSfprintf (DprsFile, "%4d\r\n", DPRS.Interval);

		FSfprintf (DprsFile, "%2.2s\r\n", DPRS.AltSSID);

		flushData();

		FSfclose (DprsFile);
	}	
}

void	DprsAccessFileRead()
{
	char	buf[75];
	WORD	len;
	xLCDMessage xMessage;

	if (FindFirst(DprsMsgRecvCallFile, attr, &recFile))
	{
		len = sizeof(AccessCtrl);
		memcpy (&temp[0],"file not found  ", 16);
		memcpy (&temp[16], DprsMsgRecvCallFile, len);
		xMessage.pcMessage = (char *)&temp[0];
		xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
		xQueueSend( xLCDQueue, &xMessage, 0 );
		LogFile = FSfopen (LOGFILE, FS_APPEND);
		FSfprintf (LogFile, "%19.19s Dprs Message Control file not found %s.\r\n",TimeDate, DprsMsgRecvCallFile);
		flushData();
		FSfclose (LogFile);
		LogFile = NULL;
		CallCheck_Skip = TRUE;
		buf[0] = 0xff;
		xQueueSend( xDstarDprsAccQueue, &buf, portMAX_DELAY );
		return;
	}

	accctl = FSfopen (DprsMsgRecvCallFile, FS_READ);
	len = FSfread (buf, 75, 1,  accctl);
	while (len)
	{
		if (buf[len-1] == 0x0a)
		{
			buf[len-1] = 0x00;
			len -= 1;
		}

		xQueueSend( xDstarDprsAccQueue, &buf, portMAX_DELAY );
		len = FSfread (buf, 75, 1,  accctl);
	}
	FSfclose (accctl);
	buf[0] = 0xff;
	xQueueSend( xDstarDprsAccQueue, &buf, portMAX_DELAY );
	return;
}

void	AprsSeqReadWrite(void)
{
//	static	BYTE	len;

	if (FindFirst(AprsSeqFileName, attr, &recFile))
	{
//		len = sizeof(AprsSeqFileName);
//		memcpy (&temp[0],"file not found  ", 16);
//		memcpy (&temp[16], AprsSeqFileName, len);
//		xMessage.pcMessage = (char *)&temp[0];
//		xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
//		xQueueSend( xLCDQueue, &xMessage, 0 );
//		LogFile = FSfopen (LOGFILE, FS_APPEND);
//		FSfprintf (LogFile, "%19.19s Aprs Sequence file not found.\r\n",TimeDate);
//		flushData();
//		FSfclose (LogFile);
//		LogFile = NULL;
		AprsSeq = 1;
		AprsSeqFile = FSfopen (AprsSeqFileName, FS_WRITE);
		FSfprintf (AprsSeqFile, "%05ld\n",AprsSeq+1);
		flushData();
		FSfclose (AprsSeqFile);
		return;
	}

	AprsSeqFile = FSfopen (AprsSeqFileName, FS_READ);
	FSfread (temp, 10, 1, AprsSeqFile);
	FSfclose (AprsSeqFile);
	AprsSeq = atol ((char *)temp);
	AprsSeqFile = FSfopen (AprsSeqFileName, FS_WRITE);
	if (AprsSeq != 99999) FSfprintf (AprsSeqFile, "%05ld\n",AprsSeq+1);
	else  FSfprintf (AprsSeqFile, "%05ld\n",1);
	flushData();
	FSfclose (AprsSeqFile);
}

void	LoadAprsCallCheck(void)
{
	char	buf[75];
	WORD	length, len, i;
	static	struct	AprsCallTable *NextTable;	
	static	struct	AprsCallTable *TempTable;	
	
	while (AprsCallTablePnt)
	{
		NextTable = AprsCallTablePnt->Next;
		vPortFree(AprsCallTablePnt);
		AprsCallTablePnt = NextTable;
	}

	if (FindFirst(DprsMsgRecvCallFile, attr, &recFile))
	{
		len = sizeof(DprsMsgRecvCallFile);
		memcpy (&temp[0],"file not found  ", 16);
		memcpy (&temp[16], DprsMsgRecvCallFile, len);
		xMessage.pcMessage = (char *)&temp[0];
		xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
		xQueueSend( xLCDQueue, &xMessage, 0 );
		if (DebugSW)
		{
			LogFile = FSfopen (LOGFILE, FS_APPEND);
			FSfprintf (LogFile, "%19.19s DPRS Message Control file not found %s.\r\n",TimeDate, DprsMsgRecvCallFile);
			flushData();
			FSfclose (LogFile);
			LogFile = NULL;
		}
		return;
	}
	
	AprsAccFile = FSfopen (DprsMsgRecvCallFile, FS_READ);
//	len = FSfread (buf, 75, 1,  AprsAccFile);
	while (FSfread (buf, 75, 1,  AprsAccFile))
	{
		if (buf[0] == '*')
		{
			len = sizeof(DprsMsgRecvCallFile);
			memcpy (&temp[0],"Not Support '*' ", 16);
			memcpy (&temp[16], DprsMsgRecvCallFile, len);
			xMessage.pcMessage = (char *)&temp[0];
			xMessage.xMinDisplayTime = 500 / portTICK_RATE_MS;
			xQueueSend( xLCDQueue, &xMessage, 0 );
			LogFile = FSfopen (LOGFILE, FS_APPEND);
			FSfprintf (LogFile, "%19.19s DPRS Message Control file does not support '*'.\r\n",TimeDate);
			flushData();
			FSfclose (LogFile);
			LogFile = NULL;
			goto next;		
//			NextTable = pvPortMalloc(sizeof(struct AprsCallTable));
//			NextTable->Next = NULL;
//			memcpy (NextTable->CallSign, "*        ",9);
//			NextTable->CallLength = 0;
//			if (!AprsCallTablePnt)
//			{
//				AprsCallTablePnt = NextTable;
//			} else {
//				TempTable = AprsCallTablePnt;
//				while (TempTable->Next) TempTable = TempTable->Next;
//			 	TempTable->Next = NextTable;
//			}
//			FSfclose (AprsAccFile);
//			return;
		}

		for (i = 0 ; i < 9 ; i++)
		{
			buf[i] = toupper (buf[i]);
		}
		length = 9;
		for (i = 0 ; i < 9 ; i++)
		{
			if (buf[8-i] == '*')
			{
				length = 8 - i;
				break;
			}		
		}
		NextTable = pvPortMalloc(sizeof(struct AprsCallTable));
		memset (NextTable->CallSign, 0x20, 9);
		if (length == 0) length = 9;
		NextTable->CallLength = length;
		NextTable->Next = NULL;
		memcpy (NextTable->CallSign, buf, length);
		if (!AprsCallTablePnt)
		{
			AprsCallTablePnt = NextTable;
		} else {
			TempTable = AprsCallTablePnt;
			while (TempTable->Next) TempTable = TempTable->Next;
		 	TempTable->Next = NextTable;
		}
next:
		continue;
//		len = FSfread (buf, 75, 1,  AprsAccFile);
	}
	FSfclose (AprsAccFile);
	return;
}

void	ConvertLocalRefFile(void)
{
	static	BYTE	RefL[26];
	static	BYTE	len, i;

	if (!FindFirst(TempLocalRefListFileName, attr, &recFile))
									FSremove (TempLocalRefListFileName);

	if (FindFirst(LocalRefListFileName, attr, &recFile)) return;

	RefFile = FSfopen (TempLocalRefListFileName, FS_WRITE);
	if (!FindFirst(LocalRefListFileName, attr, &recFile))
	{
		LocalRefFile = FSfopen (LocalRefListFileName,FS_READ);
		if (LocalRefFile)
		{
			len = FSfread (temp, 120, 1, LocalRefFile);
			if (len) temp[len-1] = 0x00;
			for (i = 10 ; i < 120 ; i++)
			{
				if (temp[i] == 0x20) temp[i] = 0x00;
			}
			memset (RefL, 0x00, 26);
			memcpy (&RefL[16], temp, 8);
			while (len >= 11)
			{
				for (i = 0 ; i < 26 ; i++)
				{
					if (RefL[i] <= 0x20) RefL[i] = 0x00; 
				}
				memset (RefDomainName, 0x00, 110);
				memcpy (RefDomainName,&temp[10], len -10);

				ReqRefDomainName = TRUE;
				while (ReqRefDomainName) vTaskDelay(200 / portTICK_RATE_MS);

				if ((strlen((char *)RefDomainName) != 7) || memcmp (RefDomainName, "0.0.0.0", 7))
				{ 
					memcpy (RefL, RefDomainName, strlen((char *)RefDomainName));
					for (i = 16 ; i < 24 ; i++)
					{
						if (RefL[i] == 0x00) RefL[i] = 0x20; 
					}
					FSfwrite (RefL, 26, 1, RefFile);
				}
				len = FSfread (temp, 120, 1, LocalRefFile);
				if ((temp[0] == 0x0a) || (temp[0] == 0x20)) break;
				if (len) temp[len-1] = 0x00;
				for (i = 10 ; i < 120 ; i++)
				{
					if (temp[i] == 0x20) temp[i] = 0x00;
				}
				memset (RefL, 0x00, 26);
				memcpy (&RefL[16], temp, 8);
			}
		}
		if (LocalRefFile)	FSfclose (LocalRefFile);
	}
	flushData();
	FSfclose (RefFile);
}