#include	"dmonitor.h"
#include	"dvmega.h"

void	dvmega_read (void);
int	read_dvmega(void);
int	dvmega_init (void);
void	inet_led_onoff(void);
int	inet_send_buff_set(void);
void	short_msg_wrt(void);
void    dstar_data (unsigned char string[], int inet);
void    dstar_alt_header (unsigned char string[], int inet);
void    rig_buff_reset (int length);
unsigned short int crc_calc (unsigned char string[], int length);
int	cmd_check (unsigned char cmd[]);
int     rig_status_check(void);

int	rig_status_check (void);
char	lastframe1[3] = {0x55, 0x55, 0x55};
char	lastframe2[3] = {0x55, 0xc8, 0x7a};
int	dvmega_last_frame_sw;
extern	unsigned char resync[];

void    dvmega_write (int fd, unsigned char buff[], int length)
{
	unsigned char	send_buff[50];
	unsigned short int crc;
	int	ret;
	if (length == 42)
	{
		send_buff[0] = DVMEGA_FRAME_START;
		send_buff[1] = 44; 
		send_buff[2] = DVMEGA_DSTAR_HEADER;
		memcpy (&send_buff[3], &buff[2], 41);
		crc = crc_calc (&send_buff[3], 39); 
		send_buff[42] = (crc >> 8) & 0xff;
		send_buff[43] = crc & 0xff;
		#ifdef	_DEBUG_DVMEGA
		syslog (LOG_DEBUG, "%8.8s %8.8s %8.8s %8.8s %2.2x %2.2x", &send_buff[6], &send_buff[14], &send_buff[22], &send_buff[30], send_buff[42], send_buff[43]);
		#endif
		ret = write (rig_fd, send_buff, 44);
	}
	else if (length == 17)
	{
		send_buff[0] = DVMEGA_FRAME_START;
		send_buff[1] = 15;
		send_buff[2] = DVMEGA_DSTAR_DATA;
		#ifdef	_DEBUG_DVMEGA
		syslog (LOG_DEBUG, "%2.2x   %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x    %2.2x %2.2x %2.2x", 
		buff[3], buff[4], buff[5], buff[6], buff[7], buff[8], buff[9], buff[10], 
		buff[11], buff[12] ,buff[13], buff[14], buff[15]);
		#endif
		memcpy (&send_buff[3], &buff[4], 12);
		ret = write (rig_fd, send_buff, 15);
		if (buff[3] & 0x40)
		{
			if (!memcmp (&send_buff[12] , lastframe1, 3))
			{
				ret = write (rig_fd, send_buff, 15);
			}
			send_buff[0] = DVMEGA_FRAME_START;
			send_buff[1] = 3;
			send_buff[2] = DVMEGA_DSTAR_EOT;
			ret = write (rig_fd, send_buff, 3);
		}
	}
	else
	{
		syslog (LOG_DEBUG, "write length %d", length);
	}
}

void	rig_buff_reset (int length)
{
        rig_buff_pnt -= length;
        memmove (rig_buff, &rig_buff[length], rig_buff_pnt);
}

int	send_dvmega_status(void)
{
        unsigned char buffer[3];

        buffer[0] = DVMEGA_FRAME_START;
        buffer[1] = 0x03;
        buffer[2] = DVMEGA_GET_STATUS;
	gettimeofday (&dvmega_status_send, NULL);
        return write(rig_fd, buffer, 3);
}

int	dvmega_init (void)
{
	unsigned char	buffer[3];
	/* get Version */
	buffer[0] = DVMEGA_FRAME_START;
	buffer[1] =  0x03;
	buffer[2] = DVMEGA_GET_VERSION;
	time (&rig_init_time);
	return write (rig_fd, buffer, 3);
}

int	dvmega_init_recv (void)
{
	int length;

	length = read_dvmega();
	if (length == 0) return FALSE;
	if (rig_buff[2] != DVMEGA_GET_VERSION) return FALSE;
	syslog (LOG_DEBUG, "%6.6s", &rig_buff[4]);
	rig_buff_reset (length);
	send_dvmega_status();
	return TRUE;
}

void	dvmega_read (void)
{
	int	length;
	int	ret;
	unsigned char	pkt_type;
	unsigned short int	crc;

	if (!rig_status_check()) return;
	length = read_dvmega();
	if (length == 0) return;
	pkt_type = rig_buff[2];
	switch (pkt_type)
	{
		case DVMEGA_ACK:
			dvmega_check_wait = TRUE;
			break;
		case DVMEGA_NAK:
			dvmega_check_wait = FALSE;
			break;

		case DVMEGA_DSTAR_HEADER:
			#ifdef	_DEBUG_DVMEGA
			syslog (LOG_DEBUG, "header %2.2x %d %2.2x %2.2x %2.2x %2.2x   %2.2x %2.2x", 
				rig_buff[0], rig_buff[1], rig_buff[2], rig_buff[3], rig_buff[4], rig_buff[5], rig_buff[42], rig_buff[43]);
			#endif
			if (!scan_sw) syslog (LOG_NOTICE, "%8.8s from DVMEGA", &rig_buff[30]);
			else
				fprintf (status_fd, "%8.8s from DVMEGA\n", &rig_buff[30]);
			if (!cmd_check (&rig_buff[22])) break;
			if (!rig_status_check()) return;			
                        gw_on = FALSE;
                        if (!inet_send_buff_set()) break;
                        inet_send_buff[16] = 0x80;
                        memcpy (&inet_send_buff[17], &rig_buff[3], 41);
                        memcpy (&inet_send_buff[20], area_call, 8);
                        memcpy (&inet_send_buff[28], area_call, 8);
                        if (memcmp (&inet_send_buff[36], "CQCQCQ  ", 8)) gw_on = TRUE;
                        if (send_sw && !rig_send_sw)
                        {
				send_header_sw = TRUE;
                        	memset (inet_frame_id, 0xff, 2);
				dvmega_last_frame_sw = FALSE;
                                in_addr.sin_port = htons(dest_inet_port);
                                in_addr.sin_addr.s_addr = inet_addr(dest_address);
                                m_seq++;
                                m_seq &= 0xffff;
                                inet_send_buff[4] = (m_seq >> 8) & 0xff;
                                inet_send_buff[5] = m_seq & 0xff;
                                inet_send_buff[7] |= FWD | ZR;
                                ret = sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
                                	(struct sockaddr *)&in_addr, sizeof(in_addr));
                                m_seq++;
                                m_seq &= 0xffff;
                                inet_send_buff[4] = (m_seq >> 8) & 0xff;
                                inet_send_buff[5] = m_seq & 0xff;
                                sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
                                	(struct sockaddr *)&in_addr, sizeof(in_addr));
                                memset (short_msg, 0x20, 20);
                                memcpy (used_call, &inet_send_buff[44], 8);
                                memcpy (used_call2, &inet_send_buff[52], 4);
                                short_msg_wrt();
                                if (gw_on)
                                {
                                	memcpy (&inet_send_buff[20], zone_call, 8);
                                       	inet_send_buff[27] = 'G';
                                        inet_send_buff[7]  &= 0x33;
                                        inet_send_buff[7] |= GW;
                                        m_seq++;
                                        m_seq &= 0xffff;
                                        inet_send_buff[4] = (m_seq >> 8) & 0xff;
                                        inet_send_buff[5] = m_seq & 0xff;
                                        sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
                                        	(struct sockaddr *)&in_addr, sizeof(in_addr));
                                        m_seq++;
                                        m_seq &= 0xffff;
                                        inet_send_buff[4] = (m_seq >> 8) & 0xff;
                                        inet_send_buff[5] = m_seq & 0xff;
                                        sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
                                        	(struct sockaddr *)&in_addr, sizeof(in_addr));
                                        if ((m_seq % 5) == 0) inet_led_onoff();
				}
			}
                        m_seq++;
                        m_seq &= 0xffff;
			dvmega_frame_seq = 0x00;
			break;

		case DVMEGA_DSTAR_DATA:
			if (!memcmp (&rig_buff[12], resync, 3)) dvmega_frame_seq = 0;
			if (!send_header_sw)
			{
				inet_send_buff[16] = dvmega_frame_seq;
				dvmega_frame_seq++;
				if (dvmega_frame_seq > 20) dvmega_frame_seq = 0;
				memcpy (&inet_send_buff[17], &rig_buff[3], 12);
				dstar_alt_header (inet_send_buff, FALSE);
				break;
			}
			#ifdef	_DEBUG_DVMEGA
			syslog (LOG_DEBUG, "data %2.2x %d %2.2x %2.2x %2.2x %2.2x", 
				rig_buff[0], rig_buff[1], rig_buff[2], rig_buff[3], rig_buff[4], rig_buff[5]);
			#endif
                        inet_send_buff[9] = 0x13;
                        inet_send_buff[4] = (m_seq >> 8) & 0xff;
                        inet_send_buff[5] = m_seq & 0xff;
                        inet_send_buff[7] &= 0x33;
                        inet_send_buff[7] |= FWD | ZR;
                        if (gw_on)
                        {
                        	inet_send_buff[7] |= GW;
                                if ((m_seq % 5) == 0) inet_led_onoff();
                        }
			inet_send_buff[16] = dvmega_frame_seq;
			dvmega_frame_seq++;
			if (dvmega_frame_seq > 20) dvmega_frame_seq = 0;
                        memcpy (&inet_send_buff[17], &rig_buff[3], 12);
                        if (send_sw)
                        {
                        	in_addr.sin_port = htons(dest_inet_port);
                                in_addr.sin_addr.s_addr = inet_addr(dest_address);
                                sendto (in_addr_sock, inet_send_buff, 29, MSG_DONTWAIT,
                                	(struct sockaddr *)&in_addr, sizeof(in_addr));
                                dstar_data (inet_send_buff, FALSE);
			}
                        m_seq++;
                        m_seq &= 0xffff;
			break;
		
		case DVMEGA_DSTAR_LOST:
			#ifdef	_DEBUG_DVMEGA
			syslog (LOG_DEBUG, "lost %2.2x %d %2.2x", rig_buff[0], rig_buff[1], rig_buff[2]);
			#endif
                        inet_send_buff[9] = 0x13;
                        inet_send_buff[4] = (m_seq >> 8) & 0xff;
                        inet_send_buff[5] = m_seq & 0xff;
                        inet_send_buff[7] &= 0x33;
                        inet_send_buff[7] |= FWD | ZR;
                        if (gw_on)
                        {
                                inet_send_buff[7] |= GW;
                                if ((m_seq % 5) == 0) inet_led_onoff();
                        }
                        inet_send_buff[16] = dvmega_frame_seq;
                        dvmega_frame_seq++;
                        if (dvmega_frame_seq > 20) dvmega_frame_seq = 0;
                        memcpy (&inet_send_buff[17], &rig_buff[3], 12);
                        if (send_sw)
                        {
                                in_addr.sin_port = htons(dest_inet_port);
                                in_addr.sin_addr.s_addr = inet_addr(dest_address);
                                sendto (in_addr_sock, inet_send_buff, 29, MSG_DONTWAIT,
                                        (struct sockaddr *)&in_addr, sizeof(in_addr));
                        }
                        m_seq++;
                        m_seq &= 0xffff;
			break;

		case DVMEGA_DSTAR_EOT:
			#ifdef	_DEBUG_DVMEGA
			syslog (LOG_DEBUG, "EOT");
			#endif
			send_header_sw = FALSE;
			if (!dvmega_last_frame_sw)
			{ 
			   if (send_sw)
			   {
                        	inet_send_buff[9] = 0x13;
                        	inet_send_buff[4] = (m_seq >> 8) & 0xff;
                        	inet_send_buff[5] = m_seq & 0xff;
                        	inet_send_buff[7] &= 0x33;
                        	inet_send_buff[7] |= FWD | ZR;
                        	if (gw_on)
                        	{
                                	inet_send_buff[7] |= GW;
                                	if ((m_seq % 5) == 0) inet_led_onoff();
                        	}
                        	inet_send_buff[16] = dvmega_frame_seq;
                        	dvmega_frame_seq++;
                        	if (dvmega_frame_seq > 20) dvmega_frame_seq = 0;
				memcpy (&inet_send_buff[26], lastframe1, 3);
                                in_addr.sin_port = htons(dest_inet_port);
                                in_addr.sin_addr.s_addr = inet_addr(dest_address);
                                sendto (in_addr_sock, inet_send_buff, 29, MSG_DONTWAIT,
                                        (struct sockaddr *)&in_addr, sizeof(in_addr));
                        	m_seq++;
                        	m_seq &= 0xffff;

                                inet_send_buff[9] = 0x13;
                                inet_send_buff[4] = (m_seq >> 8) & 0xff;
                                inet_send_buff[5] = m_seq & 0xff;
                                inet_send_buff[7] &= 0x33;
                                inet_send_buff[7] |= FWD | ZR;
                                inet_send_buff[16] = dvmega_frame_seq;
                                inet_send_buff[16] |= 0x40;
                                dvmega_frame_seq++;
                                if (dvmega_frame_seq > 20) dvmega_frame_seq = 0;
                                memcpy (&inet_send_buff[17], lastframe2, 3);
                                in_addr.sin_port = htons(dest_inet_port);
                                in_addr.sin_addr.s_addr = inet_addr(dest_address);
                                sendto (in_addr_sock, inet_send_buff, 29, MSG_DONTWAIT,
                                        (struct sockaddr *)&in_addr, sizeof(in_addr));
                                m_seq++;
                                m_seq &= 0xffff;
			   }
			}
			frameID = 0;
			memset	(inet_frame_id,	0x00, 2);
			break;

		case DVMEGA_GET_STATUS:
			dvmega_mode = rig_buff[4] & 0x01;
			dvmega_tx   = rig_buff[5];
			dvmega_dstarSpace = rig_buff[6];
			#ifdef	_DEBUG_DVMEGA
			syslog (LOG_INFO, "dvmega dstar space:%d dvmega_mode:%2.2x dvmega_tx:%2.2x", dvmega_dstarSpace, dvmega_mode, dvmega_tx);
			#endif
			break;

		default:
			break;
	}
	rig_buff_reset (length);
}

int     read_dvmega (void)
{
        int length;
        int     i;

        if (FD_ISSET (rig_fd, &read_set))
        {
                length = read (rig_fd, &rig_buff[rig_buff_pnt],
                        sizeof(rig_buff) - rig_buff_pnt);
                if (length == -1)
                {
                        syslog(LOG_ERR, "rig read error %s", strerror(errno));
			sig_term = TRUE;
			return 0;
                }
                if (length > 0)
                {
                        rig_buff_pnt += length;
                        for (i = 0 ; i < rig_buff_pnt ; i++)
                        {
                                if (rig_buff[i] == DVMEGA_FRAME_START)
				{
					if (i > 0) 
					{
						memmove (rig_buff, &rig_buff[i], rig_buff_pnt - i);
						rig_buff_pnt -= i;
					}
					if (rig_buff_pnt >= 2)
					{
						length = rig_buff[1];
						if (rig_buff_pnt >= length)
						{
							 return length;
						}
					}
					return 0;
				}
			}
                        rig_buff_pnt = 0;
			return 0;
                }
        }
        return 0;
}

int	dv_mega_readStatus()
{
	unsigned char buffer[3];

	buffer[0U] = DVMEGA_FRAME_START;
	buffer[1U] = 3;
	buffer[2U] = DVMEGA_GET_STATUS;

	return write(rig_fd, buffer, 3);
}

int	dvmega_setFrequency(void)
{

	unsigned char buffer[20];
	long int	rxFrequency;
	long int	txFrequency;	

	rxFrequency = dvmega_rxFrequency + dvmega_rxOffset;
	txFrequency = dvmega_txFrequency + dvmega_txOffset;


	buffer[0]  = DVMEGA_FRAME_START;
	buffer[1]  = 12;
	buffer[2]  = DVMEGA_SET_FREQ;
	buffer[3]  = 0x00;
	buffer[4]  = (rxFrequency >> 0) & 0xFF;
	buffer[5]  = (rxFrequency >> 8) & 0xFF;
	buffer[6]  = (rxFrequency >> 16) & 0xFF;
	buffer[7]  = (rxFrequency >> 24) & 0xFF;
	buffer[8]  = (txFrequency >> 0) & 0xFF;
	buffer[9]  = (txFrequency >> 8) & 0xFF;
	buffer[10] = (txFrequency >> 16) & 0xFF;
	buffer[11] = (txFrequency >> 24) & 0xFF;

	return write(rig_fd, buffer, 12);
}

int     dvmega_setMode(unsigned char mode)
{
        unsigned char buffer[4];

        buffer[0] = DVMEGA_FRAME_START;
        buffer[1] = 4;
        buffer[2] = DVMEGA_SET_MODE;
        buffer[3] = mode;

        return write(rig_fd, buffer, 4);
}

void    dvmega_close (void)
{
        ssize_t len;

        tcsetattr (rig_fd, TCSANOW, &save_attr);
        dvmega_NoRespReply_sw = FALSE;
        //dvap_skip();
        dvmega_gw_resp_sw = FALSE;
        dvmega_last_frame_sw = FALSE;
        dvmega_voice_send_sw = FALSE;
        if (dvmega_sw)
        {
                syslog (LOG_INFO, "DVMEGA down.");
        }
        dvmega_sw = FALSE;
        FD_CLR (rig_fd, &fd_save);
        close (rig_fd);
        rig_fd = 0;
}

int	dvmega_setConfig(void)
{
	unsigned char buffer[30];

	memset (buffer, 0x00, sizeof(buffer));
	buffer[0] = DVMEGA_FRAME_START;
	buffer[1] = 24;
	buffer[2] = DVMEGA_SET_CONFIG;
	buffer[3] = 0x00;
	buffer[4] = 0x01;
	buffer[5] = dvmega_tx_delay / 10;		// In 10ms units
	buffer[6] = MODE_IDLE;
	buffer[7] = (unsigned char)(dvmega_rxLevel * 2.55F + 0.5F);
	buffer[11] = 128;           // Was OscOffset
	buffer[12] = (unsigned char)(dvmega_txLevel * 2.55F + 0.5F);
	buffer[16] = 128;
	buffer[17] = 128;

	return write(rig_fd, buffer, 24);
}
