#include	"dmonitor.h"

int	inet_send_buff_set (void);
void    rig_alt_header_set(unsigned char alt_hdr[]);
unsigned short int      result_crc_dstar(unsigned short int crc);
unsigned short int      update_crc_dstar( unsigned short int  crc, unsigned char c);
void	inet_led_onoff(void);
void	putFifo (int len, char str[]);
void	header_store (char str[]);
unsigned short int crc_calc (unsigned char string[], int length);
int     rig_status_check(void);

void	short_msg_wrt (void)
{
	struct  stat    sb;
        FILE    *ShortMsg_fd;
	int	ret;

	if (lcd_type == LCD_20x4) lcdPosition (lcd, 0, 2);
        if (stat ("/var/tmp/", &sb)) return;
        if ((sb.st_mode & S_IFMT) != S_IFDIR) return;
        ShortMsg_fd = fopen (SHORT_TEMP, "w");
        fprintf (ShortMsg_fd, "<!DOCTYPE HTML>\n");
	fprintf (ShortMsg_fd, "<html lang=\"ja\"><head>\n");
	fprintf (ShortMsg_fd, "<meta charset=\"UTF-16\">\n");
        //fprintf (ShortMsg_fd, "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
        //fprintf (ShortMsg_fd, "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n");
        //fprintf (ShortMsg_fd, "<meta name=\"expires\" content=\"0\">\n");
	fprintf (ShortMsg_fd, "<meta http-equiv=\"refresh\" content=\"1;URL=./short_msg.html\">\n");
        //fprintf (ShortMsg_fd, "<script type=\"text/javascript\">\n");
        //fprintf (ShortMsg_fd, "setTimeout (function() {location.reload() ;} , 3000) ;\n");
        //fprintf (ShortMsg_fd, "</script>\n");
        fprintf (ShortMsg_fd, "</head>\n");
	fprintf (ShortMsg_fd, "<body style=\"background-color:#CCFFCC;\">\n");
	if (used_call[0] != 0x20)
	{
		if (!memcmp (used_call2, "    ", 4)) fprintf (ShortMsg_fd, "Caller:%8.8s Msg:", used_call);
		else fprintf (ShortMsg_fd, "Caller:%8.8s/%4.4s&nbsp;&nbsp;Msg:", used_call, used_call2);
        	fprintf (ShortMsg_fd, "%20.20s\n", short_msg);
	}
	else
	{
		fprintf (ShortMsg_fd, "Caller:&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp Msg:");
	}
		
        fprintf (ShortMsg_fd, "</body>\n</html>\n");
        fclose (ShortMsg_fd);
	sprintf  (cmd, "/usr/bin/nkf -SX -xw16 --overwrite --oc=UTF-16BE-BOM %s ; mv %s %s", SHORT_TEMP, SHORT_TEMP, SHORT_MSG);
        //sprintf (cmd, "/var/www/cgi-bin/file_check %s %s", SHORT_TEMP, SHORT_MSG);
        ret = system (cmd);
	if (lcd_type == LCD_20x4)
	{
		short_msg[20] = 0x00;
        	lcdPuts(lcd, short_msg);
	}
}

void	alt_header_set (unsigned char buff[],  unsigned char alt_hdr[], int inet)
{
return;
	if ((inet_frame_id[0] == 0x00) && (inet_frame_id[1] == 0x00))
	{
		syslog (LOG_INFO, "alter header set");
		if (inet == FALSE)
		{
			rig_alt_header_set (alt_hdr);
			return;
		}
		if (((buff[7] & ZR) && !memcmp (area_call, &alt_hdr[11], 8)) || scan_sw
                	|| ((buff[7] & GW) && !memcmp (area_call, &alt_hdr[3], 8)))
                {
                	memcpy (inet_frame_id_save, &buff[14], 2);
                        send_buff[0] = 0x29;
                        send_buff[1] = 0x20,
                        memcpy (&send_buff[2], alt_hdr, 39);
                        send_buff[41] = 0xff;
                        header_store (send_buff);
		}
                if (!scan_sw)
                {
			if (buff[7] & GW) syslog (LOG_NOTICE, "Alt Header %8.8s from GW", &alt_hdr[27]);
                                else if (buff[7] & ZR) syslog (LOG_NOTICE, "Alt Header %8.8s from ZR", &alt_hdr[27]);
                }
                else
                {
                        if (buff[7] & GW) fprintf (status_fd, "Alt header %8.8s from GW\n", &alt_hdr[27]);
                        else if (buff[7] & ZR) fprintf (status_fd, "Alt header %8.8s from ZR\n", &alt_hdr[27]);
                }
        }
}

void    dstar_data (unsigned char string[], int inet)
{
	unsigned short int	crc_dstar_ffff;
	int	n;

	if (string[16] != 0)
	{
		if (string[16] & 0x40)		// Last Frame
		{
			return;
		}
		
		if (string[16] % 2)
		{
			mini_header 
				= string[26] ^ 0x70;
			data_temp[0] 
				= string[27] ^ 0x4f;
			data_temp[1] 
				= string[28] ^ 0x93;
		}
		else
		{
			data_temp[2] 
				= string[26] ^ 0x70;
			data_temp[3] 
				= string[27] ^ 0x4f;
			data_temp[4] 
				= string[28] ^ 0x93;
			switch (mini_header)
			{
				case 0x40:	// short message
					memcpy (&short_msg[0], &data_temp[0], 5);
					break;
				case 0x41:
					memcpy (&short_msg[5], &data_temp[0], 5);
					break;
				case 0x42:
					memcpy (&short_msg[10], &data_temp[0], 5);
					break;
				case 0x43:
					memcpy (&short_msg[15], &data_temp[0], 5);
					short_msg_wrt();
					break;
			}
		}
	}
}

void	rig_alt_header_set (unsigned char alt_hdr[])
{
	int	ret;
	unsigned short int	crc;

	if (!rig_status_check()) return;
	if (send_header_sw) return;

        if (!scan_sw) syslog (LOG_NOTICE, "Alt header %8.8s from rig", &alt_hdr[27]);
        else
        {
                fprintf (status_fd, "Alt Header %8.8s from rig\n", &alt_hdr[27]);
        }

	gw_on = FALSE;
        if (!inet_send_buff_set()) return;
        inet_send_buff[16] = 0x80;
        memcpy (&inet_send_buff[17], alt_hdr, 41);
        memcpy (&inet_send_buff[20], area_call, 8);
        memcpy (&inet_send_buff[28], area_call, 8);
        if (memcmp (&inet_send_buff[36], "CQCQCQ  ", 8)) gw_on = TRUE;
        if (send_sw && !rig_send_sw)
        {
        	memset (inet_frame_id, 0xff, 2);
                in_addr.sin_port = htons(dest_inet_port);
                in_addr.sin_addr.s_addr = inet_addr(dest_address);
                m_seq++;
                m_seq &= 0xffff;
                inet_send_buff[4] = (m_seq >> 8) & 0xff;
                inet_send_buff[5] = m_seq & 0xff;
                inet_send_buff[7] |= FWD | ZR;
		crc = crc_calc (&inet_send_buff[17], 39);
		inet_send_buff[56] = (crc >> 8) & 0xff;
		inet_send_buff[57] = crc & 0xff;
                ret = sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
                	(struct sockaddr *)&in_addr, sizeof(in_addr));
                m_seq++;
                m_seq &= 0xffff;
                inet_send_buff[4] = (m_seq >> 8) & 0xff;
                inet_send_buff[5] = m_seq & 0xff;
                sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
                	(struct sockaddr *)&in_addr, sizeof(in_addr));
                memset (short_msg, 0x20, 20);
                memcpy (used_call, &inet_send_buff[44], 8);
                memcpy (used_call2, &inet_send_buff[52], 4);
		used_call_sw = TRUE;
                short_msg_wrt();
                if (gw_on)
                {
                	memcpy (&inet_send_buff[20], zone_call, 8);
                        inet_send_buff[27] = 'G';
                        inet_send_buff[7]  &= 0x33;
                        inet_send_buff[7] |= GW;
                        m_seq++;
                        m_seq &= 0xffff;
                        inet_send_buff[4] = (m_seq >> 8) & 0xff;
                        inet_send_buff[5] = m_seq & 0xff;
                	crc = crc_calc (&inet_send_buff[17], 39);
                	inet_send_buff[56] = (crc >> 8) & 0xff;
                	inet_send_buff[57] = crc & 0xff;
                        sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
                        	(struct sockaddr *)&in_addr, sizeof(in_addr));
                        m_seq++;
                        m_seq &= 0xffff;
                        inet_send_buff[4] = (m_seq >> 8) & 0xff;
                        inet_send_buff[5] = m_seq & 0xff;
                        sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
                        	(struct sockaddr *)&in_addr, sizeof(in_addr));
                        if ((m_seq % 5) == 0) inet_led_onoff();
		}
	}
        m_seq++;
        m_seq &= 0xffff;
	dvmega_frame_seq = 0x00;
        HeaderLength = 41;
        voice_pnt = 12;
        seq = 0;
}

void    dstar_alt_header (unsigned char string[], int inet)
{
	unsigned short int	crc_dstar_ffff;
	int	n;

	if (string[16] != 0)
	{
		if (string[16] & 0x40)		// Last Frame
		{
			return;
		}
		
		if (string[16] % 2)
		{
			mini_header 
				= string[26] ^ 0x70;
			data_temp[0] 
				= string[27] ^ 0x4f;
			data_temp[1] 
				= string[28] ^ 0x93;
		}
		else
		{
			data_temp[2] 
				= string[26] ^ 0x70;
			data_temp[3] 
				= string[27] ^ 0x4f;
			data_temp[4] 
				= string[28] ^ 0x93;
			switch (mini_header)
			{
				case 0x51:
					n = (string[16] - code_sq) / 2 - 1;
					if (n != 8) break;
					alt_header[40] = data_temp[0];
					crc_dstar_ffff = 0xffff;
					for (n = 0 ; n < 39 ; n++)
					{
						crc_dstar_ffff = update_crc_dstar (crc_dstar_ffff, alt_header[n]);
					}
					crc_dstar_ffff = result_crc_dstar(crc_dstar_ffff);
					if ((alt_header[39] == (crc_dstar_ffff >> 8)) && (alt_header[40] == (crc_dstar_ffff & 0xff)))
					{
						//syslog (LOG_INFO, "crc ok");
						alt_header_set (string, alt_header, inet);
					}
					#if 0 
					syslog (LOG_INFO, "%4.4x", crc_dstar_ffff);
					syslog (LOG_INFO, "%2.2x %2.2x %2.2x %36.36s %2.2x %2.2x",
						alt_header[0], alt_header[1], alt_header[2],
						&alt_header[3], alt_header[39], alt_header[40]);
					#endif
					break;

				case 0xc2:
					code_sq = 2;
					break;

				case 0x55:
					n = (string[16] - code_sq) / 2 - 1;	
					if ((n < 0) || (n > 7)) break;	
					memcpy (&alt_header[n*5], &data_temp[0], 5);
					break;
			}
		}
	}
	else
	{
		code_sq = 0;
	}
}
