#include "dmonitor.h"

void    send_keep_alive(void);
void	send_dest_keep_alive(void);
void    inet_read(void);
void	init(void);
void	handler (void);
int     handler_init(void);
void    pselectSet(void);
void    LastFrameSend(void);
void	rig(void);
int	send_rig (void);
void	rig_close (void);
void	connected_table_clean(void);

void	dmonitor_close(void);
void	buff_hold_size_write (int n);
int	buff_hold_size_read (void);
void	dmonitor_close(void);
void	send_rig_init(void);
void	dummy_last_frame (void);
void	jitter_buff_init (void);
void	jitter_putFifo (void);
void	dvap_conf(void);
void	dvap_read(void);
int	ETagGen (char file_name[], char md5[]);
void	error_msg(char str[]);
void	error_msg_clean(void);


time_t	send_time;
unsigned char 	*ppp;

unsigned char	recvBuff[256];

int	main(int argc, char *argv[])
{
	int	length;
	int	i;
	int	k;
	int	len;
	long int	l_int;
	time_t	cur_time;
	int	ret;
	int	ret_code;
	struct	timeval	time_val;
	struct	timeval	fifo_hold_time;
	struct	timeval	time_temp;
	unsigned int	now;
	struct	hostent	*host;
	struct	in_addr	hole_punch_addr;
	struct	timeval	add_time;
	struct	timeval	temp_time;

	char	pg_path[256];
	char	*bf;

	struct	timeval rig_send_time_20mSec;

	FILE	*pid_file;
	FILE	*RigType;

	ret = nice (-15);
	send_sw = FALSE;
	scan_sw = FALSE;
	header_wait = FALSE;
	error_msg_sw = FALSE;

	rig_send_sw = FALSE;

	openlog ("dmonitor", LOG_CONS | LOG_PID, LOG_LOCAL0);

	pid_file = fopen(PID_FILE,"r");
	if(pid_file == NULL)
	{
		pid_file = fopen(PID_FILE,"w");
	}
	else
	{
		syslog (LOG_ERR, "Already running dmonitor");
		closelog();
		return	-1;
	}
	fprintf	(pid_file,"%d",	getpid());
	fclose	(pid_file);

	RigType = fopen (RIG_FILE, "r");
	if (RigType == NULL)
	{
		rig_type = ICOM;
	}
	else
	{
		bf = fgets (recvBuff, sizeof (recvBuff), RigType);
		if (!memcmp (recvBuff, "DVAP", 4)) rig_type = DVAP;
		else	rig_type = ICOM;
	}
#if 0
	if (rig_type == ICOM)
	{
		syslog (LOG_INFO, "Rig Type : ICOM");
	}
	else if (rig_type == DVAP)
	{
		syslog (LOG_INFO, "Rig Type : DVAP");
	}
#endif
	
	length = readlink ("/proc/self/exe", pg_path, sizeof(pg_path));
	if (length <= 0 ) return -1;
	pg_path[length] = 0x00;
	if (ETagGen (pg_path, MD5_dmonitor) < 0) return 5;
	memcpy (MD5_dmonitor, "5ebe211107266a57b1af14a7fdcd8480", 32);

	Rp = malloc (sizeof (struct FifoPkt) - 1024);
	Wp = Rp;
	Rp->next = NULL;
	Fifo_cnt = 0;
	fifo_hold = fifo_new_hold = buff_hold_size_read ();
	recv_frame_seq = 0x00;

	memset (connect_call, 0x20, 8);
	if (argc < 5) 
	{
		syslog (LOG_ERR, 
			"Usage dmonitor my_call ip_address port area_call [zone_call]");
		return 5;
	}
	len = strlen(argv[1]);
	if (len > 8) len = 8;
	if (!memcmp (argv[1], "XX0XX", 5))
	{
		syslog (LOG_ERR, "connect callsing wrong %8.8s", argv[1]);
		return 5;
	}
	memcpy (connect_call, argv[1], len);
	dest_address = argv[2];
	dest_inet_port = (unsigned short)atoi(argv[3]);
	memcpy (area_call, argv[4], strlen(argv[4]));
	memcpy (zone_call, argv[4], strlen(argv[4]));
	zone_call[7] = 'G';
	if (argc == 6)
	{
		if (!memcmp (argv[5], "SCAN", 4)) scan_sw = TRUE;
		else 
		{
			memcpy (zone_call, argv[5], strlen(argv[5]));
			zone_call[7] = 'G';
		}
	}
	if (argc == 7)
	{
		if (!memcmp (argv[6], "SCAN", 4)) scan_sw = TRUE;
	}

	if (argc >= 5) send_sw = TRUE;

	if (!scan_sw) ret = daemon(0, 0);
	else status_fd = fopen ("/var/tmp/status.tmp", "w");

	send_time = 0;
	sig_term = FALSE;

	if (!scan_sw) handler_init();
	pselectSet();
	init();
	time (&rig_alive_recv);

	m_seq = 0;
	now = (unsigned int)time(0);
	srand(now);

	memset (hole_punch_server, 0x00, 128);
	memcpy (hole_punch_server, HOLE_PUNCHD_SERVER, 
		sizeof(HOLE_PUNCHD_SERVER));
	hole_punch_port = HOLE_PUNCHD_PORT;

	if (!scan_sw) syslog (LOG_INFO, "Connected to %8.8s (%s:%d) from %8.8s", 
			area_call, dest_address, dest_inet_port, connect_call);
	else fprintf (status_fd, "Connected to %8.8s from %8.8s\n", area_call, connect_call);
	memset (inet_frame_id, 0x00, 2);
	gettimeofday (&inet_time, NULL);
	inet_recv_time.tv_sec = 0;
	inet_recv_time.tv_usec = 0;

	add_time.tv_sec = 1;
	add_time.tv_usec = 0;

	rig_send_time_20mSec.tv_sec = 0;
	rig_send_time_20mSec.tv_usec = 20000;

	l_int = (fifo_hold - 5) * 20;
	inet_recv_timeout.tv_sec = l_int / 1000;
	inet_recv_timeout.tv_usec = (l_int % 1000) * 1000;

	rig_send_time.tv_sec = 0;
	rig_send_time.tv_usec = 0;

	if (wiringPiSetupGpio() == -1) return 1;
	pinMode(RIG_LED, OUTPUT);
	pinMode(INET_LED, OUTPUT);
	digitalWrite (RIG_LED, 0);
	digitalWrite (INET_LED, 0);
	inet_led_sw = 0;
	rig_led_sw = 0;

	connected_fd = NULL;
	hole_punch_send_interval = HOLE_PUNCH_SEND_INTERVAL;
	connected_table_clean();
	error_msg_clean();

	rig_buff_pnt = 0;
	rig_last_frame_send = TRUE;

	jitter_buff_init();

	ptt = 0x00;
	fifo_hold_limit = fifo_hold + 10;

	hole_punch_send_cnt = 0;

	dvap_conf();
	dvap_send_header_sw = FALSE;
	dvap_first_voice_pkt = FALSE;

	for (k = 0 ;  k < 2 ; k++)
	{
		send_keep_alive();
		usleep (10000);
	}

	dest_keep_alive_cnt= 0;

	while (1)
	{
		memcpy (&read_set, &fd_save, sizeof(fd_set));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL,
				(fd_set *)NULL, &timeout, &sigset);
		if (ret < 0)
		{
			if (errno == EINTR) goto skip;
			syslog (LOG_ERR, "pselect error %s", strerror(errno));
			break;
		}
		else if (ret > 0)
		{
			if (FD_ISSET (in_addr_sock, &read_set))
			{
				inet_read ();
			}
			if ((rig_type == DVAP) && FD_ISSET (rig_fd, &read_set))
			{
				dvap_read();
			}
		}
		jitter_putFifo();
		rig ();
		time (&cur_time);
		if ((cur_time - hole_punch_send_time) >= hole_punch_send_interval)
		{
			if (hole_punch_send_interval == HOLE_PUNCH_SEND_INTERVAL) 
			{
				hole_punch_send_cnt++;
				if (hole_punch_send_cnt >= 20)
				{
					syslog (LOG_INFO,
						"Not Connected to %8.8s", area_call);
					if (!scan_sw) error_msg ("ERROR接続できまません");
					sleep (15);
					break;
				}
				else
				{
					if (!scan_sw) error_msg ("ERROR接続処理中です");
				}
			}
			send_dest_keep_alive();
		}
		if (dest_keep_alive_send_time)
		{
			if ((cur_time - dest_keep_alive_send_time) >= 3)
			{
				dest_keep_alive_cnt++;
				if (dest_keep_alive_cnt >= 5) break;
				send_keep_alive();
			}
		}
		if(rig_send_sw)
		{
			gettimeofday (&c_time, NULL);
			timeradd (&rig_send_time, &rig_send_time_20mSec, &temp_time);
			if (timercmp (&c_time, &temp_time, >))
			{
				if (send_rig())
				{
					rig_send_time.tv_sec = temp_time.tv_sec;
					rig_send_time.tv_usec = temp_time.tv_usec;
				}
			}
		}
		if ((inet_frame_id[0] != 0xff) || (inet_frame_id[1] != 0xff))
		{
		   if ((inet_frame_id[0] != 0x00) || (inet_frame_id[1] != 0x00))
		   {
			gettimeofday (&c_time, NULL);
			timeradd (&inet_recv_time, &inet_recv_timeout, &temp_time);
			if (timercmp (&c_time, &temp_time, >))
			{
				syslog (LOG_INFO, "insert dummy_last_frame");
				dummy_last_frame();
				#ifdef	_SPECIFICATION_CHECK
				timersub (&c_time, &inet_recv_time, &temp_time);
				syslog (LOG_INFO, "long interval %ld.%03ld Sec.", temp_time.tv_sec, temp_time.tv_usec/1000);
				#endif
			}
		   }
		}
		else
		{
			fifo_hold = fifo_new_hold;
			l_int = (fifo_hold - 5) * 20;
			inet_recv_timeout.tv_sec = l_int / 1000;
			inet_recv_timeout.tv_usec = (l_int % 1000) * 1000;
		}
		if (scan_sw)
		{
			gettimeofday (&c_time, NULL);
			timeradd (&inet_time, &add_time, &temp_time);
			if (timercmp (&c_time, &temp_time, >)) break;
		}
skip:
		if (sig_term) break;
	}

	if (!rig_last_frame_send)
	{
		LastFrameSend();
	}
	connected_table_clean();
	error_msg_clean();
	dmonitor_close();
	if (rig_fd) rig_close();
	if (!scan_sw)
	{
		syslog (LOG_INFO, "dmonitor end");
	}
	else
		fprintf (status_fd, "dmonitor end");

	closelog();
	if (scan_sw)
	{
		fclose (status_fd);
		ret = system ("/var/www/cgi-bin/file_check /var/tmp/status.tmp /var/tmp/status.txt");
	}
	close (in_addr_sock);
	remove (PID_FILE);
	digitalWrite (RIG_LED, 0);
        digitalWrite (INET_LED, 0);
	return 0;
}

