#include	"dmonitor.h"

void	PICinfo (void);
void	node_term (void);
void    header_read_from_node(void);
int	voice_read_from_node(void);

void    node_close (void)
{

	if (udev)
	{
        	usb_reset (udev);
        	usb_close (udev);
        	node_term();
	}
}

void    node_term (void)
{
//        node_NoRespReply_sw = FALSE;
//        node_response_state = 0;
//        node_gw_resp_sw = FALSE;
//        node_last_frame_sw = FALSE;
//        dvap_voice_send_sw = FALSE;
//        memset (&node_save_frame_id, 0x00, 2);
        syslog (LOG_INFO,  "Node Adapter close.");
}

int     node_cos_check(void)
{
        if (usb_control_msg(udev, 0xC0, GET_AD_STATUS, 0, 0, &node_status, 1, 100) < 0)
        {
                node_close();      /* node adapter down ? */
                return FALSE;
        }
        if (node_status & COS_OnOff) return TRUE;
        return FALSE;
}

int	node_status_check(void)
{
        if (usb_control_msg(udev, 0xC0, GET_AD_STATUS, 0, 0, &node_status, 1, 100) < 0)
        {
                node_close();      /* node adapter down ? */
                return FALSE;
        }
        if (node_status & (COS_OnOff | PTT_OnOff)) return FALSE;
        return TRUE;
}

int	node_usb_init(void)
{
	int	ret;
	int	dev_found;

	udev = NULL;
	dev_found = FALSE;
	usb_init();
	usb_find_busses();
	usb_find_devices();

	dev_found = FALSE;
        for (bus = usb_get_busses(); bus && !dev_found; bus = bus->next) {
                for (dev = bus->devices; dev && !dev_found; dev = dev->next) {
                  if ((dev->descriptor.idVendor == node_VenderID) 
			&& (dev->descriptor.idProduct == node_ProductID))
                  {
                        udev = usb_open(dev);
			dev_found = TRUE;
                        break;
                  }
                }
        }

        if (!dev_found)
	{
               	syslog(LOG_ERR,  
			"Please check the USB Cable! or Node Adapter!"); 
		node_term();
                return FALSE;
        }

        if (usb_set_configuration (udev, dev->config->bConfigurationValue) < 0)
	{
		syslog (LOG_ERR,  "Configuratime Error for Node Adapter!");
		node_close();
		return FALSE;
	}

        if (!scan_sw)
        {
                syslog (LOG_INFO, "Node Adapter VenderID:0x%4.4x ProductID:0x%4.4x",
                        node_VenderID, node_ProductID);
        }

	usb_control_msg(udev, 0x40, SET_TX_INVERT, node_tx_inv, 0, NULL, 0, 100);
	usb_control_msg(udev, 0x40, SET_RX_INVERT, node_rx_inv, 0, NULL, 0, 100);
	usb_control_msg(udev, 0x40, SET_DelayTime, node_tx_delay/10, 0, NULL, 0, 100);
	if (!scan_sw) PICinfo();
	HeaderLength = 0;
	node_voice_send_sw = FALSE;
	return TRUE;

}

void	node(void)
{
	if (node_cos_check()) gettimeofday(&NodeCosOffTime, NULL);
        if (node_status & (HeaderDecodeDone | COS_OnOff))
        {
        	if (HeaderLength == 0)
                {
                	header_read_from_node ();
                }
                else voice_read_from_node();
	}
        else    /* last frame check */
        {
        	if (HeaderLength)
                {
                	if (voice_read_from_node() == 0)
                        {
                        	//if (last_frame_sw) node_last_frame_send();
                                HeaderLength = 0;
                                voice_pnt = 0;
              		}
            	}
	}
}

