#include "dmonitor.h"

void	header_store (char str[]);
void	putFifo (int len, unsigned char pkt[]);
void    inet_led_onoff(void);
void	connected_table(char str[]);
void	error_msg (char str[]);
void	jitter_put (unsigned char str[]);
void	rig_send_check(void);
void	called_msg (char call1[], char call2[]);

unsigned char	recvBuff[64];

char            dummy_frame_1[12] = {
                        0x73, 0x44, 0x1a, 0x72, 0x31, 0x3c, 0xa7, 0x53, 0x02, 0x55, 0x55, 0x55};
char            dummy_frame_2[12] = {
                        0x9e, 0x8d, 0x32, 0x88, 0x26, 0x1a, 0x3f, 0x61, 0xe8, 0xe7, 0x84, 0x76};
char            dummy_frame_3[12] = {
                        0x55, 0xc8, 0x7a, 0x88, 0x26, 0x1a, 0x3f, 0x61, 0xe8, 0x55, 0x55, 0x55};

void	rig_send_check (void)
{
	if (!rig_send_sw && Fifo_cnt)
	{
		rig_send_sw = TRUE;
		gettimeofday (&rig_send_time, NULL);
	}
}

void	rig_fifo_check (void)
{
	if ((!rig_send_sw) && (Fifo_cnt > fifo_hold))
	{
		rig_send_sw = TRUE;
		gettimeofday (&rig_send_time, NULL);
	}
}

void	dummy_last_frame (void)
{
	recvBuff[16] = jitter_rd_pnt;
        memcpy (&recvBuff[17], dummy_frame_1, 12);
	jitter_put (&recvBuff[16]);
	if (recvBuff[16] % 2)
	{
        	recvBuff[16]++;
        	if (recvBuff[16] > 20) recvBuff[16] = 0x00;
		memcpy (&recvBuff[17], dummy_frame_2, 12);
		jitter_put (&recvBuff[16]);
	}
	recvBuff[16]++;
	if (recvBuff[16] > 20) recvBuff[16] = 0x00;
        recvBuff[16] |= 0x40;
	memcpy (&recvBuff[17], dummy_frame_3, 12);
	jitter_put (&recvBuff[16]);
        memset (inet_frame_id, 0x00, 2);
        rig_send_check();
        digitalWrite (INET_LED, 0);
        digitalWrite (RIG_LED, 0);
        rig_last_frame_send = TRUE;
	drop_rate_print();
	dvap_send_header_sw = FALSE;
}

void	inet_read(void)
{
	int	length;
	int	k;
	long int t_sub;
	char	buff[24];
	struct	hostent	*host;
	struct	timeval	time_sub;
	int	rate;

	k = sizeof (struct sockaddr);
	length = recvfrom (in_addr_sock, recvBuff, 64, 0, 
		(struct sockaddr *)&in_addr, &k);
	if (length < 0)
	{
		syslog (LOG_ERR, "recvfrom error (inet_read) %s", strerror (errno));
		return;
	}
	if (length == 25)
	{
		if (!memcmp (recvBuff, "HPCH", 4))
		{
        		in_addr.sin_family = AF_INET;
        		in_addr.sin_port = htons(dest_inet_port);
        		in_addr.sin_addr.s_addr = inet_addr(dest_address);
        		if (in_addr.sin_addr.s_addr == 0xffffffff)
        		{
                		host = gethostbyname(dest_address);
                		if (host == NULL) return;
                		in_addr.sin_addr.s_addr = 
					*(unsigned int *)host->h_addr_list[0];
        		}
			hole_punch_send_interval = 20;
			hole_punch_send_cnt = 0;
			memset (buff, 0x00, sizeof(buff));
			memcpy (&buff[16], connect_call, 8);
			sprintf (buff, "%s", inet_ntoa (in_addr.sin_addr));
			sendto(in_addr_sock, buff, 24, 0,
				(struct sockaddr *)&in_addr, sizeof(in_addr));
		}
		return;
	}

	if (length < 29) 
	{
		return;
	}
	if (!memcmp (recvBuff, "CTBL", 4))
	{
		if (!scan_sw) connected_table(recvBuff);
		return;
	}
	if (!memcmp (recvBuff, "ERROR", 5) || !memcmp (recvBuff, "MESSG", 5)) 
	{
		if (!scan_sw) error_msg (recvBuff);
		return;
	}

	if (memcmp (recvBuff, "DSTR", 4)) return;

	#ifdef	_DEBUG_INET
	syslog (LOG_DEBUG, "inet read %d", length);
	#endif
	if ((inet_frame_id[0] == 0x00) && (inet_frame_id[1] == 0xff)) 
	{
		if (length == 58)
		{
			syslog (LOG_INFO, "called from:%8.8s to:%8.8s in busy mode (rig)",
				&recvBuff[44], &recvBuff[36]); 
			called_msg (&recvBuff[44], &recvBuff[36]);
		}
		return;
	}
	inet_m = (recvBuff[4] << 8) | recvBuff[5];
	inet_m_save++;
	inet_m_save &= 0xffff;
	if (inet_m != inet_m_save)
	{
		#ifdef	_DEBUG_INET
		if (inet_m_save != 1) syslog(LOG_ERR, "seq. error recv:%d drop:%d", inet_m, inet_m_save);
		#endif
		inet_m_save = inet_m;
	}
	if (recvBuff[13] == 0xff) return;
	gettimeofday (&inet_time, NULL);
	#ifdef	_DEBUG_INET
	syslog(LOG_INFO, "length:%d FrameID:%2.2x%2.2x seq:%2.2x (Cur.FrameID:%2.2x%2.2x)", 
		length, recvBuff[14], recvBuff[15], recvBuff[16], inet_frame_id[0], inet_frame_id[1]);
	#endif
	if (length == 58)
	{
		if ((inet_frame_id[0] == 0x00) && (inet_frame_id[1] == 0x00))
		{
			if (((recvBuff[7] & ZR) && !memcmp (area_call, &recvBuff[28], 8)) || scan_sw
				|| ((recvBuff[7] & GW) && !memcmp (area_call, &recvBuff[20], 8)))
			{
				memcpy (inet_frame_id, &recvBuff[14], 2);
				send_buff[0] = 0x29;
				send_buff[1] = 0x20,
				memcpy (&send_buff[2], &recvBuff[17], 39);
				send_buff[41] = 0xff;
				header_store (send_buff);
				putFifo (42, send_buff);
				recv_frame_seq = 20;
				gettimeofday (&inet_recv_time, NULL);
				rig_last_frame_send = FALSE;
				inet_read_cnt = 0;
				inet_read_drop_cnt = 0;
				jitter_max = 0;
				jitter_min = 500000;
				jitter_ave = 0;
				#ifdef	_SPECIFICATION_CHECK
				memset (voice_packet_save, 0xff, 15);
				#endif
	
			}
			if (!scan_sw)
			{
				if (recvBuff[7] & GW) syslog (LOG_NOTICE, "%8.8s from GW", &recvBuff[44]);
				else if (recvBuff[7] & ZR) syslog (LOG_NOTICE, "%8.8s from ZR", &recvBuff[44]);
			}
			else
			{
                                if (recvBuff[7] & GW) fprintf (status_fd, "%8.8s from GW\n", &recvBuff[44]);
                                else if (recvBuff[7] & ZR) fprintf (status_fd, "%8.8s from ZR\n", &recvBuff[44]);
			}
		}
	}
	else if (length == 29)
	{
		if (!memcmp (&inet_frame_id, &recvBuff[14], 2))
		{
			#ifdef	_SPECIFICATIO_CHECK
			if (!memcmp (&recvBuff[14], voice_packet_save, 15))
				syslog (LOG_INFO, "Dup. packet (maybe loop) from %8.8s  %2.2x %2.2x  %2,2x", recvBuff[14], recvBuff[15], recvBuff[16]); 
				memcpy (voice_packet_save, &recvBuff[14], 15);
			#endif
			#ifdef _DEBUG
			if ((recvBuff[16] & 0x1f) > 0x14) syslog (LOG_INFO, "bad seq. info. %2.2x", recvBuff[16]);
			#endif
			inet_read_cnt++;
			if (recvBuff[16] == 0x00) inet_led_onoff();
			if (recvBuff[16] & 0x40) 
			{
				memcpy (&recvBuff[17], dummy_frame_3, 12);
				memset (inet_frame_id, 0x00, 2);
				digitalWrite (INET_LED, 0);
				digitalWrite (RIG_LED, 0);
				rig_last_frame_send = TRUE;
				drop_rate_print();
				rig_send_check();
			}
        		inet_recv_time_save.tv_sec = inet_recv_time.tv_sec;
        		inet_recv_time_save.tv_usec = inet_recv_time.tv_usec;
			gettimeofday (&inet_recv_time, NULL);
			timersub (&inet_recv_time, &inet_recv_time_save, &time_sub);
			t_sub = time_sub.tv_sec * 1000 + time_sub.tv_usec / 1000;
			if (t_sub > jitter_max) jitter_max = t_sub;
			if (t_sub & (t_sub < jitter_min)) jitter_min = t_sub;
			jitter_ave += (t_sub - 20);
			if (timercmp (&time_sub, &inet_recv_timeout, >) && !(recvBuff[16] & 0x40))
			{
                                syslog (LOG_INFO, "insert dummy_last_frame");
                                dummy_last_frame();
			}
			#ifdef	_SPECIFICATION_CHECK
			if (t_sub > 300) syslog (LOG_INFO, "long interval %ld.%03ld Sec. seq:%2.2x", t_sub / 1000, t_sub % 1000, recvBuff[16]);
			//if (t_sub < 2)   syslog (LOG_INFO, "short interval %ld mSec.", t_sub);
			#endif
			if (!memcmp (&recvBuff[17] , dummy_frame_3, 3) && !memcmp (&recvBuff[26], &dummy_frame_3[9], 3)) recvBuff[16] |= 0x40;
			jitter_put (&recvBuff[16]);
		}
	}
	else if (length == 32)
	{
		if (!memcmp (inet_frame_id, &recvBuff[14], 2))
		{
                        #ifdef  _SPECIFICATION_CHECK
                        syslog (LOG_INFO, "Packet length wrong (32 bytes) from %8.8s", &header_save[29]);
			if (memcmp (&recvBuff[29], dummy_frame_3, 3) || memcmp (&recvBuff[26], &dummy_frame_3[9], 3))
			{
				syslog (LOG_INFO, "Last packet wrong (32 bytes) from %8.8s  0-2 %2.2x %2.2x %2.2x  9-11 %2.2x %2.2x %2.2x  12-14 %2.2x %2.2x %2.2x",
					&header_save[29], recvBuff[17], recvBuff[18], recvBuff[19], 
					recvBuff[26], recvBuff[27], recvBuff[28], recvBuff[29], recvBuff[30], recvBuff[31]);
			}
                        #endif
			#ifdef _DEBUG
			if ((recvBuff[16] & 0x1f) > 0x14) syslog (LOG_INFO, "bad seq. info. %2.2x", recvBuff[16]);
			#endif
			inet_read_cnt++;
			recvBuff[16] &= 0x1f;
			if (recvBuff[16] % 2)
			{
				recvBuff[16]++;
				if (recvBuff[16] > 20) recvBuff[16] = 0x00;
				memcpy (&recvBuff[17], dummy_frame_2, 12);
				jitter_put (&recvBuff[16]);
				recvBuff[16]++;
				if (recvBuff[16] > 20) recvBuff[16] = 0x00;
				memcpy (&recvBuff[17], dummy_frame_1, 12);
				jitter_put (&recvBuff[16]);
			}
			else
			{
                		recvBuff[16]++;
                		if (recvBuff[16] > 20) recvBuff[16] = 0x00;
                		memcpy (&recvBuff[17], dummy_frame_1, 12);
                		jitter_put (&recvBuff[16]);
        		}
			recvBuff[16]++;
			if (recvBuff[16] > 20) recvBuff[16] = 0x00;
			recvBuff[16] |= 0x40;
			memcpy (&recvBuff[17], dummy_frame_3, 12);
			memset (inet_frame_id, 0x00, 2);
			inet_recv_time_save.tv_sec = inet_recv_time.tv_sec;
			inet_recv_time_save.tv_usec = inet_recv_time.tv_usec;
			gettimeofday (&inet_recv_time, NULL);
			timersub (&inet_recv_time, &inet_recv_time_save, &time_sub);
			t_sub = time_sub.tv_sec * 1000 + time_sub.tv_usec / 1000;
			if (t_sub > jitter_max) jitter_max = t_sub;
			if (t_sub && (t_sub < jitter_min)) jitter_min = t_sub;
			jitter_ave += (t_sub - 20);
                        #ifdef  _SPECIFICATION_CHECK
                        if (t_sub > 300) syslog (LOG_INFO, "long interval %ld/%03ld Sec. seq:%2.2x", t_sub / 1000, t_sub % 1000, recvBuff[16]);
                        //if (t_sub < 2)   syslog (LOG_INFO, "short interval %ld mSec", t_sub);
                        #endif
			jitter_put (&recvBuff[16]);
			digitalWrite (INET_LED, 0);
			digitalWrite (RIG_LED, 0);
			rig_last_frame_send = TRUE;
			drop_rate_print();
			rig_send_check();
		}
	}
}

void	inet_led_onoff(void)
{
	if (inet_led_sw) inet_led_sw = 0;
	else		 inet_led_sw = 1;
	digitalWrite (INET_LED, inet_led_sw);
}
