#include	"rpt_conn.h"
#include	"dvmega.h"

void	dvap_send_header(void);
void	dvap_send_voice(void);
void    rig_buff_reset (int length);
int     read_dvmega(void);
void    dvmega_write (int fd, unsigned char buff[], int length);
int	rig_status_check (void);
unsigned short int crc_calc (unsigned char str[], int len);

void	dvmega_conf (void)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	n;
	int	field_sw;
	int	port;

	FILE	*config_file;

	config_file = fopen (DVMEGA_CONF, "r");
	if (!config_file)
	{
		syslog (LOG_ERR, "dvmega config file not found (%s)\n", 
					DVMEGA_CONF);
		return;
	}

	dvmega_rxOffset = 0;
	dvmega_txOffset = 0;

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "DVMEGA_TX_FREQUENCY",  19))
				{
					dvmega_txFrequency = atoi(pnt);
				}
				else if (!memcmp (p, "DVMEGA_RX_FREQUENCY",  19))
				{
					dvmega_rxFrequency = atoi (pnt);
				}
				else if (!memcmp (p, "DVMEGA_FREQUENCY", 16))
				{
					dvmega_Frequency = atoi (pnt);
					dvmega_rxFrequency = dvmega_txFrequency = dvmega_Frequency;
				}
				else if (!memcmp (p, "DVMEGA_RX_LEVEL", 15))
				{
					dvmega_rxLevel = atof(pnt);
				}
				else if (!memcmp (p, "DVMEGA_TX_LEVEL", 15))
				{
					dvmega_txLevel = atof (pnt);
				}
				else if (!memcmp (p, "DVMEGA_TX_DELAY", 15))
				{
					dvmega_tx_delay = atoi (pnt);
				}
				else if (!memcmp (p, "DVMEGA_DEVICE", 13))
				{
					memset (rig_device, 0x00, sizeof(rig_device));
					memcpy (rig_device, pnt, strlen(pnt));
				}
                               	else if (!memcmp (p, "DVMEGA_TX_OFFSET", 16))
                                {
                                        dvmega_txOffset = atoi (pnt);
                                }
                                else if (!memcmp (p, "DVMEGA_RX_OFFSET", 16))
                                {
                                        dvmega_rxOffset = atoi (pnt);
                                }
				else
				{
					syslog (LOG_ERR, "Error on dvap config file : %s", buff);
				}
			}
		}
	}

	fclose (config_file);

	return;
}

int	send_dvmega_status(void)
{
        unsigned char buffer[3];

        buffer[0] = DVMEGA_FRAME_START;
        buffer[1] = 3;
        buffer[2] = DVMEGA_GET_STATUS;
	gettimeofday (&dvmega_status_send, NULL);
        return write(rig_fd, buffer, 3U);
}

void	dvmega_read (void)
{
	int	length;
	unsigned char	pkt_type;

	if (!rig_status_check()) return;
	length = read_dvmega();
	if (length == 0) return;
	pkt_type = rig_buff[2];
	switch (pkt_type)
	{
		case DVMEGA_ACK:
			dvmega_check_wait = TRUE;
			break;
		case DVMEGA_NAK:
			dvmega_check_wait = FALSE;
			break;

		case DVMEGA_DSTAR_HEADER:
			memcpy (connect_call, &rig_buff[22], 8);
			frameID = -1;
			break;

		case DVMEGA_DSTAR_DATA:
			break;
		
		case DVMEGA_DSTAR_LOST:
			syslog (LOG_DEBUG, "lost %2.2x %d %2.2x", rig_buff[0], rig_buff[1], rig_buff[2]);
			break;

		case DVMEGA_DSTAR_EOT:
			frameID = 0;
			break;

		case DVMEGA_GET_STATUS:
			#if 0
                        dvmega_mode = rig_buff[4] & 0x01;
                        dvmega_tx   = rig_buff[5];
                        dvmega_dstarSpace = rig_buff[6];
			#endif
			break;

		default:
			break;;
	}
	rig_buff_reset (length);
}

int     read_dvmega (void)
{
        int	length;
        int     i;
        if (FD_ISSET (rig_fd, &read_set))
        {
                length = read (rig_fd, &rig_buff[rig_buff_pnt],
                        sizeof(rig_buff) - rig_buff_pnt);
                if (length == -1)
                {
                        syslog(LOG_ERR, "rig read error %s", strerror(errno));
			return 0;
                }
                if (length > 0)
                {
                        rig_buff_pnt += length;
                        for (i = 0 ; i < rig_buff_pnt ; i++)
                        {
                                if (rig_buff[i] == DVMEGA_FRAME_START)
				{
					if (i > 0) 
					{
						memmove (rig_buff, &rig_buff[i], rig_buff_pnt);
						rig_buff_pnt -= i;
					}
					if (rig_buff_pnt > 2)
					{
						length = rig_buff[1];
						if (rig_buff_pnt >= length) return length;
					}
					return 0;
				}
			}
                        rig_buff_pnt = 0;
			return 0;
                }
        }
        return 0;
}

int	dv_mega_readStatus()
{
	unsigned char buffer[3];

	buffer[0U] = DVMEGA_FRAME_START;
	buffer[1U] = 3;
	buffer[2U] = DVMEGA_GET_STATUS;

	return write(rig_fd, buffer, 3);
}

int	dvmega_setFrequency(void)
{

	unsigned char buffer[20];
	long int	rxFrequency;
	long int	txFrequency;

	rxFrequency = dvmega_rxFrequency + dvmega_rxOffset;
	txFrequency = dvmega_txFrequency + dvmega_txOffset;

	buffer[0]  = DVMEGA_FRAME_START;
	buffer[1]  = 12;
	buffer[2]  = DVMEGA_SET_FREQ;
	buffer[3]  = 0x00;
	buffer[4]  = (rxFrequency >> 0) & 0xFF;
	buffer[5]  = (rxFrequency >> 8) & 0xFF;
	buffer[6]  = (rxFrequency >> 16) & 0xFF;
	buffer[7]  = (rxFrequency >> 24) & 0xFF;
	buffer[8]  = (txFrequency >> 0) & 0xFF;
	buffer[9]  = (txFrequency >> 8) & 0xFF;
	buffer[10] = (txFrequency >> 16) & 0xFF;
	buffer[11] = (txFrequency >> 24) & 0xFF;

	int ret = write(rig_fd, buffer, 12);
	if (ret != 12)
		return FALSE;
	return TRUE;
}

int     dvmega_setMode(unsigned char mode)
{
        unsigned char buffer[4];

        buffer[0] = DVMEGA_FRAME_START;
        buffer[1] = 4;
        buffer[2] = DVMEGA_SET_MODE;
        buffer[3] = mode;

        return write(rig_fd, buffer, 4);
}

void    dvmega_close (void)
{
        ssize_t len;

        tcsetattr (rig_fd, TCSANOW, &save_attr);
        dvmega_NoRespReply_sw = FALSE;
        //dvap_skip();
        dvmega_gw_resp_sw = FALSE;
        dvmega_last_frame_sw = FALSE;
        dvmega_voice_send_sw = FALSE;
        if (dvmega_sw)
        {
                syslog (LOG_INFO, "DVMEGA down.");
        }
        dvmega_sw = FALSE;
        FD_CLR (rig_fd, &fd_save);
        close (rig_fd);
        rig_fd = 0;
}

int	dvmega_setConfig(void)
{
	unsigned char buffer[30];

	memset (buffer, 0x00, sizeof(buffer));
	buffer[0] = DVMEGA_FRAME_START;
	buffer[1] = 24;
	buffer[2] = DVMEGA_SET_CONFIG;
	buffer[3] = 0x00;
	buffer[4] = 0x01;
	buffer[5] = dvmega_tx_delay / 10;		// In 10ms units
	buffer[6] = MODE_IDLE;
	buffer[7] = (unsigned char)(dvmega_rxLevel * 2.55F + 0.5F);
	buffer[11] = 128;           // Was OscOffset
	buffer[12] = (unsigned char)(dvmega_txLevel * 2.55F + 0.5F);

	return write(rig_fd, buffer, 24);
}

void    dvmega_write (int fd, unsigned char buff[], int length)
{
        unsigned char   send_buff[50];
        int     ret;
	unsigned short int	crc;
        if (length == 42)
        {
                send_buff[0] = DVMEGA_FRAME_START;
                send_buff[1] = 44;
                send_buff[2] = DVMEGA_DSTAR_HEADER;
                memcpy (&send_buff[3], &buff[2], 39);
		crc = crc_calc (&buff[2], 39);
		send_buff[42] = (crc >> 8) & 0xff;
		send_buff[43] = crc & 0xff;
		#ifdef	_DEBUG_DVMEGA
                syslog (LOG_DEBUG, "%8.8s %8.8s %8.8s %8.8s %4.4x", 
			&buff[5], &buff[13], &buff[21], &buff[29], crc);
		#endif
                ret = write (rig_fd, send_buff, 44);
        }
        else if (length == 17)
        {
                send_buff[0] = DVMEGA_FRAME_START;
                send_buff[1] = 15;
                send_buff[2] = DVMEGA_DSTAR_DATA;
                memcpy (&send_buff[3], &buff[4], 12);
                ret = write (rig_fd, send_buff, 15);
                if (buff[3] & 0x40)
                {
                        send_buff[0] = DVMEGA_FRAME_START;
                        send_buff[1] = 3;
                        send_buff[2] = DVMEGA_DSTAR_EOT;
                        ret = write (rig_fd, send_buff, 3);
                }
        }
        else
        {
                syslog (LOG_DEBUG, "write length %d", length);
        }
}
