import collector
import actor
import decider
import analyzer
import interface
import time

from threading import Thread

#this is the experiment branch
class hoppingSweeper(object):
    spi=0
    cpi=0
    ev=0
    pv=0
    ac=0
    remain=0
    strategy=0
    timeCounter=0
    discountrate=1
    def __init__(self,uri,gThrust,jThrust):
        #self.collector=collector.collector(1,'127.0.0.1',9999)
        self.collector=collector.collector()
        self.actor=actor.actor(gThrust,jThrust)
        self.interface =interface.interface(uri,self.actor,self.collector)
        self.analyzer=analyzer.analyzer(self.collector)
        self.decider= decider.decider(self.actor,self.analyzer)

    def getConnection(self):
        self.interface.getConnection()
    def disConnection(self):
        self.interface.disConnection()
    def startOperation1(self):
        self.p=1
        Thread(target=self.do_operation1).start()
    def startOperation2(self):
        self.p=1
        self.initAdaptationLogic(20)
        self.analyzer.startAnalyze2()
        Thread(target=self.do_operation2()).start()

    def startOperation3(self):
        self.p=1
        self.initAdaptationLogic(20)
        self.analyzer.startAnalyze2()
        Thread(target=self.do_operation3()).start()

    def startOperationD(self):
        self.p=1
        Thread(target=self.do_operaitonD()).start()
    def startOperationT(self):
        self.p=1
        Thread(target=self.do_operationT()).start()

    def startAdaptationLogic(self):
        self.p=1
        self.initAdaptationLogic(20)
        Thread(target=self.adaptationLogic()).start()

    def stopOperation(self):
        self.p=0

    def do_operation1(self):
        while self.p==1:
            r=self.analyzer.analyzeOnTable1()
            self.decider.decideOnTable1(r)
            #self.decider.decideOnStep(r)
            time.sleep(0.1)
    def do_operation2(self):
        while self.p==1:
            self.monitor()
            self.analyze()
            r=self.analyzer.analyzeOnTable2()
            if(r==0):
                self.actor.groundStop()
                self.p=0
            else :
                self.decider.decideOntable2(r,0.5)
            time.sleep(0.1)

    def do_operation3(self):
        while self.p==1:
            self.monitor()
            self.analyze()
            r=self.analyzer.analyzeOnTable2()
            if(r==0):
                self.p=0
            else :
                self.decider.decideOntable3(r)
            time.sleep(0.1)
        self.actor.groundStop()

    def do_operation4(self):
        while self.p==1:
            self.monitor()
            self.analyze()
            r=self.analyzer.analyzeOnTable2()
            if(r==0):
                self.p=0
            else :
                self.decider.decideOntable4(r)
            time.sleep(0.1)
        self.actor.groundStop()


    def adaptationLogic(self):
        while self.p==1:
            self.monitor()
            self.analyze()
            self.plan()
            self.execute()
        self.actor.groundStop()
    
    def initAdaptationLogic(self,t):
        self.analyzer.startAnalyze2()
        self.allPath=self.analyzer.analyzeRemainPath()
        self.startTime=time.clock()
        self.timeCounter=0
        self.timeOfPlan=t
        self.ecr=0.416#energy consumption rate
        self.reserveRate=1.2
        self.discountrate=1
        self.strategy=1
    def monitor(self):
        self.remain=self.analyzer.analyzeRemainPath()
        self.flightTime=self.collector.getFlightTime()
        self.timeCounter=(time.clock()-self.startTime)/2
        #print(self.timeCounter)
    def analyze(self):
        self.pv = self.timeCounter*self.ecr*self.reserveRate*self.discountrate
        self.ev=self.timeOfPlan*self.ecr*self.reserveRate*(self.allPath-self.remain)/self.allPath
        self.ac=self.ecr*self.flightTime
        if(self.pv!=0 and self.ac!=0):
            self.spi=self.ev/self.pv
            self.cpi=self.ev/self.ac
        else:
            self.spi=self.cpi=-1

    def plan(self):
        if self.spi>1.05 and self.cpi<1.0:
            self.strategy=0
        elif self.cpi>0 and self.cpi<1.0 and self.spi>0 and self.spi<1.0:
            #self.discountrate=self.discountrate*0.8
            #self.strategy=0
            self.strategy=4
        elif(((self.cpi>1.0 and self.cpi<1.05)or self.cpi>1.05) and self.spi<1.0):
            self.strategy=2
        elif(self.spi>1.0 and self.spi<1.05 and self.cpi<1.0):
            self.strategy=3
        else:
            self.strategy=1    
        print(self.strategy)
    def execute(self):
            if(self.strategy==0):
                self.actor.groundStop()
                time.sleep(0.1)
            elif(self.strategy==1):
                r=self.analyzer.analyzeOnTable2()
                if(r==0):
                    self.p=0
                else:
                    self.decider.decideOntable2(r,0.5)
            elif(self.strategy==2):
                r=self.analyzer.analyzeOnTable3()
                if(r==0):
                    self.p=0
                else:        
                    self.decider.decideOntable3(r)
            elif(self.strategy==3):
                r=self.analyzer.analyzeOnTable2()
                if(r==0):
                    print("end st2")
                    self.p=0
                else:
                    self.decider.decideOntable2(r,0.4)
            elif(self.strategy==4):
                r=self.analyzer.analyzeOnTable3()
                if(r==0):
                    self.p=0
                else:
                    print("is it ok?")
                    self.decider.decideOntable4(r)