package concurrentModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import model.ModelInterface;
import model.State;
import model.Transition;

public class ConcurrentModel implements ModelInterface{
	ConcurrentState initialState;
	String name;
	HashMap<String,ConcurrentState> states;
	List<String> statesName;
	List<Transition> updatedPart=new ArrayList<Transition>();

	ConcurrentModel(HashMap<String,ConcurrentState> states,List<Transition> updatePart) {
		this.name="concurrentModel";
		this.setStateMap(states);
		this.updatedPart=updatePart;
	}

	void setStateMap(HashMap<String,ConcurrentState> states){
		this.states=states;
		Iterator<String> it=this.states.keySet().iterator();
		this.statesName=new ArrayList<String>();
		//System.out.println("this is a test"+it.hasNext());
		while(it.hasNext()){
			this.statesName.add(it.next());
		}
//		System.out.println("setStatesMap"+this.statesName.size()+","+this.states.size());

	}
	public void setModelMaterials(HashMap<String,ConcurrentState> states,ConcurrentState initState){
		this.setInitialState(initState);
		this.setStateMap(states);
	}


	public ConcurrentModel() {
		states=new HashMap<String,ConcurrentState>();
		statesName=new ArrayList<String>();

	}
	public ConcurrentState getConcurrentState(int i){
		return states.get(statesName.get(i));
	}

	ConcurrentState getConcurrentState(String s){
		return states.get(s);
	}
	public State getInitialState(){
		return initialState;
	}

	public void setInitialState(State initState){
		this.initialState=(ConcurrentState)initState;
		this.statesName.add(initState.getName());
	}

	public int getSize(){
		return states.size();
	}
	String getName(int i){
		return this.statesName.get(i);
	}
	public State getState(int i){
//		System.out.println(statesName.size()+","+states.size()+","+i+":"+statesName.get(i));
		return states.get(statesName.get(i));
	}
	public State getErrorState(){
		return states.get("ERROR");
	}
	public List<Transition> getUpdatedPart(){
		return this.updatedPart;
	}

	public String getName(){
		return this.name;
	}

	public HashMap<String, ConcurrentState> getStates() {
		// TODO Auto-generated method stub
		return this.states;
	}
}
