# git-mq-integrity-check.sh
# ------------------------------------------------------------------------------
#
# Supplementary shell script fragment; invoked via "mq_require", it checks
# for equivalence of two (symbolic) commit references ("qtip" and "HEAD" by
# default), which may be specified as supplementary "mq_require" arguments.
#
# ------------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2019, Keith Marshall
#
#
# This file is part of the Git-MQ program suite.
#
# The Git-MQ program suite is free software: you can redistribute it
# and/or modify it under the terms of the GNU General Public Licence
# as published by the Free Software Foundation, either version 3 of
# the Licence, or (at your option) any later version.
#
# The Git-MQ program suite is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public Licence for more details.
#
# You should have received a copy of the GNU General Public Licence
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# ------------------------------------------------------------------------------
#
  set -- "${1-fatal}" "${2-qtip}"
  git_mq_getref(){ git rev-parse --quiet --verify $1; }
  git_mq_getref "$2" > /dev/null && {
    test x`git_mq_getref "$2"` = x`git_mq_getref HEAD` || {
      mq_complain "warning: '$2' is present, but is not at HEAD;"
      case "$1" in w*) set -- complain $1 ;; *) set -- abort 2 $1;; esac
      "mq_$@"": patch queue integrity has been compromised."
    }
  }
#
# ------------------------------------------------------------------------------
# $RCSfile$: end of file
