.nr HY 0
.TH GIT\-QGUARD 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qguard \- manage assignment of guards to patches
.
.
.SH SYNOPSIS
.BR git\ qguard \ [ \-l \ |\  \-\-list ]
.br
.BR git\ qguard \ [ \-n \ |\  \-\-none ]\ [< \fIpatch >]\ [ \-\- \ [ \+\c
.RI < guard >\ |\  \fB\- < guard >]\  \fB... ]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qguard
command may be used to set,
or to clear,
the guard assignments for any one patch,
or to display the current guard assignments for any one,
or for all patches in a
.B Git\-MQ
patch series.
.
.LP
The first form of
.BR git\ qguard ,
characterized by the specification of the
.BR \-l \ (or\  \-\-list )
option,
is used to display a list of all patches in the series,
together with the guards,
if any,
which have been assigned to each;
when using this form of the command,
it is an error to specify the
.BR \-n \ (or\  \-\-none )
option,
or any other arguments.
.
.LP
The second form of the command is used to set,
clear,
or display the guard assignments for a single patch,
nominated by the
.RI < patch >
argument;
if this is unspecified,
the topmost \%currently\(hyapplied patch is implied.
.
.LP
In the second form,
if the
.BR \-n \ (or\  \-\-none )
option is specified,
all guards,
if any,
which had been assigned previously,
to the nominated patch,
are cleared;
then,
any guards specified by
.BR \+ < \fIguard >
or
.BR \- < \fIguard >
arguments are assigned.
.
.LP
If
.BR \-n \ (or\  \-\-none )
is not specified,
and no
.BR \+ < \fIguard >
or
.BR \- < \fIguard >
arguments are specified,
then any guards which are currently assigned to the nominated patch
are displayed,
and remain unchanged.
.
.LP
Note that,
when any
.BR \+ < \fIguard >
or
.BR \- < \fIguard >
arguments are specified,
the specified guards will be assigned as
.I replacements
for any which were previously assigned to the nominated patch;
thus,
it is unnecessary,
(but not forbidden),
to specify
.BR \-n \ (or\  \-\-none )
in conjunction with new guard assignments.
.
.LP
Also note that the
.B \-\-
separator is mandatory,
if any guards of the
.BR \- < \fIguard >
form are to be assigned.
.
.LP
Guards control the behaviour of the
.B git\ qpush
command,
when pushing one or more patches,
according to the following strategy:\(em
.
.IP \(bu 3n
A patch with no guards assigned may be pushed unconditionally;
.
.IP \(bu
otherwise,
a patch with negative guards assigned may be pushed if,
and only if,
.I none
of those matches any guard which has been activated,
(and not subsequently deactivated),
by the
.B git\ qselect
command;
.
.IP \(bu
otherwise,
a patch with any positive guards assigned may be pushed if,
and only if,
.I every one
of those is matched by a guard which has been activated,
(and not subsequently deactivated),
by the
.B git\ qselect
command.
.
.IP \(bu
The ultimate push destination
.I must
represent a patch which may be pushed,
having satisfied the preceding conditions,
in the specified order;
otherwise,
the
.B git\ qpush
command fails,
without pushing any patch.
.
.IP \(bu
Provided the patch,
specified as the ultimate push destination,
may be pushed,
any other patches in the path to this destination will be pushed if,
and only if,
they fully satisfy the preceding sequence of conditions;
any which do not will be skipped.
.
.LP
It follows,
from the foregoing,
that any patch which has the same guard assigned in both the positive,
and in the negative sense,
can
.I never
be pushed.
.
.
.SH OPTIONS
.TP 4n
.BR \-l ,\  \-\-list
Enumerate all registered patches,
in series order,
and identify the set of guards,
if any,
which is associated with each;
this may not be used in conjunction with the
.B \-\-none
option,
or with any arguments.
.
.TP
.BR \-n ,\  \-\-none
Clear all guard assignments for the named
.RI < patch >,
(or for the topmost applied patch,
if no
.RI < patch >
argument is specified);
this is redundant,
and silently ignored,
if used in conjunction with any
.BR \+ < \fIguard >
or
.BR \- < \fIguard >
assignment arguments.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qguard
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qguard
command exhibits fundamentally the same behaviour as its
.B hg\ qguard
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qpush (1),
.BR git\-qselect (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
