.nr HY 0
.TH GIT\-QNEW 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qnew \- create a new patch and add it to the patch series
.
.
.SH SYNOPSIS
.B git qnew
.RB [ \-e ]\ [[[ \-m \ < \fItext >]\  ... ]\ |\ [ \-F \ <\c
.IR file >]]\ [ \fB\-a ]\ < patch >
.br
.B git qnew
.RB [ \-e ]\ [[[ \-m \ < \fItext >]\  ... ]\ |\ [ \-F \ <\c
.IR file >]]\ < patch >\ [< path >\  \fB... ]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qnew
command creates a new patch,
based on a new git commit,
and pushes it on to the top of the
.B Git\-MQ
patch series stack,
immediately following the topmost \%currently\(hyapplied patch,
(if any).
The
.RI < patch >
argument specifies the user\(aqs chosen name for the patch;
this will also be used as a tag name for the associated patch commit,
so must be chosen to comply with git\(aqs rules for naming tags.
.
.LP
By default,
the content of the patch is defined by changes
which are staged in git\(aqs index;
this behaviour may be modified,
either by use of the
.B \-a
(or
.BR \-\-all )
option, or by specifying a list of
.I path
name arguments,
following the
.I patch
name,
(but never by both together).
.
.LP
If the
.B \-a
(or
.BR \-\-all )
option is specified,
any local changes in tracked files are staged before creating
the git commit on which the patch is based;
this is effectively equivalent to the effect of,
and achieved by,
adding the
.B \-\-all
option to those specified for the
.B git commit
command whence the patch is to be derived.
.
.LP
If a list of files is specified,
the state of git\(aqs index is ignored,
and only the specified files are included in the commit
on which the patch is based.
All files which are specified must already exist within
the git working tree,
and must be known to,
and tracked by git;
any which do not exist,
or which lie outside the working tree,
will be diagnosed,
and execution of
.B git\ qnew
will be aborted;
any which are otherwise unknown to git
will be silently filtered out of the list.
.
.LP
The
.B \-e
(or
.BR \-\-edit ),
.B \-F
(or
.BR \-\-file ),
and
.B \-m
(or
.BR \-\-message )
options may be used to specify a commit message,
which will also be recorded in the patch header.
If none of these options is specified,
no commit message is recorded in the patch header,
and the default message,
\(lq[Git\-MQ]:\ <patch>\(rq",
is assigned for the associated commit.
.
.
.SH OPTIONS
.TP 4n
.BR \-a ,\  \-\-all
Stage all local modifications to tracked files,
such that they will be incorporated into the commit
which is to be associated with the created patch,
and whence its content is derived.
.
.TP
.BR \-e ,\  \-\-edit
Open an editor,
to facilitate modification of the commit message,
(which has been specified by use of
.BR \-\-file ,
or
.B \-\-message
options,
or by default),
before completing the commit whence the patch is derived;
(effectively,
this option is simply passed on to the
.B git\ commit
command which creates this commit).
.
.TP
.BR \-F \ < \fIname >,\  \-\-file =< \fIname >
.TQ
.BR \-l \ < \fIname >,\  \-\-logfile =< \fIname >
Read the text,
to be used as the commit message,
from the file specified by
.RI < name >;
if
.RI < name >
is specified as
.RB \(oq - \(cq,
read the commit message text from standard input.
By convention,
git expects the
.B \-F
(or
.BR \-\-file )
variant of this option;
the
.B \-l
(or
.BR \-\-logfile )
alias is accepted for compatibility with
.B hg\ qnew
usage.
.
.TP
.BR \-m \ < \fItext >,\  \-\-message =< \fItext >
Use
.RI < text >
for the commit message.
If more than one instance of this option is specified,
each individual
.RI < text >
block is appended to the commit message,
as a separate paragraph.
This feature
.I cannot
be used in conjunction with the
.B \-F
(or
.BR \-\-file )
option.
.
.TP
.BR \-D ,\  \-\-currentdate
Use the current date as the commit date,
(as would be the normal case);
record it within the patch header,
such that it will be preserved as the patch creation date,
unless explicitly reset,
during any subsequent
.BR git\ qrefresh ,
or
.BR git\ qimport
of this patch.
.
.TP
.BR \-d \ < \fIdatespec >,\  \-\-date =< \fIdatespec >
Set the commit date,
and hence the patch creation date,
to
.RI < datespec >,
(which may be specified using any date format recognized by
.BR git\ commit );
record this within the patch header,
such that it will be preserved as the patch creation date,
unless explicitly reset,
during any subsequent
.BR git\ qrefresh ,
or
.BR git\ qimport
of this patch.
.
.TP
.BR \-U ,\  \-\-currentuser
Record the identity of the current user as the author of the patch,
and of its associated commit,
such that this will be preserved,
unless explicitly reset,
during any subsequent
.BR git\ qrefresh ,
or
.BR git\ qimport
of this patch.
.
.TP
.BR \-u \ < \fIuserspec >,\  \-\-user =< \fIuserspec >
Record the identity of the user specified by
.RI < userspec >,
(which may be specified in any form recognized by
.BR git\ commit ),
as the author of the patch,
and of its associated commit,
such that this will be preserved,
unless explicitly reset,
during any subsequent
.BR git\ qrefresh ,
or
.BR git\ qimport
of this patch.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qnew
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Although inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the behaviour of the
.B git\ qnew
command differs from that of its
.B hg\ qnew
counterpart in the following respects:\(em
.
.IP \(bu 3m
The
.BR \-\-include ,
and
.B \-\-exclude
options, which are supported by
.BR hg\ qnew ,
are not (currently) supported by
.BR git\ qnew .
.
.IP \(bu 3m
The
.B \-\-all
option, described above,
is neither supported by,
nor required by
.BR hg\ qnew ;
it is provided,
as a
.B Git\-MQ
specific extension to the
.B Mercurial Queues
model,
to achieve more flexible interaction with git\(aqs index.
The command:
.RB \(lq git\ qnew\ \-\-all\ ...\c
.RI \ < patchname >\(rq
will deliver behaviour which is effectively equivalent to that of the
.RB \(lq hg\ qnew\ ...\c
.RI \ < patchname >\(rq
command.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-commit (1),
.BR git\-qimport (1),
.BR git\-qrefresh (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
