.nr HY 0
.TH GIT\-QPOP 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qpop \- pop patches from the Git\-MQ patch stack
.
.
.SH SYNOPSIS
.B git qpop
.RB [[ \-f \ [ \-\-no-backup ]]\ |\  \-\-keep\-changes ]\ [< \fIpatch >]
.br
.B git qpop
.RB [[ \-f \ [ \-\-no-backup ]]\ |\  \-\-keep\-changes ]\ [< \fIindex >]
.br
.B git qpop
.RB [[ \-f \ [ \-\-no-backup ]]\ |\  \-\-keep\-changes ]\ [ \-a \ |\  \-\-all ]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qpop
command will pop patches from the
.B Git\-MQ
applied patch stack,
until the patch specified by the
.RI < patch >
argument (an
.I applied
patch
.IR name ),
or by the
.RI < index >
argument (an
.I applied
patch
.IR sequence\~number ,
as reported by the
.B git\ qseries\ \-\-verbose
command),
becomes the topmost applied patch.
.
.LP
If the
.B \-a
.RB (or\  \-\-all )
option is selected,
then no
.RI < patch >
or
.RI < index >
argument should be specified;
this will pop
.I all
\%currently\(hyapplied patches,
leaving the patch stack empty.
.
.LP
If no
.RI < patch >
or
.RI < index >
argument is specified,
and the
.B \-\-all
option is not selected,
then only the one \%currently\(hytopmost patch will be popped,
leaving its most recently applied predecessor as the new topmost patch;
(this is the patch, if any, which would be identified by the
.B git\ qprev
command).
If there is no applied predecessor,
then the patch stack will be left empty.
.
.
.SH OPTIONS
.TP 4n
.BR \-a ,\  \-\-all
Pop all \%currently\(hyapplied patches,
thus leaving the patch stack empty.
.
.TP
.BR \-f ,\  \-\-force
If any files,
known to and tracked by git,
have been locally modified in the working tree,
or in git\(aqs index,
and the
.B \-\-no\-backup
option has not been specified,
first make backup backup copies of all locally modified files;
discard all local modifications,
then pop patches as appropriate.
.TP
\&
If the
.B \-\-force
option is not specified,
.B git\ qpop
will abort in the presence of local modifications.
.
.TP
.B \-\-no-backup
Used only in conjunction with
.BR \-\-force ,
(and silently ignored otherwise),
discard all local modifications,
.I without
making backup copies.
.
.TP
.B \-\-keep\-changes
Attempt to preserve local modifications,
while popping patches;
if any local modification conflicts with patch content,
abort the entire
.B git\ qpop
operation.
.TP
\&
(The
.B \-\-keep\-changes
option is currently unimplemented).
.
.LP
If there are local modifications to tracked files,
either in the working tree,
or staged in git\(aqs index,
and if neither the
.B \-\-force
option,
nor the
.B \-\-keep\-changes
option is specified,
then the
.B git\ qpop
operation will be aborted.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qpop
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qpop
command exhibits fundamentally the same behaviour as its
.B hg\ qpop
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qgoto (1),
.BR git\-qprev (1),
.BR git\-qseries (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
