.nr HY 0
.TH GIT\-QRENAME 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, 2022, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qrename \- rename the current, or any specified patch
.
.
.SH SYNOPSIS
.BR git\ qrename \ \c
.RI [< old\-name >]\ < new\-name >
.br
.BR git\ qmv \ \c
.RI [< old\-name >]\ < new\-name >
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qrename
command renames the existing
.B Git\-MQ
patch which is specified by the
.RI < old\-name >
argument,
assigning it the name specified by the
.RI < new\-name >
argument,
and updates the series and status files as may be necessary,
to reflect the change.
.
.LP
Patches may be renamed,
irrespective of the state of any guards to which they may be subject.
.
.LP
The
.B git\ qmv
form is a simple alias for
.BR git\ rename ;
both behave identically.
.
.LP
When both
.RI < old\-name >
and
.RI < new\-name >
are specified,
then the patch specified by
.RI < old\-name >
will be renamed,
regardless of whether it has been applied,
or not.
.
.LP
If the
.RI < old\-name >
argument is not specified,
then the name of the topmost applied patch is implied;
in this case,
the command fails if no patches have been applied.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qrename
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qrename
command exhibits fundamentally the same behaviour as its
.B hg\ qrename
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, 2022, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qapplied (1),
.BR git\-qguard (1),
.BR git\-qselect (1),
.BR git\-qseries (1),
.BR git\-qtop (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
