# optdefn.sh
# -----------------------------------------------------------------------------
#
# Infrastructure module, implementing the handlers for defining and parsing
# of command line options and variable assignments.
#
# -----------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keithmarshall@users.sourceforge.net>
# Copyright (C) 2011, 2013, MinGW.org Project
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
  optdefine(){
    test "x$1" = x || {
      longopts="${longopts+"$longopts "}$1"
      eval opteval_`sanitized_name $1`'(){ optunhandled "$@"; }'
    }
    test "x$2" = x || {
      shortopts="${shortopts+"$shortopts "}$2"
      eval opteval_$2'(){ optunhandled "$@"; }'
    }
  }

  optunhandled(){
    die "'$1':option '$optmatch' declared but no handler implemented"
  }

  optchk(){
    optmatch= argshift=1
    case $1 in
      -)   argshift=0; false
	   ;;
      --)  optmatch="--"
	   ;;
      --*) arg="$1"
	   case $arg in *=*)
	     optarg="`echo "$arg" | sed 's,^[^=]*=,,'`"
	     arg="`IFS='='; set -- $arg; defn_parameter_list $1`"
	   esac
	   for opt in $longopts
	   do case --$opt in $arg*)
		test "x$optmatch" = x || die "option '$1' is ambiguous"
		optmatch=`sanitized_name $opt`
	      esac
	   done
	   opteval "$@"
	   ;;
      -*)  die "'$1': no short form options defined"
	   ;;
      *=*) optarg="`echo "$1" | sed 's,^[^=]*=,,'`"
	   arg="`IFS='='; set -- $1; defn_parameter_list $1`"
	   eval $arg='"$optarg"'
	   ;;
      *)   argshift=0; false
    esac
  }

  opteval(){
    test "x$optmatch" = x && die "unknown option: '$1'"
    opteval_$optmatch "$@"
  }

  option(){
    var=`sanitized_name $1`_options; shift
    eval $var'="`defn_parameter_list $'$var' "$@"`"'
  }

  sanitized_name(){
    echo "$@" | sed 's,[^0-9A-Za-z],_,g'
  }
#
# -----------------------------------------------------------------------------
# $RCSfile$: end of file
