// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.collision;
import mn.jp.kekkouyakan.geom.KyVector2f;
import mn.jp.kekkouyakan.util.KyFloatComparator;

public class ColCircle extends ColShape
{//{{{
	float radius;
	public ColCircle( float radius_, KyFloatComparator floatComparator_ )
	{//{{{
		super( floatComparator_ );
		radius = radius_;
	}//}}}
	public ColCircle( float x_, float y_, float radius_, KyFloatComparator floatComparator_ )
	{//{{{
		this( radius_, floatComparator_ );
		transform.position.x = x_;
		transform.position.y = y_;
	}//}}}
	public float getRadius()
	{//{{{
		float scale_ = Math.max( Math.abs(transform.scale.x), Math.abs(transform.scale.y) );
		return radius * scale_;
	}//}}}
	@Override
	public ColShape generateNext( ColTransform delta_ )
	{//{{{
		ColCircle shape_ = new ColCircle( radius, floatComparator );
		shape_.body = body;
		updateNext( shape_, delta_ );
		return shape_;
	}//}}}
	@Override
	public float getMinX()
	{//{{{
		return transform.position.x - getRadius();
	}//}}}
	@Override
	public float getMinY()
	{//{{{
		return transform.position.y - getRadius();
	}//}}}
	@Override
	public float getMaxX()
	{//{{{
		return transform.position.x + getRadius();
	}//}}}
	@Override
	public float getMaxY()
	{//{{{
		return transform.position.y + getRadius();
	}//}}}
	@Override
	public KyVector2f getVector( int index_ )
	{//{{{
		return transform.position;
	}//}}}
}//}}}

