// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.collision;
import mn.jp.kekkouyakan.geom.KyVector2f;
import mn.jp.kekkouyakan.util.KyFloatComparator;

public abstract class ColShape
{//{{{
	ColBody body = null;
	ColTransform transform = null;
	ColTransform delta = null;
	boolean keepDelta = false;
	Object userObject = null;
	ColTransform lastDelta = null;
	KyFloatComparator floatComparator;

	public ColShape( KyFloatComparator floatComparator_ )
	{//{{{
		transform = new ColTransform();
		transform.position.x = 0f;
		transform.position.y = 0f;
		transform.scale.x = 1.0f;
		transform.scale.y = 1.0f;
		transform.angle360 = 0f;
		floatComparator = floatComparator_;
	}//}}}

	public ColBody getBody()
	{//{{{
		return body;
	}//}}}
	public ColTransform getTransform()
	{//{{{
		return transform;
	}//}}}
	public ColTransform getDelta()
	{//{{{
		return delta;
	}//}}}
	public ColTransform getLastDelta()
	{//{{{
		return lastDelta;
	}//}}}

	public ColShape generateNext()
	{//{{{
		return generateNext( delta );
	}//}}}
	public ColShape generateNext( float progress_ )
	{//{{{
		if( delta == null ){
			return null;
		}
		if( floatComparator.equals( progress_, 0.0f ) ){
			return null;
		}
		if( floatComparator.equals( progress_, 1.0f ) ){
			return generateNext( delta );
		}
		else{
			return generateNext( delta.mul( progress_ ) );
		}
	}//}}}
	public void updateNext( ColShape next_, ColTransform delta_ )
	{//{{{
		if( next_ != null ){
			next_.transform = transform.add( delta_ );
			next_.lastDelta = delta_;
			next_.keepDelta = keepDelta;
			if( keepDelta ){
				next_.delta = delta.getClone();
			}
			else{
				next_.delta = new ColTransform();
			}
		}
	}//}}}
	public abstract KyVector2f getVector( int index_ );
	public abstract ColShape generateNext( ColTransform delta_ );
	public abstract float getMinX();
	public abstract float getMinY();
	public abstract float getMaxX();
	public abstract float getMaxY();
}//}}}
