// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.collision;
import mn.jp.kekkouyakan.util.KyLinkedElement;
import mn.jp.kekkouyakan.util.KyFloatComparator;

public class ColShareControl extends ColControl
{//{{{
	public static interface IHandler
	{//{{{
		boolean hasCollisionRelation( ColBody bd1_, ColBody bd2_ );
		void beginCollision( ColWorld world_ );
		void beginBodyCollision( ColBody body_ );
		void collideWith( ColBody bd1_, ColBody bd2_ );
		void outOfRange( ColSpace space_, ColBody bd_, ColShape shape_ );
		void endBodyCollision( ColBody body_ );
		void endCollision( ColWorld world_ );
	}//}}}
	public static class DefaultHandler implements IHandler
	{//{{{
		public boolean hasCollisionRelation( ColBody bd1_, ColBody bd2_ )
		{//{{{
			return true;
		}//}}}
		public void beginCollision( ColWorld world_ )
		{//{{{
		}//}}}
		public void beginBodyCollision( ColBody body_ )
		{//{{{
		}//}}}
		public void collideWith( ColBody bd1_, ColBody bd2_ )
		{//{{{
		}//}}}
		public void outOfRange( ColSpace space_, ColBody bd_, ColShape shape_ )
		{//{{{
		}//}}}
		public void endBodyCollision( ColBody body_ )
		{//{{{
		}//}}}
		public void endCollision( ColWorld world_ )
		{//{{{
		}//}}}
	}//}}}

	IHandler handler;
	KyFloatComparator floatComparator;
	public ColShareControl( IHandler handler_, KyFloatComparator floatComparator_ )
	{//{{{
		handler = handler_;
		floatComparator = floatComparator_;
	}//}}}
	@Override
	public void onUpdate( ColWorld world_, float vt_ )
	{//{{{
		handler.beginCollision( world_ );
		for( final ColBody bd_ : world_.bodyHead ){
			handler.beginBodyCollision( bd_ );

			if( bd_.defaultTransform == null ){
				handler.endBodyCollision( bd_ );
				continue;
			}

			ColTransform delta_ = bd_.defaultTransform.mul( vt_ );
			final ColShape shape_ = bd_.shape.generateNext( delta_ );

			ColSpace.IVisitorEx vi_ = new ColSpace.IVisitorEx(){
				Object userObject = null;
				public boolean visit( ColSpace.Node node_ ){
					ColBody nodeBody_ = (ColBody)node_.getValue();
					if( bd_ == nodeBody_ ){
						return true;
					}
					if( !hasCollisionRelation( bd_, nodeBody_ ) ){
						return true;
					}
					if( ColResult.isSharedShape( floatComparator, shape_, nodeBody_.shape ) ){
						userObject = shape_;
						handler.collideWith( bd_, nodeBody_ );
					}
					return true;
				}
				public Object getUserObject()
				{
					return userObject;
				}
			};
			if( !world_.space.visitCollisionNodes( bd_.shape, shape_, vi_ ) ){
				handler.outOfRange( world_.space, bd_, shape_ );
				handler.endBodyCollision( bd_ );
				continue;
			}

			handler.endBodyCollision( bd_ );
			if( vi_.getUserObject() == null ){
				bd_.shape = shape_;
				world_.updateBody( bd_ );
			}
		}
		handler.endCollision( world_ );
		for( KyLinkedElement<ColBody>
			bdElem_ = world_.bodyHead.getNext();
			bdElem_ != null;
			bdElem_ = bdElem_.getNext()
		){
			if( bdElem_.getValue().isDead() ){
				bdElem_.disconnect();
			}
		}
	}//}}}
}//}}}

