// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.collision;
import mn.jp.kekkouyakan.geom.KyVector2f;
import mn.jp.kekkouyakan.util.KyFloatComparator;

public class ColVectors extends ColShape
{//{{{
	KyVector2f[] initialPoints = null;
	KyVector2f[] currentPoints = null;
	int indexOfMinX = 0;
	int indexOfMinY = 0;
	int indexOfMaxX = 0;
	int indexOfMaxY = 0;

	ColVectors( KyVector2f[] initialPoints_, KyVector2f[] currentPoints_, KyFloatComparator floatComparator_ )
	{//{{{
		super( floatComparator_ );
		assert( initialPoints_ != null );
		initialPoints = initialPoints_;
		currentPoints = currentPoints_;
		floatComparator = floatComparator_;
		updateMinMax();
	}//}}}
	public ColVectors( KyVector2f[] initialPoints_, KyFloatComparator floatComparator_ )
	{//{{{
		this( new KyVector2f(0,0), initialPoints_, floatComparator_ );
	}//}}}
	public ColVectors( KyVector2f origin_, KyVector2f[] initialPoints_, KyFloatComparator floatComparator_ )
	{//{{{
		super( floatComparator_ );
		int len_ = initialPoints_.length;
		if( initialPoints_[0] == initialPoints_[initialPoints_.length-1] ){
			--len_;
		}
		if( origin_ == null ){
			origin_ = new KyVector2f(0, 0);
		}
		transform.position.copy( origin_ );
		initialPoints = new KyVector2f[ initialPoints_.length ];
		currentPoints = new KyVector2f[ initialPoints_.length ];
		for( int i_ = 0; i_ < len_; ++i_ ){
			initialPoints[ i_ ] = initialPoints_[i_].sub( origin_ );
			currentPoints[ i_ ] = initialPoints_[i_];
		}
		if( len_ != initialPoints_.length ){
			initialPoints[len_] = initialPoints[0];
			currentPoints[len_] = currentPoints[0];
		}
		updateMinMax();
	}//}}}
	public static KyVector2f[] getBallPoints1( ColResult res_ )
	{//{{{
		return getBallPoints( res_, res_.ballShape1 );
	}//}}}
	public static KyVector2f[] getBallPoints2( ColResult res_ )
	{//{{{
		return getBallPoints( res_, res_.ballShape2 );
	}//}}}
	public static KyVector2f[] getBallPoints( ColResult res_, ColShape ballShape_ )
	{//{{{
		if( !(ballShape_ instanceof ColVectors) ){
			return null;
		}
		ColVectors vecs_ = (ColVectors)ballShape_;
		if( res_.ballIndex1 >= 0 ){
			if( res_.ballIndex2 >= 0 ){
				return new KyVector2f[]{
					vecs_.currentPoints[ res_.ballIndex1 ],
					vecs_.currentPoints[ res_.ballIndex2 ]
				};
			}
			else{
				return new KyVector2f[]{
					vecs_.currentPoints[ res_.ballIndex1 ]
				};
			}
		}
		return null;
	}//}}}
	public static KyVector2f[] getWallPoints( ColResult res_ )
	{//{{{
		if( !(res_.wallShape instanceof ColVectors) ){
			return null;
		}
		ColVectors vecs_ = (ColVectors)res_.wallShape;
		if( res_.wallIndex1 >= 0 ){
			if( res_.wallIndex2 >= 0 ){
				return new KyVector2f[]{
					vecs_.currentPoints[ res_.wallIndex1 ],
					vecs_.currentPoints[ res_.wallIndex2 ]
				};
			}
			else{
				return new KyVector2f[]{
					vecs_.currentPoints[ res_.wallIndex1 ]
				};
			}
		}
		return null;
	}//}}}
	public static KyVector2f[] transform( KyFloatComparator cmp_, KyVector2f[] outLs_, KyVector2f[] inLs_, ColTransform t_ )
	{//{{{
		assert( inLs_ != null );
		int len_ = inLs_.length;
		if( inLs_[0] == inLs_[len_-1] ){
			--len_;
		}
		if( outLs_ == null ){
			outLs_ = new KyVector2f[ inLs_.length ];
			for( int i_ = 0; i_ < len_; ++i_ ){
				outLs_[i_] = inLs_[i_].getClone();
			}
		}
		assert( outLs_.length == inLs_.length );
		for( int i_ = 0; i_ < len_; ++i_ ){
			t_.apply( cmp_, outLs_[i_] );
		}
		if( len_ != inLs_.length ){
			outLs_[len_] = outLs_[0];
		}
		return outLs_;
	}//}}}

	static float mod( float lhs_, float rhs_ )
	{//{{{
		int n_ = (int)(lhs_ / rhs_);
		return lhs_ - (float)n_ * rhs_;
	}//}}}

	@Override
	public ColShape generateNext( ColTransform delta_ )
	{//{{{
		ColVectors next_ = new ColVectors( initialPoints, floatComparator );
		next_.body = body;
		updateNext( next_, delta_ );
		next_.currentPoints = transform( floatComparator, null, initialPoints, next_.transform );
		if( floatComparator.equals( mod( next_.delta.angle360, 360 ), 0f ) ){
			float sx_ = next_.transform.scale.x;
			float sy_ = next_.transform.scale.y;
			if( floatComparator.less( sx_, 0f ) ){
				next_.indexOfMaxX = indexOfMinX;
				next_.indexOfMinX = indexOfMaxX;
			}
			else{
				next_.indexOfMaxX = indexOfMaxX;
				next_.indexOfMinX = indexOfMinX;
			}
			if( floatComparator.less( sy_, 0f ) ){
				next_.indexOfMaxY = indexOfMinY;
				next_.indexOfMinY = indexOfMaxY;
			}
			else{
				next_.indexOfMaxY = indexOfMaxY;
				next_.indexOfMinY = indexOfMinY;
			}
		}
		else{
			next_.updateMinMax();
		}
		return next_;
	}//}}}

	void updateMinMax()
	{//{{{
		if( currentPoints == null ){
			return;
		}
		int sz_ = currentPoints.length;
		if( currentPoints[0] == currentPoints[sz_-1] ){
			--sz_;
		}
		indexOfMinX = indexOfMaxX = indexOfMinY = indexOfMaxY = 0;
		for( int i_ = 1; i_ < sz_; ++i_ ){
			KyVector2f p_ = currentPoints[i_];
			if( floatComparator.less( p_.x, currentPoints[ indexOfMinX ].x ) ){
				indexOfMinX = i_;
			}
			if( floatComparator.more( p_.x, currentPoints[ indexOfMaxX ].x ) ){
				indexOfMaxX = i_;
			}
			if( floatComparator.less( p_.y, currentPoints[ indexOfMinY ].y ) ){
				indexOfMinY = i_;
			}
			if( floatComparator.more( p_.y, currentPoints[ indexOfMaxY ].y ) ){
				indexOfMaxY = i_;
			}
		}
	}//}}}

	@Override
	public float getMinX()
	{//{{{
		return currentPoints[ indexOfMinX ].x;
	}//}}}
	@Override
	public float getMinY()
	{//{{{
		return currentPoints[ indexOfMinY ].y;
	}//}}}
	@Override
	public float getMaxX()
	{//{{{
		return currentPoints[ indexOfMaxX ].x;
	}//}}}
	@Override
	public float getMaxY()
	{//{{{
		return currentPoints[ indexOfMaxY ].y;
	}//}}}
	@Override
	public KyVector2f getVector( int index_ )
	{//{{{
		return currentPoints[ index_ ];
	}//}}}
}//}}}

