// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.geom;
import mn.jp.kekkouyakan.functional.IKyAction1;
import java.util.ArrayList;
import mn.jp.kekkouyakan.util.KyFloatComparator;

public class KyVector2f implements Comparable<KyVector2f>
{//{{{
	final static KyFloatComparator defaultComparator = new KyFloatComparator();

	public float x;
	public float y;
	public KyVector2f()
	{//{{{
		x = 0;
		y = 0;
	}//}}}
	public KyVector2f( float x_, float y_ )
	{//{{{
		x = x_;
		y = y_;
	}//}}}
	public KyVector2f getClone()
	{//{{{
		return new KyVector2f( x, y );
	}//}}}
	public KyVector2f normalizeLocal()
	{//{{{
		float pow_ = (float)Math.sqrt( x * x + y * y );
		x /= pow_;
		y /= pow_;
		return this;
	}//}}}
	public KyVector2f negativeLocal()
	{//{{{
		return mulLocal( -1f );
	}//}}}
	public KyVector2f addLocal( KyVector2f rhs_ )
	{//{{{
		x += rhs_.x;
		y += rhs_.y;
		return this;
	}//}}}
	public KyVector2f subLocal( KyVector2f rhs_ )
	{//{{{
		x -= rhs_.x;
		y -= rhs_.y;
		return this;
	}//}}}
	public KyVector2f mulLocal( KyVector2f rhs_ )
	{//{{{
		x *= rhs_.x;
		y *= rhs_.y;
		return this;
	}//}}}
	public KyVector2f divLocal( KyVector2f rhs_ )
	{//{{{
		x /= rhs_.x;
		y /= rhs_.y;
		return this;
	}//}}}
	public KyVector2f addLocal( float rhs_ )
	{//{{{
		x += rhs_;
		y += rhs_;
		return this;
	}//}}}
	public KyVector2f subLocal( float rhs_ )
	{//{{{
		x -= rhs_;
		y -= rhs_;
		return this;
	}//}}}
	public KyVector2f mulLocal( float rhs_ )
	{//{{{
		x *= rhs_;
		y *= rhs_;
		return this;
	}//}}}
	public KyVector2f divLocal( float rhs_ )
	{//{{{
		x /= rhs_;
		y /= rhs_;
		return this;
	}//}}}
	public KyVector2f normalize()
	{//{{{
		return getClone().normalizeLocal();
	}//}}}
	public KyVector2f negative()
	{//{{{
		return getClone().negativeLocal();
	}//}}}
	public KyVector2f add( KyVector2f rhs_ )
	{//{{{
		return getClone().addLocal( rhs_ );
	}//}}}
	public KyVector2f sub( KyVector2f rhs_ )
	{//{{{
		return getClone().subLocal( rhs_ );
	}//}}}
	public KyVector2f mul( KyVector2f rhs_ )
	{//{{{
		return getClone().mulLocal( rhs_ );
	}//}}}
	public KyVector2f div( KyVector2f rhs_ )
	{//{{{
		return getClone().divLocal( rhs_ );
	}//}}}
	public KyVector2f add( float rhs_ )
	{//{{{
		return getClone().addLocal( rhs_ );
	}//}}}
	public KyVector2f sub( float rhs_ )
	{//{{{
		return getClone().subLocal( rhs_ );
	}//}}}
	public KyVector2f mul( float rhs_ )
	{//{{{
		return getClone().mulLocal( rhs_ );
	}//}}}
	public KyVector2f div( float rhs_ )
	{//{{{
		return getClone().divLocal( rhs_ );
	}//}}}
	public KyVector2f add( int rhs_ )
	{//{{{
		return getClone().addLocal( rhs_ );
	}//}}}
	public KyVector2f sub( int rhs_ )
	{//{{{
		return getClone().subLocal( rhs_ );
	}//}}}
	public KyVector2f mul( int rhs_ )
	{//{{{
		return getClone().mulLocal( rhs_ );
	}//}}}
	public KyVector2f div( int rhs_ )
	{//{{{
		return getClone().divLocal( rhs_ );
	}//}}}
	public float magnitude()
	{//{{{
		return (float)Math.sqrt( x*x + y*y );
	}//}}}
	public float magnitudeSquared()
	{//{{{
		return x*x + y*y;
	}//}}}
	public float magnitudeSquared( KyVector2f vec_ )
	{//{{{
		float x_ = x - vec_.x;
		float y_ = y - vec_.y;
		return x_*x_ + y_*y_;
	}//}}}
	@Override
	public String toString()
	{//{{{
		return String.format( "x=%f y=%f", x, y );
	}//}}}
	public boolean isOrigin()
	{//{{{
		return x == 0f && y == 0f;
	}//}}}
	public KyVector2f copy( KyVector2f rhs_ )
	{//{{{
		x = rhs_.x;
		y = rhs_.y;
		return this;
	}//}}}
	public float dot( KyVector2f rhs_ )
	{//{{{
		return x * rhs_.x + y * rhs_.y;
	}//}}}
	public float cross( KyVector2f rhs_ )
	{//{{{
		return x * rhs_.y - y * rhs_.x;
	}//}}}
	public boolean equals( Object rhs_ )
	{//{{{
		if( rhs_ == null ){
			return false;
		}
		else if( rhs_ == this ){
			return true;
		}
		else if( rhs_ instanceof KyVector2f ){
			return compareTo( defaultComparator, (KyVector2f)rhs_ ) == 0;
		}
		return false;
	}//}}}
	public boolean equals( KyFloatComparator cmp_, KyVector2f rhs_ )
	{//{{{
		if( rhs_ == null ){
			return false;
		}
		else if( rhs_ == this ){
			return true;
		}
		return compareTo( cmp_, rhs_ ) == 0;
	}//}}}
	public boolean equals( KyFloatComparator cmp_, float x_, float y_ )
	{//{{{
		if( !cmp_.equals( x, x_ ) ){
			return false;
		}
		if( !cmp_.equals( y, y_ ) ){
			return false;
		}
		return true;
	}//}}}
	public boolean equals( float x_, float y_ )
	{//{{{
		return equals( defaultComparator, x_, y_ );
	}//}}}
	public int compareTo( KyFloatComparator cmp_, KyVector2f rhs_ )
	{//{{{
		if( cmp_ == null ){
			cmp_ = defaultComparator;
		}
		int v_ = cmp_.compare( x, rhs_.x );
		if( v_ == 0 ){
			return cmp_.compare( y, rhs_.y );
		}
		return v_;
	}//}}}
	public int compareTo( KyVector2f rhs_ )
	{//{{{
		return compareTo( defaultComparator, rhs_ );
	}//}}}
	public KyVector2f orth( KyVector2f a_ )
	{//{{{
		return a_.mul( dot( a_ )/a_.magnitudeSquared() );
	}//}}}

	public static KyVector2f getIntersection( KyVector2f a1_, KyVector2f a2_, KyVector2f b1_, KyVector2f b2_ )
	{//{{{
		//http://www.deqnotes.net/acmicpc/2d_geometry/lines
		KyVector2f a_ = a2_.sub( a1_ );
		KyVector2f b_ = b2_.sub( b1_ );
		float d1_ = Math.abs( b_.cross( a1_.sub(b1_) ) );
		float d2_ = Math.abs( b_.cross( a2_.sub(b1_) ) );
		float t_ = d1_ / (d1_ + d2_);
		return a1_.add( a_.mul(t_) );
	}//}}}

	public static boolean isIntersected( KyFloatComparator cmp_, KyVector2f a1_, KyVector2f a2_, KyVector2f b1_, KyVector2f b2_ )
	{//{{{
		//http://www.deqnotes.net/acmicpc/2d_geometry/lines
		KyVector2f a_ = a2_.sub( a1_ );
		KyVector2f b_ = b2_.sub( b1_ );
		return cmp_.less( a_.cross( b1_.sub( a1_ ) ) * a_.cross( b2_.sub( a1_ ) ), 0f )
		&& cmp_.less( b_.cross( a1_.sub( b1_ ) ) * b_.cross( a2_.sub( b1_ ) ), 0f );
	}//}}}
	public static boolean isIntersected( KyVector2f a1_, KyVector2f a2_, KyVector2f b1_, KyVector2f b2_ )
	{//{{{
		return isIntersected( defaultComparator, a1_, a2_, b1_, b2_ );
	}//}}}
	public static boolean isIntersectedLines( KyFloatComparator cmp_, KyVector2f a1_, KyVector2f a2_, KyVector2f... bLs_ )
	{//{{{
		assert( bLs_.length > 1 );
		for( int i_ = 1; i_ < bLs_.length; ++i_ ){
			KyVector2f b1_ = bLs_[i_-1];
			KyVector2f b2_ = bLs_[i_];
			if( isIntersected( cmp_, a1_, a2_, b1_, b2_ ) ){
				return true;
			}
		}
		return false;
	}//}}}
	public static boolean isIntersectedLines( KyVector2f a1_, KyVector2f a2_, KyVector2f... bLs_ )
	{//{{{
		return isIntersectedLines( defaultComparator, a1_, a2_, bLs_ );
	}//}}}

	public static float minX( KyVector2f[] vecLs_ )
	{//{{{
		float v_ = vecLs_[0].x;
		for( int i_ = 1; i_ < vecLs_.length; ++i_ ){
			if( v_ > vecLs_[i_].x ){
				v_ = vecLs_[i_].x;
			}
		}
		return v_;
	}//}}}
	public static float minY( KyVector2f[] vecLs_ )
	{//{{{
		float v_ = vecLs_[0].y;
		for( int i_ = 1; i_ < vecLs_.length; ++i_ ){
			if( v_ > vecLs_[i_].y ){
				v_ = vecLs_[i_].y;
			}
		}
		return v_;
	}//}}}
	public static float maxX( KyVector2f[] vecLs_ )
	{//{{{
		float v_ = vecLs_[0].x;
		for( int i_ = 1; i_ < vecLs_.length; ++i_ ){
			if( v_ < vecLs_[i_].x ){
				v_ = vecLs_[i_].x;
			}
		}
		return v_;
	}//}}}
	public static float maxY( KyVector2f[] vecLs_ )
	{//{{{
		float v_ = vecLs_[0].y;
		for( int i_ = 1; i_ < vecLs_.length; ++i_ ){
			if( v_ < vecLs_[i_].y ){
				v_ = vecLs_[i_].y;
			}
		}
		return v_;
	}//}}}
	public static float getDistance( KyVector2f p_, KyVector2f q_ )
	{//{{{
		float x_ = p_.x - q_.x;
		float y_ = p_.y - q_.y;
		return (float)Math.sqrt( x_*x_ + y_*y_ );
	}//}}}
	public static KyVector2f relative( float rx_, float ry_, KyVector2f[] vecLs_ )
	{//{{{
		float x0_ = minX( vecLs_ );
		float y0_ = minY( vecLs_ );
		float x1_ = maxX( vecLs_ );
		float y1_ = maxY( vecLs_ );
		float x_ = rx_*(x1_-x0_) + x0_;
		float y_ = ry_*(y1_-y0_) + y0_;
		return new KyVector2f( x_, y_ );
	}//}}}
}//}}}
