// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.test;
import java.io.PrintStream;
import java.io.File;
import java.io.FileNotFoundException;

public class SvgWriter extends XmlWriter
{//{{{
	String stroke = null;
	String strokeWidth = null;
	String fill = null;
	String fontFamily=null;
	String fontSize=null;

	float scaleX = 1f;
	float scaleY = 1f;
	float offsetX = 0f;
	float offsetY = 0f;
	float x( float x_ )
	{//{{{
		return scaleX*x_ + offsetX;
	}//}}}
	float y( float y_ )
	{//{{{
		return scaleY*y_ + offsetY;
	}//}}}

	public SvgWriter( PrintStream stream_ )
	{//{{{
		super( stream_ );
	}//}}}
	public SvgWriter( File file_ ) throws FileNotFoundException
	{//{{{
		super( file_ );
	}//}}}
	public SvgWriter( String filePath_ ) throws FileNotFoundException
	{//{{{
		super( filePath_ );
	}//}}}
	public SvgWriter( XmlWriter xml_ )
	{//{{{
		super( xml_ );
	}//}}}
	public void setView( float sx_, float sy_, float ox_, float oy_ )
	{//{{{
		scaleX = sx_;
		scaleY = sy_;
		offsetX = ox_;
		offsetY = oy_;
	}//}}}
	public String getStroke()
	{//{{{
		return stroke;
	}//}}}
	public void setStroke( String value_ )
	{//{{{
		stroke = value_;
	}//}}}
	public void setStrokeWidth( String value_ )
	{//{{{
		strokeWidth = value_;
	}//}}}
	public String getStrokeWidth()
	{//{{{
		return strokeWidth;
	}//}}}
	public void setFill( String value_ )
	{//{{{
		fill = value_;
	}//}}}
	public String getFill()
	{//{{{
		return fill;
	}//}}}
	public void setFontFamily( String value_ )
	{//{{{
		fontFamily = value_;
	}//}}}
	public void setFontSize( String value_ )
	{//{{{
		fontSize = value_;
	}//}}}
	public PrintStream getStream()
	{//{{{
		return out;
	}//}}}
	public void beginSvgTag( int width_, int height_ )
	{//{{{
		out.println( "<svg" );
		out.printf ( " width=\"%dpx\" height=\"%dpx\"", width_, height_ );
		out.println( " xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\"" );
		out.println( ">" );
	}//}}}
	public void printStroke()
	{//{{{
		if( stroke != null ){
			out.printf( " stroke=\"%s\"%n", stroke );
		}
	}//}}}
	public void printStrokeWidth()
	{//{{{
		if( stroke != null ){
			out.printf( " stroke-width=\"%s\"%n", strokeWidth );
		}
	}//}}}
	public void printFill()
	{//{{{
		if( fill != null ){
			out.printf( " fill=\"%s\"%n", fill );
		}
	}//}}}
	public void printFontFamily()
	{//{{{
		if( fontFamily != null ){
			out.printf( " font-family=\"%s\"%n", fontFamily );
		}
	}//}}}
	public void printFontSize()
	{//{{{
		if( fontSize != null ){
			out.printf( " font-size=\"%s\"%n", fontSize );
		}
	}//}}}
	public void drawGrid( float pitch_, int countX_, int countY_, float x0_, float y0_ )
	{//{{{
		for( int i_ = 0; i_ < countX_+1; ++i_ ){
			float x1_ = x0_ + pitch_ * i_;
			float y1_ = y0_;
			float x2_ = x1_;
			float y2_ = y0_ + pitch_ * countY_;
			out.println( "<path" );
			out.printf ( " d=\"M%f,%f L%f,%f\"%n", x(x1_), y(y1_), x(x2_), y(y2_) );
			printStroke();
			printStrokeWidth();
			out.println( "/>" );
		}
		for( int i_ = 0; i_ < countY_+1; ++i_ ){
			float y1_ = y0_ + pitch_ * i_;
			float x1_ = x0_;
			float y2_ = y1_;
			float x2_ = x0_ + pitch_ * countX_;
			out.println( "<path" );
			out.printf ( " d=\"M%f,%f L%f,%f\"%n", x(x1_), y(y1_), x(x2_), y(y2_) );
			printStroke();
			printStrokeWidth();
			out.println( "/>" );
		}
	}//}}}
	public void drawGridText( float pitch_, int countX_, int countY_, float x0_, float y0_ )
	{//{{{
		for( int x_ = 0; x_ < countX_+1; ++x_ ){
			float x1_ = (x0_ + pitch_ * x_ + pitch_/2);
			for( int y_ = 0; y_ < countY_; ++y_ ){
				float y1_ = (y0_ + pitch_ * y_);
				drawText( x1_, y1_, String.valueOf( (int)y1_ ) );
			}
		}
		for( int y_ = 0; y_ < countY_+1; ++y_ ){
			float y1_ = (y0_ + pitch_ * y_ + pitch_/2);
			for( int x_ = 0; x_ < countX_; ++x_ ){
				float x1_ = (x0_ + pitch_ * x_);
				drawText( x1_, y1_, String.valueOf( (int)x1_ ) );
			}
		}
	}//}}}
	public void drawPoint( float cx_, float cy_, float r_ )
	{//{{{
		out.printf ( "<circle cx=\"%f\" cy=\"%f\" r=\"%f\"",
			x( cx_ ), y( cy_ ), r_
		);
		printStroke();
		printStrokeWidth();
		printFill();
		out.println( "/>" );
	}//}}}
	public void drawCircle( float cx_, float cy_, float r_ )
	{//{{{
		out.printf ( "<ellipse cx=\"%f\" cy=\"%f\" rx=\"%f\" ry=\"%f\"",
			x( cx_ ), y( cy_ ), r_*scaleX, r_*scaleY
		);
		printStroke();
		printStrokeWidth();
		printFill();
		out.println( "/>" );
	}//}}}
	public void drawEllipse( float cx_, float cy_, float rx_, float ry_ )
	{//{{{
		out.printf ( "<ellipse cx=\"%f\" cy=\"%f\" rx=\"%f\" ry=\"%f\"",
			x( cx_ ), y( cy_ ), rx_*scaleX, ry_*scaleY
		);
		printStroke();
		printStrokeWidth();
		printFill();
		out.println( "/>" );
	}//}}}
	public void drawText( float x_, float y_, String text_ )
	{//{{{
		out.printf ( "<text x=\"%f\" y=\"%f\"", x( x_ ), y( y_ ) );
		printStroke();
		printStrokeWidth();
		printFill();
		printFontFamily();
		printFontSize();
		out.printf( ">%n%s%n</text>%n", text_ );
	}//}}}
	static int min( int lhs_, int rhs_ )
	{//{{{
		if( lhs_ < rhs_ ){
			return lhs_;
		}
		else{
			return rhs_;
		}
	}//}}}
	public void drawLine( float x0_, float y0_, float x1_, float y1_ )
	{//{{{
		drawPath( new float[] { x0_, x1_}, new float[] {y0_, y1_}, false );
	}//}}}
	public void drawPath( float[] xLs_, float[] yLs_, boolean close_ )
	{//{{{
		int sz_ = min( xLs_.length, yLs_.length );
		if( sz_ == 0 ){
			return;
		}
		out.println( "<path" );
		printStroke();
		printFill();
		printStrokeWidth();
		out.print( " d=\"" );
		out.printf( "M%f,%f", x(xLs_[0]), y(yLs_[0]) );
		for( int i_ = 1; i_ < sz_; ++i_ ){
			out.printf( "L%f,%f", x(xLs_[i_]), y(yLs_[i_]) );
		}
		if( close_ ){
			out.print( "Z" );
		}
		out.print( "\"/>" );
	}//}}}
	public void endSvgTag()
	{//{{{
		out.println( "</svg>" );
	}//}}}
}//}}}
