// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.collision;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;
import mn.jp.kekkouyakan.functional.IKyAction1;
import mn.jp.kekkouyakan.util.KyArrayUtil;
import mn.jp.kekkouyakan.test.SvgWriter;
import mn.jp.kekkouyakan.test.HtmlWriter;
import java.io.File;
import java.util.Map;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import static mn.jp.kekkouyakan.collision.CollisionTest.toPolygon;
import static mn.jp.kekkouyakan.collision.CollisionTest.toLines;
import static mn.jp.kekkouyakan.collision.CollisionTest.drawPath;
import static mn.jp.kekkouyakan.collision.CollisionTest.ShapeInfo;
import static mn.jp.kekkouyakan.collision.ColSpace.Node;
import static mn.jp.kekkouyakan.collision.ColProgressControl.Message;
import mn.jp.kekkouyakan.geom.KyVector2f;
import mn.jp.kekkouyakan.util.KyFloatComparator;

public class ColControlTest
{//{{{
	static class NodeComparator implements Comparator<Node>
	{//{{{
		public int compare( Node lhs_, Node rhs_ )
		{//{{{
			ShapeInfo linfo_ = (ShapeInfo)lhs_.getShape().userObject;
			ShapeInfo rinfo_ = (ShapeInfo)rhs_.getShape().userObject;
			return linfo_.id.compareTo( rinfo_.id );
		}//}}}
		public boolean equals( Object a_ )
		{//{{{
			return a_ == this;
		}//}}}
	}//}}}
	static class ResultFile implements Comparable<ResultFile>
	{//{{{
		String fileName = null;
		String title = null;
		public String getTitle()
		{//{{{
			if( title == null ){
				return fileName;
			}
			return title;
		}//}}}
		public int compareTo( ResultFile rhs_ )
		{//{{{
			int c_ = title.compareTo( rhs_.title );
			if( c_ == 0 ){
				return fileName.compareTo( rhs_.fileName );
			}
			return c_;
		}//}}}
	}//}}}

	public final static String TEST_ID="collision20180830_rezd8pL_Sxuhziw3tplmlQ";
	public static File resultDir = null;
	static ArrayList<ResultFile> resultFileList = new ArrayList<ResultFile>();
	KyFloatComparator floatComparator = new KyFloatComparator( 0.001f );

	public ColControlTest()
	{//{{{
	}//}}}

	boolean checkInvalidCollision( KyVector2f[] pLs_, KyVector2f[] qLs_ )
	{//{{{
		return checkInvalidCollision( new ColVectors( pLs_, floatComparator ), new ColVectors( qLs_, floatComparator ) );
	}//}}}
	boolean checkInvalidCollision( ColShape shape1_, ColShape shape2_ )
	{//{{{
		if( shape1_ instanceof ColCircle ){
			if( shape2_ instanceof ColCircle ){
				return !ColResult.isShared( floatComparator,
					(ColCircle)shape1_, (ColCircle)shape2_
				);
			}
			else if( shape2_ instanceof ColVectors ){
				return !ColResult.isShared( floatComparator,
					(ColCircle)shape1_, (ColVectors)shape2_
				);
			}
		}
		else if( shape1_ instanceof ColVectors ){
			if( shape2_ instanceof ColCircle ){
				return !ColResult.isShared( floatComparator,
					(ColCircle)shape2_, (ColVectors)shape1_
				);
			}
			else if( shape2_ instanceof ColVectors ){
				return !ColResult.isShared( floatComparator,
					(ColVectors)shape1_, (ColVectors)shape2_
				);
			}
		}
		throw new Error();
	}//}}}
	<Key_> boolean checkInvalidCollision( Map<Key_, ColBody> bdMap_ )
	{//{{{
		for( Key_ key1_ : bdMap_.keySet() ){
			ColBody bd1_ = bdMap_.get( key1_ );
			for( Key_ key2_ : bdMap_.keySet() ){
				ColBody bd2_ = bdMap_.get( key2_ );
				if( bd1_ == bd2_ ){
					continue;
				}
				if( !checkInvalidCollision( bd1_.shape, bd2_.shape ) ){
					return false;
				}
			}
		}
		return true;
	}//}}}
	ColCircle newCircle( float x_, float y_, float r_, String id_, String color_ )
	{//{{{
		ColCircle c_ = new ColCircle( x_, y_, r_, floatComparator );
		ShapeInfo info_ = new ShapeInfo();
		info_.id = id_;
		info_.color = color_;
		c_.userObject = info_;
		return c_;
	}//}}}
	ColVectors newVecs( String id_, String color_, KyVector2f[] vecLs_ )
	{//{{{
		ColVectors v_ = new ColVectors( vecLs_, floatComparator );
		ShapeInfo info_ = new ShapeInfo();
		info_.id = id_;
		info_.color = color_;
		v_.userObject = info_;
		return v_;
	}//}}}

	@BeforeClass
	public static void setUpClass()
	{//{{{
		String resultPath_ = System.getenv( "TEST_RESULT" );
		if( resultPath_ == null ){
			throw new AssertionError();
		}
		File base_ = new File( resultPath_ );
		if( base_.exists() ){
			if( !base_.isDirectory() ){
				throw new AssertionError();
			}
		}
		else{
			base_.mkdir();
		}
		resultDir = new File( base_, TEST_ID );
		if( resultDir.exists() ){
			//throw new AssertionError();
		}
		else{
			resultDir.mkdir();
		}
	}//}}}
	@AfterClass
	public static void tearDownClass() throws Exception
	{//{{{
		File f_ = new File( resultDir, "index.html" );
		HtmlWriter w_ = new HtmlWriter( f_ );
		w_.beginHtmlTag();
		w_.printHeadTag();
		w_.beginBodyTag();

		synchronized( resultFileList ){
			Collections.sort( resultFileList );
			for( ResultFile result_ : resultFileList ){
				w_.beginDivTag();
				w_.out.print( result_.title + "(" );
				w_.printATagHref( result_.fileName, result_.fileName, null );
				w_.out.print( ")" );
				w_.endDivTag();
			}
		}

		w_.endBodyTag();
		w_.endHtmlTag();
	}//}}}
	@Before
	public void setUp()
	{//{{{
	}//}}}
	@After
	public void tearDown()
	{//{{{
	}//}}}

	static class Writer_TAJogDAORGOsB1aHP81bjw
	{//{{{
		final String COL_RESULTS="col-results";
		String phase=null;
		String name;
		String title;
		float scale = 5;
		int gridPitch = 1;
		int groupNumber = 0;
		int listPageMin = 1;
		int listPageMax = 10;
		String width = null;
		String height = null;
		int axisScaleMarkingStep = 0;
		Iterable<Node> visitResult;
		String forceColor = "#080";

		String getFileName( String funcName_, String ext_, int groupNumber_, int num_ )
		{//{{{
			return String.format( "%s%d_%d.%s", funcName_, groupNumber_, num_, ext_ );
		}//}}}

		String getFileName( String funcName_, String ext_, int num_ )
		{//{{{
			return getFileName( funcName_, ext_, groupNumber, num_ );
		}//}}}

		public void put( ColWorld world_, int n_ ) throws Exception
		{//{{{
			put( world_, n_, null );
		}//}}}
		public void put( ColWorld world_, int n_, ArrayList<LogData_TAJogDAORGOsB1aHP81bjw> logLs_ ) throws Exception
		{//{{{
			ColSpace space_ = world_.space;
			visitResult = null;
			int divCnt_ = space_.getDivCount();

			String svgFileName_ = getFileName( name, "svg", n_ );
			File svgFile_ = new File( resultDir, svgFileName_ );
			SvgWriter svg_ = new SvgWriter( svgFile_ );

			float x0_ = space_.getMinX();
			float y0_ = space_.getMinY();
			float w_ = space_.getWidth();
			float h_ = space_.getHeight();

			svg_.beginSvgTag( (int)(scale*w_), (int)(scale*h_) );
			svg_.setView( scale, scale, -scale*x0_, -scale*y0_ );
			svg_.setFill( "None" );
			svg_.setStroke( "#ddd" );
			svg_.setStrokeWidth( "1" );
			svg_.drawGrid( gridPitch, (int)w_/gridPitch, (int)h_/gridPitch, x0_, y0_ );
			svg_.setStroke( "#aaa" );
			svg_.setStrokeWidth( "2" );
			for( float x_ : space_.xOffsetList ){
				svg_.drawLine( x_, space_.getMinY(), x_, space_.getMaxY() );
			}
			for( float y_ : space_.yOffsetList ){
				svg_.drawLine( space_.getMinX(), y_, space_.getMaxX(), y_ );
			}
			svg_.setStroke( "None" );
			svg_.setFill( "#aaa" );
			if( axisScaleMarkingStep > 0 ){
				float mx_ = space_.xOffsetList[ divCnt_/2 ];
				float my_ = space_.yOffsetList[ divCnt_/2 ];
				for( int i_ = 0; i_ <= divCnt_/2; i_ += axisScaleMarkingStep ){
					{
						float x_ = space_.xOffsetList[ divCnt_/2 - i_ ];
						String str_ = String.format( "(%.2f,%.2f)", x_, my_ );
						svg_.drawText( x_, my_, str_ );
					}
					{
						float x_ = space_.xOffsetList[ divCnt_/2 + i_ ];
						String str_ = String.format( "(%.2f,%.2f)", x_, my_ );
						svg_.drawText( x_, my_, str_ );
					}
					{
						float y_ = space_.yOffsetList[ divCnt_/2 - i_ ];
						String str_ = String.format( "(%.2f,%.2f)", mx_, y_ );
						svg_.drawText( mx_, y_, str_ );
					}
					{
						float y_ = space_.yOffsetList[ divCnt_/2 + i_ ];
						String str_ = String.format( "(%.2f,%.2f)", mx_, y_ );
						svg_.drawText( mx_, y_, str_ );
					}
				}
			}
			{
				int midIndex_ = divCnt_/2;
				svg_.setStrokeWidth( "4" );
				float x_ = space_.xOffsetList[midIndex_];
				float y_ = space_.yOffsetList[midIndex_];
				svg_.drawLine( x_, space_.getMinY(), x_, space_.getMaxY() );
				svg_.drawLine( space_.getMinX(), y_, space_.getMaxX(), y_ );
			}
			svg_.setStroke( "None" );
			svg_.setFill( "#aaa" );
			for( int x_ = 0; x_ < divCnt_; ++x_ ){
				float xf1_ = space_.xOffsetList[x_];
				float xf2_ = space_.xOffsetList[x_+1];
				float xfm_ = (xf1_+xf2_)/2f;
				for( int y_ = 0; y_ < divCnt_; ++y_ ){
					float yf1_ = space_.yOffsetList[y_];
					float yf2_ = space_.yOffsetList[y_+1];
					float yfm_ = (yf1_+yf2_)/2f;
					int o_ = ColSpace.getOrder( x_, y_ );
					svg_.drawText( xfm_, yfm_, String.valueOf( o_ ) );
				}
			}
			svg_.setStrokeWidth( "1" );
			for( ColBody bd_ : world_.bodyHead ){
				printShape( svg_, bd_.getShape(), (ShapeInfo)bd_.userObject );
			}

			svg_.endSvgTag();

			String htmlFileName_ = getFileName( name, "html", n_ );
			ResultFile resultFile_ = new ResultFile();
			resultFile_.title = title;
			resultFile_.fileName = htmlFileName_;
			resultFileList.add( resultFile_ );
			File htmlFile_ = new File( resultDir, htmlFileName_ );
			HtmlWriter html_ = new HtmlWriter( htmlFile_ );
			html_.beginHtmlTag();

			html_.beginHeadTag();
			html_.beginCssTag();
			html_.out.printf( "div.%s { border-style: solid; }%n", COL_RESULTS ) ;
			html_.endCssTag();
			html_.endHeadTag();

			html_.beginBodyTag();
			if( title != null ){
				html_.beginDivTag();
				html_.out.print( title );
				html_.endDivTag();
			}

			if( phase != null ){
				html_.beginDivTag();
				html_.out.print( phase );
				html_.endDivTag();
			}

			if( width != null ){
				html_.setWidth( width );
			}
			if( height != null ){
				html_.setHeight( height );
			}
			html_.beginATag( svgFileName_ );
			html_.printImgTag( svgFileName_ );
			html_.endATag();
			html_.beginDivTag();
			html_.out.printf( "x:" );
			for( int i_ = 0; i_ < space_.xOffsetList.length; ++i_ ){
				if( i_ == divCnt_/2 ){
					html_.out.printf( "(%f),", space_.xOffsetList[i_] );
				}
				else{
					html_.out.printf( "%f,", space_.xOffsetList[i_] );
				}
			}
			html_.endDivTag();
			html_.beginDivTag();
			html_.out.printf( "y:" );
			for( int i_ = 0; i_ < space_.yOffsetList.length; ++i_ ){
				if( i_ == divCnt_/2 ){
					html_.out.printf( "(%f),", space_.yOffsetList[i_] );
				}
				else{
					html_.out.printf( "%f,", space_.yOffsetList[i_] );
				}
			}
			html_.endDivTag();

			html_.beginDivTag();
			html_.printATagHref( "(|&lt;)", getFileName( name, "html", groupNumber-1, 1 ), null );
			html_.printATagHref( "(&lt&lt;)", getFileName( name, "html", groupNumber, n_-1 ), null );
			html_.out.printf( "%d-%d", groupNumber, n_ );
			html_.printATagHref( "(&gt&gt;)", getFileName( name, "html", groupNumber, n_+1 ), null );
			html_.printATagHref( "(&gt;|)", getFileName( name, "html", groupNumber+1, 1 ), null );
			html_.endDivTag();

			html_.beginDivTag();
			html_.printATagHref( "index|", "index.html", null );
			for( int i_ = listPageMin; i_ <= listPageMax; ++i_ ){
				if( i_ == n_ ){
					html_.out.print( String.valueOf(i_) );
				}
				else{
					html_.printATagHref( String.valueOf(i_), getFileName( name, "html", groupNumber, i_ ), null );
				}
				html_.out.print( "," );
			}
			html_.endDivTag();

			html_.beginDivTag();
			html_.out.printf( "Frame Time:%f", world_.getFrameTime() );
			html_.endDivTag();

			if( visitResult != null ){
				html_.beginDivTag();
				html_.out.print( "Visit:" );
				for( Node node_ : visitResult ){
					assert( node_.getShape().userObject instanceof ShapeInfo );
					ShapeInfo info_ = (ShapeInfo)node_.getShape().userObject;
					html_.out.printf( "%s,", info_.id );
				}
				html_.endDivTag();
			}

			for( ColBody bd_ : world_.bodyHead ){
				printShape( html_, bd_.getShape(), (ShapeInfo)bd_.userObject );
			}
			for( ColBody bd_ : world_.bodyHead ){
				printNode( html_, space_, bd_.node, (ShapeInfo)bd_.userObject );
			}

			if( logLs_ != null ){
				for( LogData_TAJogDAORGOsB1aHP81bjw log_ : logLs_ ){
					html_.beginDivTag(COL_RESULTS);
					html_.out.printf( "Collision delta=(%s) temp=%b", log_.delta, log_.temp );
					int i_ = 0;
					for( ColResult resIt_ : log_.collisionList ){
						html_.beginDivTag();
						html_.out.printf( "Collision#%d Ball:%d,%d Wall:%d,%d Progress:%f",
							++i_,
							resIt_.ballIndex1, resIt_.ballIndex2,
							resIt_.wallIndex1, resIt_.wallIndex2,
							resIt_.progress
						);
						html_.endDivTag();
					}
					html_.endDivTag();
				}
			}

			html_.endBodyTag();

			html_.endHtmlTag();
		}//}}}
		static void printShape( HtmlWriter html_, ColShape shape0_, ShapeInfo info_ )
		{//{{{
			if( shape0_ instanceof ColCircle ){
				ColCircle shape_ = (ColCircle)shape0_;
				html_.beginDivTag();
				html_.out.printf(
					"Circle %s: origin=%s, r=%f, min=(%f,%f) max=(%f,%f)"
					,info_.id
					,shape_.transform.position
					,shape_.getRadius()
					,shape_.getMinX()
					,shape_.getMinY()
					,shape_.getMaxX()
					,shape_.getMaxY()
				);
				html_.endDivTag();
			}
			else if( shape0_ instanceof ColVectors ){
				ColVectors shape_ = (ColVectors)shape0_;
				html_.beginDivTag();
				html_.out.printf(
					"Vectors %s: min=(%f,%f) max=(%f,%f)"
					,info_.id
					,shape_.getMinX()
					,shape_.getMinY()
					,shape_.getMaxX()
					,shape_.getMaxY()
				);
				html_.out.print( " points=" );
				for( KyVector2f pt_ : shape_.currentPoints ){
					html_.out.printf( " %s,", pt_);
				}
				html_.endDivTag();
			}
		}//}}}
		static void printNode( HtmlWriter html_, ColSpace space_, Node node_, ShapeInfo info_ )
		{//{{{
			Node hd_ = (Node)node_.getHead();
			html_.beginDivTag();
			html_.out.printf( "Space %s:", info_.id );
			html_.out.printf( " lv=%d", hd_.minOrder );
			html_.out.printf( " index=%d", hd_.maxOrder );
			html_.out.printf( " order=(%d,%d)", node_.minOrder, node_.maxOrder);
			html_.out.printf( " shareLv=%d", space_.getShareLevel( node_.minOrder, node_.maxOrder ) );
			for( int lv_ = 0; lv_ < space_.getLevelCount(); ++lv_ ){
				html_.out.printf( " min%d=%d", lv_, space_.getOrderIndex( node_.minOrder, lv_ ) );
				html_.out.printf( " max%d=%d", lv_, space_.getOrderIndex( node_.maxOrder, lv_ ) );
			}
			html_.endDivTag();
		}//}}}
		static void printShape( SvgWriter svg_, ColShape shape0_, ShapeInfo info_ )
		{//{{{
			if( shape0_ instanceof ColCircle ){
				ColCircle shape_ = (ColCircle)shape0_;
				float x_ = shape_.transform.position.x;
				float y_ = shape_.transform.position.y;
				svg_.setStroke( info_.color );
				svg_.setFill( "None" );
				svg_.drawCircle( x_, y_, shape_.getRadius() );
				svg_.setStroke( "None" );
				svg_.setFill( info_.color );
				svg_.drawText( x_, y_, info_.id );
				svg_.drawPoint( x_, y_, 3 );
			}
			else if( shape0_ instanceof ColVectors ){
				ColVectors shape_ = (ColVectors)shape0_;
				float x1_ = shape_.getMinX();
				float y1_ = shape_.getMinY();
				float y2_ = shape_.getMaxY();
				svg_.setStroke( info_.color );
				svg_.setFill( "None" );
				drawPath( svg_, 6, 3, shape_.currentPoints );
				svg_.setStroke( "None" );
				svg_.setFill( info_.color );
				for( KyVector2f vec_ : shape_.currentPoints ){
					svg_.drawText( vec_.x, vec_.y, info_.id );
				}
			}
		}//}}}
	}//}}}
	static class LogData_TAJogDAORGOsB1aHP81bjw
	{//{{{
		int turn;
		Object scan;
		ColBody ballBody;
		ColTransform delta;
		ArrayList<ColResult> collisionList = new ArrayList<ColResult>();
		float time;
		boolean temp;
	}//}}}


	static class Handler_TAJogDAORGOsB1aHP81bjw
		extends ColShareControl.DefaultHandler
	{//{{{
		KyFloatComparator floatComparator;
		Handler_TAJogDAORGOsB1aHP81bjw( KyFloatComparator floatComparator_ )
		{//{{{
			floatComparator = floatComparator_;
		}//}}}
		static class Data
		{//{{{
			float time;
			ColBody body1;
			ColBody body2;
		}//}}}
		static class OutOfRange
		{//{{{
			float time;
			ColSpace space;
			ColBody body;
			ColShape shape;
		}//}}}
		ArrayList<Data> collisionList = new ArrayList<Data>();
		ArrayList<OutOfRange> rangeList = new ArrayList<OutOfRange>();
		float lastTime = 0f;
		@Override 
		public void beginCollision( ColWorld world_ )
		{//{{{
			lastTime = world_.getFrameTime();
		}//}}}
		@Override 
		public void collideWith( ColBody bd1_, ColBody bd2_ )
		{//{{{
			Data data_ = new Data();
			data_.time = bd1_.getWorld().getFrameTime();
			data_.body1 = bd1_;
			data_.body2 = bd2_;
			collisionList.add( data_ );
		}//}}}
		@Override 
		public void outOfRange( ColSpace space_, ColBody bd_, ColShape shape_ )
		{//{{{
			OutOfRange range_ = new OutOfRange();
			range_.time = bd_.getWorld().getFrameTime();
			range_.body = bd_;
			range_.space = space_;
			range_.shape = shape_;
			rangeList.add( range_ );
		}//}}}
		public boolean includes( float time_ )
		{//{{{
			for( Data data_ : collisionList ){
				if( floatComparator.equals( data_.time, time_) ){
					return true;
				}
			}
			return false;
		}//}}}
		public boolean includes( float time_, ColBody bd1_, ColBody bd2_ )
		{//{{{
			for( Data data_ : collisionList ){
				if( !floatComparator.equals( data_.time, time_) ){
					continue;
				}
				if(
					bd1_ == data_.body1 && bd2_ == data_.body2
					|| bd1_ == data_.body2 && bd2_ == data_.body1
				){
					return true;
				}
			}
			return false;
		}//}}}
		public boolean range( float time_ )
		{//{{{
			for( OutOfRange range_ : rangeList ){
				if( floatComparator.equals( range_.time, time_) ){
					return true;
				}
			}
			return false;
		}//}}}
		public boolean range( float time_, ColBody bd_ )
		{//{{{
			for( OutOfRange range_ : rangeList ){
				if( floatComparator.equals( range_.time, time_) ){
					if( bd_ == range_.body ){
						return true;
					}
				}
			}
			return false;
		}//}}}
	}//}}}

	@Test
	public void control_TAJogDAORGOsB1aHP81bjw() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.name = "control_TAJogDAORGOsB1aHP81bjw";
		w_.title = "FIRST";
		w_.gridPitch = 2;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 20;
		ColSpace space_ = new ColSpace(3, -200, -200, 200, 200, floatComparator );
		Handler_TAJogDAORGOsB1aHP81bjw handler_ = new Handler_TAJogDAORGOsB1aHP81bjw( floatComparator );
		ColWorld world_ = new ColWorld( space_, new ColShareControl( handler_, floatComparator ) );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		w_.phase = "BODIES REGISTER PHAZE";
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toLines( -180,-180, -180,180, 180,180, 180,-180, -180,-180 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#f00";
			ColVectors shape_ = new ColVectors(
				toPolygon( -100,-100, -150,-100, -150,-150, -100,-150 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "C";
			info_.color = "#f00";
			ColCircle shape_ = new ColCircle( 100, 100, 20 , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		w_.groupNumber++;
		w_.phase = "COLLISION PHAZE";
		n_ = 1;
		w_.put( world_, n_++ );
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "C" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 10;
			bd_.defaultTransform.position.y = 10;
			assertTrue( floatComparator.equals( bd_.getShape().getMinX(), 80 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMinY(), 80 ) );
			world_.update( 1f );
			w_.put( world_, n_++ );

			assertTrue( !handler_.includes( time_ ) );
			assertTrue( floatComparator.equals( handler_.lastTime, 0.0f ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMinX(), 90 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMinY(), 90 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMaxX(), 130 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMaxY(), 130 ) );
		}//}}}
		{//{{{
			ColBody bd_ = bodyMap_.get( "C" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 20;
			world_.update( 1f );
			w_.put( world_, n_++ );

			assertTrue( floatComparator.equals( bd_.getShape().getMaxX(), 150 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMaxY(), 130 ) );
			assertTrue( floatComparator.equals( handler_.lastTime, 1.0f ) );
			assertTrue( !handler_.includes( 2.0f ) );

			world_.update( 1f );
			w_.put( world_, n_++ );

			assertTrue( floatComparator.equals( bd_.getShape().getMaxX(), 170 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMaxY(), 130 ) );
			assertTrue( floatComparator.equals( handler_.lastTime, 2.0f ) );
			assertTrue( !handler_.includes( 3.0f ) );

			world_.update( 1f );
			w_.put( world_, n_++ );

			assertTrue( floatComparator.equals( bd_.getShape().getMaxX(), 170 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMaxY(), 130 ) );
			assertTrue( floatComparator.equals( handler_.lastTime, 3.0f ) );
			assertTrue( handler_.includes( 3.0f, bd_, bodyMap_.get( "A" ) ) );

			world_.update( 1f );
			w_.put( world_, n_++ );

			assertTrue( floatComparator.equals( bd_.getShape().getMaxX(), 170 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMaxY(), 130 ) );
			assertTrue( floatComparator.equals( handler_.lastTime, 4.0f ) );
			assertTrue( handler_.includes( 4.0f, bd_, bodyMap_.get( "A" ) ) );

		}//}}}
		{//{{{
			ColBody bd_ = bodyMap_.get( "C" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -90;
			bd_.defaultTransform.position.y = -90;
			ColBody wall_ = bodyMap_.get( "B" );
			assertTrue( floatComparator.equals( wall_.getShape().getMaxX(), -100 ) );
			assertTrue( floatComparator.equals( wall_.getShape().getMaxY(), -100 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMinX(), 130 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMinY(), 90 ) );

			world_.update( 1f );
			w_.put( world_, n_++ );

			assertTrue( floatComparator.equals( bd_.getShape().getMinX(), 40 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMinY(), 0 ) );
			assertTrue( floatComparator.equals( handler_.lastTime, 5.0f ) );
			assertTrue( !handler_.includes( 5.0f ) );
			assertTrue( !handler_.includes( 6.0f ) );

			world_.update( 1f );
			w_.put( world_, n_++ );

			assertTrue( floatComparator.equals( bd_.getShape().getMinX(), -50 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMinY(), -90 ) );
			assertTrue( floatComparator.equals( handler_.lastTime, 6.0f ) );
			assertTrue( !handler_.includes( 6.0f ) );
			assertTrue( !handler_.includes( 7.0f ) );

			world_.update( 1f );
			w_.put( world_, n_++ );

			assertTrue( floatComparator.equals( bd_.getShape().getMinX(), -50 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMinY(), -90 ) );
			assertTrue( floatComparator.equals( handler_.lastTime, 7.0f ) );
			assertTrue( handler_.includes( 7.0f, bd_, wall_ ) );

		}//}}}
		{//{{{
			ColBody bd_ = bodyMap_.get( "C" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -120;
			bd_.defaultTransform.position.y = -120;
			assertTrue( floatComparator.equals( bd_.getShape().getMinX(), -50 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMinY(), -90 ) );

			world_.update( 1f );
			w_.put( world_, n_++ );

			assertTrue( floatComparator.equals( bd_.getShape().getMinX(), -50 ) );
			assertTrue( floatComparator.equals( bd_.getShape().getMinY(), -90 ) );
			assertTrue( floatComparator.equals( handler_.lastTime, 8.0f ) );
			assertTrue( !handler_.includes( 8.0f ) );
			assertTrue( handler_.range( 8.0f, bd_ ) );

		}//}}}
	}//}}}

	static class Handler_HxPPhTHfRwiAPSJ6qYLw4g
		extends ColProgressControl.DefaultHandler
	{//{{{
		ArrayList<LogData_TAJogDAORGOsB1aHP81bjw> logList = new ArrayList<LogData_TAJogDAORGOsB1aHP81bjw>();
		KyFloatComparator floatComparator;
		boolean outOfRangeFlag;
		int turn = 0;
		Message[] messageList = null;
		Handler_HxPPhTHfRwiAPSJ6qYLw4g( KyFloatComparator floatComparator_ )
		{//{{{
			floatComparator = floatComparator_;
		}//}}}
		public void beginCollision( ColWorld world_ )
		{//{{{
			++turn;
			outOfRangeFlag = false;
			messageList = null;
			logList.clear();
		}//}}}
		public boolean hasOccuredOutOfRange()
		{//{{{
			return outOfRangeFlag;
		}//}}}
		public void collideWith( IKyAction1<Message> msgScan_, ColBody ball_, ColTransform delta_, Iterable<ColResult> colLs_, float time_, boolean temp_ )
		{//{{{
			LogData_TAJogDAORGOsB1aHP81bjw log_ = new LogData_TAJogDAORGOsB1aHP81bjw();
			log_.turn = turn;
			log_.scan = msgScan_;
			log_.ballBody = ball_;
			log_.delta = delta_.getClone();
			for( ColResult res_ : colLs_ ){
				log_.collisionList.add( res_ );
			}
			log_.time = time_;
			log_.temp = temp_;
			logList.add( log_ );
		}//}}}
		public void outOfRange( ColSpace space_, ColBody bd_, ColShape shape_, boolean temp_ )
		{//{{{
			outOfRangeFlag = true;
		}//}}}
	}//}}}
	static class SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g
		extends Handler_HxPPhTHfRwiAPSJ6qYLw4g
	{//{{{
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( KyFloatComparator floatComparator_ )
		{//{{{
			super( floatComparator_ );
		}//}}}
		@Override
		public void collideWith( IKyAction1<Message> msgScan_, ColBody ball_, ColTransform delta_, Iterable<ColResult> colLs_, float time_, boolean temp_ )
		{
			super.collideWith( msgScan_, ball_, delta_, colLs_, time_, temp_ );
			if( msgScan_ == null ){
				return;
			}
			for( ColResult collision_ : colLs_ ){
				Message msg_ = Message.newSlip( floatComparator, collision_, 1.0f, delta_.position, time_ );
				if( msg_ != null ){
					messageList = new Message[]{ msg_ };
					msgScan_.call( msg_ );
					break;
				}
			}
		}
	}//}}}
	static class BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g
		extends Handler_HxPPhTHfRwiAPSJ6qYLw4g
	{//{{{
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( KyFloatComparator floatComparator_ )
		{//{{{
			super( floatComparator_ );
		}//}}}
		@Override
		public void collideWith( IKyAction1<Message> msgScan_, ColBody ball_, ColTransform delta_, Iterable<ColResult> colLs_, float time_, boolean temp_ )
		{
			super.collideWith( msgScan_, ball_, delta_, colLs_, time_, temp_ );
			if( msgScan_ == null ){
				return;
			}
			for( ColResult collision_ : colLs_ ){
				Message msg_ = Message.newBound( floatComparator, collision_, 1.0f, delta_.position, time_);
				if( msg_ != null ){
					messageList = new Message[]{ msg_ };
					msgScan_.call( msg_ );
					break;
				}
			}
		}
	}//}}}

	//final static int spaceDiv = 0;
	final static int spaceDiv = 3;
	final static float progressRatio = 0.95f;

	/* TESTS20131006 */

	//vectors ball vs vectors wall (slip)
	@Test
	public void control_HxPPhTHfRwiAPSJ6qYLw4g() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/vectors ball vs vectors wall (slip)";
		w_.name = "control_HxPPhTHfRwiAPSJ6qYLw4g";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_, floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -10;
			bd_.defaultTransform.position.y = -70;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			//assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (slip)
	@Test
	public void control_kGo91qZ0SviZVDP2YdUfDA() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/vectors ball vs vectors wall (slip)";
		w_.name = "control_kGo91qZ0SviZVDP2YdUfDA";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200 ,floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g(floatComparator);
		ColProgressControl control_ = new ColProgressControl( handler_, floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -100,0, -100,30, -70,30, -70,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = -100;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (slip)
	@Test
	public void control_I9Rx_G2vQeCd7ELtK_hCYA() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/vectors ball vs vectors wall (slip)";
		w_.name = "control_I9Rx_G2vQeCd7ELtK_hCYA";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator );
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_, floatComparator  );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 10;
			bd_.defaultTransform.position.y = 70;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList != null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList != null );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (slip)
	@Test
	public void control_G3OXjzFwQPiC_p5ZYfPHwQ() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/vectors ball vs vectors wall (slip)";
		w_.name = "control_G3OXjzFwQPiC_p5ZYfPHwQ";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -130,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -20;
			bd_.defaultTransform.position.y = -80;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (slip)
	@Test
	public void control_EcQRP_CXRTC9lvdVGi2zbg() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/vectors ball vs vectors wall (slip)";
		w_.name = "control_EcQRP_CXRTC9lvdVGi2zbg";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -130,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 20;
			bd_.defaultTransform.position.y = 80;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
	}//}}}

	//circle ball vs vectors wall (slip)
	@Test
	public void control_k5CS1sAHSly4aSr60JyAow() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/circle ball vs vectors wall (slip)";
		w_.name = "control_k5CS1sAHSly4aSr60JyAow";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, 0f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -10;
			bd_.defaultTransform.position.y = -70;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			//assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle ball vs vectors wall (slip)
	@Test
	public void control__YSZ_6FUSrucEQbtwH6gOg() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/circle ball vs vectors wall (slip)";
		w_.name = "control__YSZ_6FUSrucEQbtwH6gOg";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( -70f, 15f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = -100;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle wall vs vectors ball (slip)
	@Test
	public void control_SiRz524BTlKFqmVyDrgujA() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/circle wall vs vectors ball (slip)";
		w_.name = "control_SiRz524BTlKFqmVyDrgujA";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, 0f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 10;
			bd_.defaultTransform.position.y = 70;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle ball vs vectors wall (slip)
	@Test
	public void control_PBA4E2utSW_mgAg_GT_dog() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/circle ball vs vectors wall (slip)";
		w_.name = "control_PBA4E2utSW_mgAg_GT_dog";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -130,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, 0f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -20;
			bd_.defaultTransform.position.y = -80;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle wall vs vectors ball (slip)
	@Test
	public void control_S_dckPs_QGq9fUZvDBcdJw() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/circle wall vs vectors ball (slip)";
		w_.name = "control_S_dckPs_QGq9fUZvDBcdJw";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -130,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, 0f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 20;
			bd_.defaultTransform.position.y = 80;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
	}//}}}

	//vectors ball vs vectors wall (bound)
	@Test
	public void control_OSul0yUpQ06T2DT1yTmeLA() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/vectors ball vs vectors wall (bound)";
		w_.name = "control_OSul0yUpQ06T2DT1yTmeLA";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -10;
			bd_.defaultTransform.position.y = -70;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( !handler_.hasOccuredOutOfRange() );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( !handler_.hasOccuredOutOfRange() );
			//assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( !handler_.hasOccuredOutOfRange() );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control_cf6pXZP8QuqiB83mXP_V7w() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/vectors ball vs vectors wall (bound)";
		w_.name = "control_cf6pXZP8QuqiB83mXP_V7w";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -100,0, -100,30, -70,30, -70,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = -100;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( !handler_.hasOccuredOutOfRange() );
			//assertTrue( trNew_.position.x < trOld_.position.x );
			//assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.hasOccuredOutOfRange() );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control_p4v50VQRQ4SYKRpGe8pTwQ() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/vectors ball vs vectors wall (bound)";
		w_.name = "control_p4v50VQRQ4SYKRpGe8pTwQ";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 10;
			bd_.defaultTransform.position.y = 70;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( !handler_.hasOccuredOutOfRange() );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( !handler_.hasOccuredOutOfRange() );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( !handler_.hasOccuredOutOfRange() );
			assertTrue( trNew_.position.x < trOld_.position.x );
			//assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control_g8XbqzImSbSb7IHkG7oh6Q() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/vectors ball vs vectors wall (bound)";
		w_.name = "control_g8XbqzImSbSb7IHkG7oh6Q";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -130,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -20;
			bd_.defaultTransform.position.y = -80;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			//assertTrue( trNew_.position.x < trOld_.position.x );
			//assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList != null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control_whtvIdhgQ6yWeSpm3Lvx6g() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/vectors ball vs vectors wall (bound)";
		w_.name = "control_whtvIdhgQ6yWeSpm3Lvx6g";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -130,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 20;
			bd_.defaultTransform.position.y = 80;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			//assertTrue( trNew_.position.x > trOld_.position.x );
			//assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList != null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
	}//}}}

	//circle ball vs vectors wall (bound)
	@Test
	public void control_DshSQ3ehSAmhAb_X7DV4Aw() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/circle ball vs vectors wall (bound)";
		w_.name = "control_DshSQ3ehSAmhAb_X7DV4Aw";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, 0f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -10;
			bd_.defaultTransform.position.y = -70;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			//assertTrue( trNew_.position.x > trOld_.position.x );
			//assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle ball vs vectors wall (bound)
	@Test
	public void control_Ke9g_NnfQwG7_g4rSe2PIQ() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/circle ball vs vectors wall (bound)";
		w_.name = "control_Ke9g_NnfQwG7_g4rSe2PIQ";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( -70f, 15f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = -100;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( !handler_.hasOccuredOutOfRange() );
			assertTrue( trNew_.position.x < trOld_.position.x );
			//assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( !handler_.hasOccuredOutOfRange() );
			assertTrue( trNew_.position.x < trOld_.position.x );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle wall vs vectors ball (bound)
	@Test
	public void control_Jl6kj_GZQPSXRPwIKEkkRQ() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/circle wall vs vectors ball (bound)";
		w_.name = "control_Jl6kj_GZQPSXRPwIKEkkRQ";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -50,-50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, 0f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 10;
			bd_.defaultTransform.position.y = 70;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( !handler_.hasOccuredOutOfRange() );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( !handler_.hasOccuredOutOfRange() );
			//assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.hasOccuredOutOfRange() );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle ball vs vectors wall (bound)
	@Test
	public void control__dZVw1COQQCXpCfXcdgX5w() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/circle ball vs vectors wall (bound)";
		w_.name = "control__dZVw1COQQCXpCfXcdgX5w";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -130,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, 0f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -20;
			bd_.defaultTransform.position.y = -80;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -40;
			bd_.defaultTransform.position.y = -40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			//assertTrue( trNew_.position.x < trOld_.position.x );
			//assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList != null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle wall vs vectors ball (bound)
	@Test
	public void control_Vxau_CClTtaUMwNr2k6S2Q() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title = "TESTS20131006/circle wall vs vectors ball (bound)";
		w_.name = "control_Vxau_CClTtaUMwNr2k6S2Q";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -130,-130, 0,-130, -130,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, 0f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 20;
			bd_.defaultTransform.position.y = 80;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 40;
			bd_.defaultTransform.position.y = 40;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			//assertTrue( trNew_.position.x > trOld_.position.x );
			//assertTrue( trNew_.position.y > trOld_.position.y );
			assertTrue( handler_.messageList != null );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			assertTrue( handler_.messageList == null );
			trOld_ = trNew_;
		}//}}}
	}//}}}

	/* TESTS20131009 */

	//vectors ball vs vectors wall (slip)
	@Test
	public void control_0dIOacZvSrCJ12C_FMjgOA() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (slip)";
		w_.name = "control_0dIOacZvSrCJ12C_FMjgOA";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -20;
			bd_.defaultTransform.position.y = -20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -20;
			bd_.defaultTransform.position.y = -60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (slip)
	@Test
	public void control_ljZ1_px9T_O6kSE_8eAuzA() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (slip)";
		w_.name = "control_ljZ1_px9T_O6kSE_8eAuzA";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 20;
			bd_.defaultTransform.position.y = 20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 20;
			bd_.defaultTransform.position.y = 60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control_huRcAksIR92dQuBrh8VvOA() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (bound)";
		w_.name = "control_huRcAksIR92dQuBrh8VvOA";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -20;
			bd_.defaultTransform.position.y = -20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control_xwTo7KQSStiosEcRP8aMeg() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (bound)";
		w_.name = "control_xwTo7KQSStiosEcRP8aMeg";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -20;
			bd_.defaultTransform.position.y = -60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control_hvdR4eFDR16fitc0tNbI9Q() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (bound)";
		w_.name = "control_hvdR4eFDR16fitc0tNbI9Q";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 20;
			bd_.defaultTransform.position.y = 20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control_N3OBmlu3Q8O0dh4bdiYNFQ() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (bound)";
		w_.name = "control_N3OBmlu3Q8O0dh4bdiYNFQ";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( 0,0, 0,30, 30,30, 30,0 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 20;
			bd_.defaultTransform.position.y = 60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}

	//vectors ball vs vectors wall (slip)
	@Test
	public void control_2aPUB_48SzKorxnxrZJE3w() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (slip)";
		w_.name = "control_2aPUB_48SzKorxnxrZJE3w";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -15,-50, 15,-50, 15,-80, -15,-80 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = 20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 60;
			bd_.defaultTransform.position.y = 60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (slip)
	@Test
	public void control_Iq337Lj4Ryqx8ldnAJ4wVg() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (slip)";
		w_.name = "control_Iq337Lj4Ryqx8ldnAJ4wVg";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -15,-50, 15,-50, 15,-80, -15,-80 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = -20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -60;
			bd_.defaultTransform.position.y = -60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control__vreWV7lRSCdX7h0gm5upQ() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (bound)";
		w_.name = "control__vreWV7lRSCdX7h0gm5upQ";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -15,-50, 15,-50, 15,-80, -15,-80 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = 20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control_zYDzme6sRNyyEPVaESymrg() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (bound)";
		w_.name = "control_zYDzme6sRNyyEPVaESymrg";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -15,-50, 15,-50, 15,-80, -15,-80 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 60;
			bd_.defaultTransform.position.y = 60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control_NtFMRUqSTzWGRf37A_SrDA() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (bound)";
		w_.name = "control_NtFMRUqSTzWGRf37A_SrDA";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -15,-50, 15,-50, 15,-80, -15,-80 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = -20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//vectors ball vs vectors wall (bound)
	@Test
	public void control_DyDa4fZhSz_KaqpRGu_GwQ() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/vectors ball vs vectors wall (bound)";
		w_.name = "control_DyDa4fZhSz_KaqpRGu_GwQ";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -15,-50, 15,-50, 15,-80, -15,-80 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -60;
			bd_.defaultTransform.position.y = -60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}

	//circle ball vs vectors wall (slip)
	@Test
	public void control_E_3c1cM4RvWcftje0bfw_Q() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/circle ball vs vectors wall (slip)";
		w_.name = "control_E_3c1cM4RvWcftje0bfw_Q";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, -65f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = 20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 60;
			bd_.defaultTransform.position.y = 60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle wall vs vectors ball (slip)
	@Test
	public void control_v_Jy3kexTdmvGGH9_7eIxQ() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/circle wall vs vectors ball (slip)";
		w_.name = "control_v_Jy3kexTdmvGGH9_7eIxQ";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new SlipHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, -65f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = -20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -60;
			bd_.defaultTransform.position.y = -60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y == trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle ball vs vectors wall (bound)
	@Test
	public void control_ZJrWVfmiRdmKyl4ur_gGDQ() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/circle ball vs vectors wall (bound)";
		w_.name = "control_ZJrWVfmiRdmKyl4ur_gGDQ";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, -65f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = 20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle ball vs vectors wall (bound)
	@Test
	public void control_zbPtzYReQsm1eG_ZBef8xw() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/circle wall vs vectors ball (bound)";
		w_.name = "control_zbPtzYReQsm1eG_ZBef8xw";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, -65f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "B" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 60;
			bd_.defaultTransform.position.y = 60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "B" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x > trOld_.position.x );
			assertTrue( trNew_.position.y < trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle wall vs vectors ball (bound)
	@Test
	public void control_3I_1CvkISC28mb7fJBl2NA() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/circle wall vs vectors ball (bound)";
		w_.name = "control_3I_1CvkISC28mb7fJBl2NA";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, -65f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = 0;
			bd_.defaultTransform.position.y = -20;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x == trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
	//circle wall vs vectors ball (bound)
	@Test
	public void control_vkBdnS6rR4GOUi_aNKmtfA() throws Exception
	{//{{{
		Writer_TAJogDAORGOsB1aHP81bjw w_ = new Writer_TAJogDAORGOsB1aHP81bjw();
		w_.title= "TESTS20131009/circle wall vs vectors ball (bound)";
		w_.name = "control_vkBdnS6rR4GOUi_aNKmtfA";
		w_.gridPitch = 5;
		w_.width = "800px";
		w_.height = "800px";
		w_.groupNumber++;
		w_.listPageMax = 10;
		ColSpace space_ = new ColSpace(spaceDiv, -200, -200, 200, 200, floatComparator);
		BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g handler_ = new BoundHandler_HxPPhTHfRwiAPSJ6qYLw4g( floatComparator );
		ColProgressControl control_ = new ColProgressControl( handler_ , floatComparator );
		control_.progressRatio = progressRatio;
		ColWorld world_ = new ColWorld( space_, control_ );
		world_.setFrameUnitTime( 1f );
		HashMap<String, ColBody> bodyMap_ = new HashMap<String, ColBody>();
		int n_ = 1;
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "A";
			info_.color = "#00f";
			ColVectors shape_ = new ColVectors(
				toPolygon( -50,-50, 50,-50, -50,50 ),
				floatComparator
			);
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		{//{{{
			ShapeInfo info_ = new ShapeInfo();
			info_.id = "B";
			info_.color = "#00f";
			ColCircle shape_ = new ColCircle( 0f, -65f, 15f , floatComparator );
			ColBody bd_ = world_.addBody( shape_ );
			bd_.userObject = info_;
			bodyMap_.put( info_.id, bd_ );
		}//}}}
		w_.put( world_, n_++ );
		assertTrue( checkInvalidCollision( bodyMap_ ) );

		ColTransform trOld_ = bodyMap_.get( "A" ).shape.transform;
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			bd_.defaultTransform = new ColTransform();
			bd_.defaultTransform.position.x = -60;
			bd_.defaultTransform.position.y = -60;
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList != null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
		{//{{{
			float time_ = world_.getFrameTime();
			ColBody bd_ = bodyMap_.get( "A" );
			world_.update( 1f );
			ColTransform trNew_ = bd_.shape.transform;
			w_.put( world_, n_++, handler_.logList );
			assertTrue( checkInvalidCollision( bodyMap_ ) );
			assertTrue( handler_.messageList == null );
			assertTrue( trNew_.position.x < trOld_.position.x );
			assertTrue( trNew_.position.y > trOld_.position.y );
			trOld_ = trNew_;
		}//}}}
	}//}}}
}//}}}
