// vim: foldmethod=marker  commentstring=//%s
package mn.jp.kekkouyakan.util;
import java.util.Iterator;
import java.util.ArrayList;
import java.lang.reflect.Array;

public class KyCollectionUtil
{//{{{
	public static <Elem_> Iterable<Elem_> toReadOnly( final Iterable<Elem_> ite_ )
	{//{{{
		return new Iterable<Elem_>(){
			public Iterator<Elem_> iterator()
			{
				return toReadOnly( ite_.iterator() );
			}
		};
	}//}}}
	public static <Elem_> Iterator<Elem_> toReadOnly( final Iterator<Elem_> ite_ )
	{//{{{
		return new Iterator<Elem_>(){
			public boolean hasNext()
			{//{{{
				return ite_.hasNext();
			}//}}}
			public Elem_ next()
			{//{{{
				return ite_.next();
			}//}}}
			public void remove()
			{//{{{
			}//}}}
		};
	}//}}}
	public static class ArrayIterator<Src_, Elem_ extends Src_> implements Iterator<Src_>
	{//{{{
		Src_[] elemList;
		int index_ = -1;
		public ArrayIterator( Src_[] elemLs_ )
		{//{{{
			elemList = elemLs_;
		}//}}}
		public boolean hasNext()
		{//{{{
			return index_ < elemList.length - 1;
		}//}}}
		public Src_ next()
		{//{{{
			return elemList[ ++index_ ];
		}//}}}
		public void remove()
		{//{{{
		}//}}}
	}//}}}
	public static class ArrayCastIterator<Src_, Elem_ extends Src_> implements Iterator<Elem_>
	{//{{{
		Src_[] elemList;
		int index_ = -1;
		public ArrayCastIterator( Src_[] elemLs_ )
		{//{{{
			elemList = elemLs_;
		}//}}}
		public boolean hasNext()
		{//{{{
			return index_ < elemList.length - 1;
		}//}}}
		public Elem_ next()
		{//{{{
			return (Elem_)elemList[ ++index_ ];
		}//}}}
		public void remove()
		{//{{{
		}//}}}
	}//}}}
	public static class ArrayIterable<Src_, Elem_ extends Src_> implements Iterable<Src_>
	{//{{{
		Src_[] elementList;
		public ArrayIterable( Src_[] elementList_ )
		{//{{{
			elementList = elementList_;
		}//}}}
		public Iterator<Src_> iterator()
		{//{{{
			return new ArrayIterator<Src_, Elem_>( elementList );
		}//}}}
	}//}}}
	public static class MutableArrayIterator<Src_, Elem_ extends Src_> extends ArrayIterator<Src_, Elem_>
	{//{{{
		public MutableArrayIterator( Src_[] elemLs_ )
		{//{{{
			super( elemLs_ );
		}//}}}
		public void remove()
		{//{{{
			for( int i_ = index_; i_ < elemList.length - 1; ++i_ ){
				elemList[i_] = elemList[i_+1];
			}
			elemList[elemList.length - 1] = null;
		}//}}}
	}//}}}
	public static <Elem_> Iterator<Elem_> arrayToIterator( final Elem_[] ls_, final boolean canRemove_ )
	{//{{{
		if( canRemove_ ){
			return new MutableArrayIterator<Elem_,Elem_>( ls_ );
		}
		else{
			return new ArrayIterator<Elem_,Elem_>( ls_ );
		}
	}//}}}
	public static <Elem_> Iterator<Elem_> arrayToIterator( final Elem_[] ls_ )
	{//{{{
		return arrayToIterator( ls_, false );
	}//}}}
	public static <Elem_> Iterable<Elem_> arrayToIterable( final Elem_[] ls_ )
	{//{{{
		return arrayToIterable( ls_, false );
	}//}}}
	public static <Elem_> Iterable<Elem_> arrayToIterable( final Elem_[] ls_, final boolean canRemove_ )
	{//{{{
		return new Iterable<Elem_>(){
			public Iterator<Elem_> iterator()
			{//{{{
				return arrayToIterator( ls_, canRemove_ );
			}//}}}
		};
	}//}}}
	public static <Elem_> Iterator<Elem_> combineIterator( final Iterator<Elem_>... itLs_ )
	{//{{{
		return new Iterator<Elem_>(){
			int index = 0;
			public boolean hasNext()
			{//{{{
				if( itLs_[index].hasNext() ){
					return true;
				}
				if( index == itLs_.length - 1 ){
					return false;
				}
				return itLs_[index + 1].hasNext();
			}//}}}
			public Elem_ next()
			{//{{{
				if( itLs_[index].hasNext() ){
					return itLs_[index].next();
				}
				return itLs_[++index].next();
			}//}}}
			public void remove()
			{//{{{
				itLs_[index].remove();
			}//}}}
		};
	}//}}}
	public static <Elem_> Iterable<Elem_> combineIterable( final Iterable<Elem_>... itLs_ )
	{//{{{
		final Iterator[] iLs_ = new Iterator[ itLs_.length ];
		return new Iterable<Elem_>(){
			public Iterator<Elem_> iterator(){
				for( int i_ = 0; i_ < itLs_.length; ++i_ ){
					iLs_[i_] = itLs_[i_].iterator();
				}
				return combineIterator( iLs_ );
			}
		};
	}//}}}
}//}}}
