// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.jmex.wani;
import java.io.IOException;
import com.jme3.export.OutputCapsule;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;

public class WaniSerial extends WaniList
{//{{{
	int index = 0;
	boolean loop;

	public WaniSerial()
	{//{{{
	}//}}}
	public WaniSerial( WaniItem... itemLs_ )
	{//{{{
		addSubItem( itemLs_ );
	}//}}}
	@Override
	public void start()
	{//{{{
		assert( getSubItemCount() > 0 );
		loop = false;
		getSubItem(index).start();
	}//}}}
	@Override
	public void startLoop()
	{//{{{
		assert( getSubItemCount() > 0 );
		loop = true;
		index = 0;
		getSubItem(0).start();
	}//}}}
	@Override
	public void reset( boolean rewind_ )
	{//{{{
		getSubItem( index ).reset( rewind_ );
		if( rewind_ ){
			getSubItem( 0 ).reset( true );
			index = 0;
		}
	}//}}}
	@Override
	public void notifyDone( WaniItem item_ )
	{//{{{
		int sz_ = getSubItemCount();
		assert( item_ == getSubItem( index ) );
		++index;
		if( index == getSubItemCount() ){
			if( loop ){
				startLoop();
			}
			else{
				if( superItem == null ){
					control.notifyDone( this );
				}
				else{
					superItem.notifyDone( this );
				}
			}
		}
		else{
			getSubItem( index ).start();
		}
	}//}}}
	@Override
	public boolean isCompleted()
	{//{{{
		return index == getSubItemCount();
	}//}}}
	@Override
	public WaniItem cloneForControl( WaniControl ctrl_ )
	{//{{{
		WaniSerial clone_ = new WaniSerial();
		clone_.setSpeed( speed );
		clone_.setControl( ctrl_ );
		for( WaniItem item1_ : subList ){
			WaniItem item2_ = item1_.cloneForControl( ctrl_ );
			clone_.addSubItem( item2_ );
		}
		return clone_;
	}//}}}
	@Override
	public void write(JmeExporter ex_) throws IOException
	{//{{{
		super.write( ex_ );
		//OutputCapsule oc_ = ex_.getCapsule(this);
	}//}}}
	@Override
	public void read(JmeImporter im_) throws IOException
	{//{{{
		super.read( im_ );
		//InputCapsule in_ = im_.getCapsule(this);
	}//}}}
}//}}}
