// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.jme3.scene;

import mn.jp.kekkouyakan.functional.*;
import com.jme3.scene.Spatial;
import com.jme3.scene.Node;
import java.util.ArrayList;

public class KySceneUtil
{//{{{
	public static Spatial[] findSpatials( final Spatial sp0_ )
	{//{{{
		final ArrayList<Spatial> spLs_ = new ArrayList<Spatial>();
		spLs_.add( sp0_ );
		crawlScene( sp0_, new IKyAction1<Spatial>(){
			public void call( Spatial sp_ ){
				spLs_.add( sp_ );
			}
		});
		return spLs_.toArray( new Spatial[0] );
	}//}}}
	public static void crawlScene( Spatial sp_, IKyAction1<Spatial> fun_ )
	{//{{{
		fun_.call( sp_ );
		if( sp_ instanceof Node ){
			Node node_ = (Node)sp_;
			for( Spatial child_ : node_.getChildren() ){
				crawlScene( child_, fun_ );
			}
		}
	}//}}}
	public static boolean crawlScene( Spatial sp_, IKyFunc1<Boolean, Spatial> fun_ )
	{//{{{
		Boolean b_ = fun_.call( sp_ );
		if( b_ != null && b_.booleanValue() ){
			return true;
		}
		if( sp_ instanceof Node ){
			Node node_ = (Node)sp_;
			for( Spatial child_ : node_.getChildren() ){
				if( crawlScene( child_, fun_ ) ){
					return true;
				}
			}
		}
		return false;
	}//}}}
}//}}}
