// vim: foldmethod=marker commentstring=//%s
package mn.jp.kekkouyakan.jmex.wani;
import com.jme3.export.Savable;
import java.io.IOException;
import com.jme3.export.OutputCapsule;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;

public abstract class WaniItem implements Savable
{//{{{
	static final float INVALID_FLOAT = -1f;
	public static final String SPEED="speed";

	WaniControl control;
	WaniItem superItem = null;
	Object userObject = null;

	float speed = INVALID_FLOAT;
	public WaniControl getControl()
	{//{{{
		return control;
	}//}}}
	public void setControl( WaniControl value_ )
	{//{{{
		control = value_;
	}//}}}
	public WaniItem getSuperItem()
	{//{{{
		return superItem;
	}//}}}
	public float getSpeed()
	{//{{{
		if( speed < 0 ){
			return 1.0f;
		}
		return speed;
	}//}}}
	public void setSpeed( float value_ )
	{//{{{
		speed = value_;
	}//}}}
	public Object getUserObject()
	{//{{{
		return userObject;
	}//}}}
	public void setUserObject( Object value_)
	{//{{{
		userObject = value_;
	}//}}}
	public float getTotalSpeed()
	{//{{{
		if( superItem == null ){
			return getSpeed();
		}
		else{
			return getSpeed() * superItem.getTotalSpeed();
		}
	}//}}}
	public abstract boolean isCompleted();
	public abstract void start();
	public abstract void startLoop();
	public abstract void reset();
	public abstract WaniItem cloneForControl( WaniControl ctrl_ );
	public void notifyDone( WaniItem subItem_ )
	{//{{{
	}//}}}
	public void write(JmeExporter ex_) throws IOException
	{//{{{
		OutputCapsule oc_ = ex_.getCapsule(this);
		oc_.write( speed, SPEED, INVALID_FLOAT );
	}//}}}
	public void read(JmeImporter im_) throws IOException
	{//{{{
		InputCapsule in_ = im_.getCapsule(this);
		speed = in_.readFloat( SPEED, INVALID_FLOAT );
	}//}}}
}//}}}
