// vim: foldmethod=marker commentstring=//%s

package mygame;

//{{{
import com.jme3.app.SimpleApplication;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.control.CharacterControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.input.event.KeyInputEvent;
import static com.jme3.input.KeyInput.*;
import com.jme3.math.Vector3f;
import com.jme3.math.Quaternion;
import com.jme3.math.FastMath;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.export.xml.XMLImporter;
import com.jme3.util.SkyFactory;
import com.jme3.system.AppSettings;
import com.jme3.asset.AssetManager;
import com.jme3.light.AmbientLight;
import com.jme3.math.ColorRGBA;
import com.jme3.material.Material;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.scene.shape.Dome;
import com.jme3.scene.Geometry;
import mn.jp.kekkouyakan.jme3.input.RawInputAdapter;
import mn.jp.kekkouyakan.jmex.wani.WaniControl;
//}}}

class EventState
{//{{{
	boolean forward = false;
	boolean backward = false;
	boolean leftRotate = false;
	boolean rightRotate = false;
}//}}}

public class Main extends SimpleApplication
{//{{{
	private BulletAppState bulletAppState;
	private RigidBodyControl physicsCharacter;
	private Node characterNode;
	boolean rotate = false;
	WaniControl wani;
	static final String WV_WHEEL_FORWARD = "wv:Wheel_Forward";
	static final String WV_WHEEL_BACKWARD = "wv:Wheel_Backward";
	static final String WV_SHEETS_DANCE01 = "wv:Sheets_Dance01";
	static final String WV_TAIL_SWINGX = "wv:Tail_SwingX";
	static final String HORN_DANCE01_LR = "Horn_Dance01.LR";
	static final String HORN_DANCE02_LR = "Horn_Dance02.LR";
	boolean hornDance = false;

	EventState state = new EventState();
	EventState evState = new EventState();

	class RawInput extends RawInputAdapter
	{//{{{
		@Override
		public void onKeyEvent(KeyInputEvent ev_)
		{//{{{
			switch( ev_.getKeyCode() ){
				case KEY_W:
				case KEY_UP:
					synchronized( evState ){
						evState.forward = ev_.isPressed();
					}
					break;
				case KEY_S:
				case KEY_DOWN:
					synchronized( evState ){
						evState.backward = ev_.isPressed();
					}
					break;
				case KEY_D:
				case KEY_RIGHT:
					synchronized( evState ){
						evState.rightRotate = ev_.isPressed();
					}
					break;
				case KEY_A:
				case KEY_LEFT:
					synchronized( evState ){
						evState.leftRotate = ev_.isPressed();
					}
					break;
			}
		}//}}}
	}//}}}

	public static void main(String[] args_)
	{//{{{
		AppSettings settings_ = new AppSettings( true );
		settings_.setTitle( "Kekkouyakan WDrive20130826" );

		Main app_ = new Main();
		app_.setShowSettings( false );
		//app_.setDisplayFps( false );
		app_.setDisplayStatView( false );
		app_.setSettings( settings_ );
		app_.start();
	}//}}}
	static void createPhysicsTestWorldSoccer(Node rootNode_, AssetManager assetManager_, PhysicsSpace space_)
	{//{{{
		{//{{{
			AmbientLight light_ = new AmbientLight();
			light_.setColor(ColorRGBA.LightGray);
			rootNode_.addLight(light_);
		}//}}}

		{//{{{
			Material m_ = new Material(assetManager_, "Common/MatDefs/Misc/Unshaded.j3md");
			m_.setColor( "Color", new ColorRGBA( 0f, .6f, 0f, 1f ) );
			Box floorBox_ = new Box(140, 0.25f, 140);
			Geometry floorGeometry_ = new Geometry("Floor", floorBox_);
			floorGeometry_.setMaterial(m_);
			floorGeometry_.setLocalTranslation(0, -0.25f, 0);
			floorGeometry_.addControl(new RigidBodyControl(0));
			rootNode_.attachChild(floorGeometry_);
			space_.add(floorGeometry_);
		}//}}}
		{//{{{
			ColorRGBA[] colorLs_ = new ColorRGBA[]{
				ColorRGBA.Red,
				ColorRGBA.Green,
				ColorRGBA.Blue,
				ColorRGBA.Yellow,
				ColorRGBA.Orange,
			};

			for (int i_ = 0; i_ < 5; i_++) {
				Material m_ = new Material(assetManager_, "Common/MatDefs/Misc/Unshaded.j3md");
				m_.setColor( "Color", colorLs_[i_] );
				Sphere sphere_ = new Sphere(16, 16, .5f);
				Geometry ballGeometry_ = new Geometry("Soccer ball", sphere_);
				ballGeometry_.setMaterial(m_);
				ballGeometry_.setLocalTranslation(i_, 2, -3);
				ballGeometry_.addControl(new RigidBodyControl(.001f));
				ballGeometry_.getControl(RigidBodyControl.class).setRestitution(1);
				rootNode_.attachChild(ballGeometry_);
				space_.add(ballGeometry_);
			}
		}//}}}
		{//{{{
			ColorRGBA[] colorLs_ = new ColorRGBA[]{
				ColorRGBA.Red,
				ColorRGBA.Green,
				ColorRGBA.Blue,
				ColorRGBA.Yellow,
				ColorRGBA.Orange,
			};

			for (int i_ = 0; i_ < 5; i_++) {
				Material m_ = new Material(assetManager_, "Common/MatDefs/Misc/Unshaded.j3md");
				m_.setColor( "Color", colorLs_[i_] );
				Dome shape_ = new Dome(Vector3f.ZERO, 2, 4, 1f, false);
				Geometry ballGeometry_ = new Geometry("dome", shape_);
				ballGeometry_.setMaterial(m_);
				ballGeometry_.setLocalTranslation(i_*5, 3, 20);
				ballGeometry_.addControl(new RigidBodyControl(.001f));
				ballGeometry_.getControl(RigidBodyControl.class).setRestitution(1);
				rootNode_.attachChild(ballGeometry_);
				space_.add(ballGeometry_);
			}
		}//}}}
		{//{{{
			RigidBodyControl rigid_  = new RigidBodyControl( new BoxCollisionShape( new Vector3f( .5f, 1.0f, .5f ) ), 0.1f );
			Node node_ = new Node( "Sahagin Node" );
			Spatial model_ = assetManager_.loadModel("dist/sahagin20130614/index.j3x");
			model_.getControl( WaniControl.class ).startLoop( "s:Static" );
			node_.attachChild(model_);
			node_.addControl( rigid_ );
			rootNode_.attachChild( node_ );
			space_.add( rigid_ );
			rigid_.setPhysicsLocation(new Vector3f(0f, 3f, 2f));
		}//}}}
		{//{{{
			float s_ = 5.0f;
			RigidBodyControl rigid_  = new RigidBodyControl(
				new BoxCollisionShape( new Vector3f( .5f*s_, 1.0f*s_, .5f*s_ ) ), 1f
			);
			Node node_ = new Node( "Sahagin Node" );
			Spatial model_ = assetManager_.loadModel("dist/sahagin20130614/index.j3x");
			model_.getControl( WaniControl.class ).startLoop( "s:Static" );
			model_.setLocalScale( s_ );
			node_.attachChild(model_);
			node_.addControl( rigid_ );
			rootNode_.attachChild( node_ );
			space_.add( rigid_ );
			rigid_.setPhysicsLocation(new Vector3f(0f, s_*2f, 30f));
			rigid_.setPhysicsRotation(new Quaternion().fromAngles(0f, FastMath.PI, 0f));
		}//}}}
		{//{{{
			Material m_ = new Material(assetManager_, "Common/MatDefs/Misc/Unshaded.j3md");
			m_.setColor( "Color", new ColorRGBA( .5f, .5f, 1f, 1f ) );
			Box box_ = new Box(1, 1, 1);
			Geometry boxGeometry_ = new Geometry("Box", box_);
			boxGeometry_.setMaterial(m_);
			boxGeometry_.setLocalTranslation(4, 1, 2);
			boxGeometry_.addControl(new RigidBodyControl(new MeshCollisionShape(box_), 0));
			rootNode_.attachChild(boxGeometry_);
			space_.add(boxGeometry_);
		}//}}}

	}//}}}

	@Override
	public void simpleInitApp()
	{//{{{
		bulletAppState = new BulletAppState();
		stateManager.attach(bulletAppState);

		assetManager.registerLoader( XMLImporter.class, "j3x" );
		createPhysicsTestWorldSoccer(rootNode, assetManager, bulletAppState.getPhysicsSpace());
		inputManager.addRawInputListener( new RawInput() );

		physicsCharacter = new RigidBodyControl(new BoxCollisionShape(new Vector3f(1.0f, 1.0f, 1.0f) ), 0.5f);
		characterNode = new Node("character node");

		Spatial model_ = assetManager.loadModel("dist/w20130826/index.j3x");
		characterNode.attachChild(model_);
		rootNode.attachChild(characterNode);
		wani = model_.getControl( WaniControl.class );
		wani.startLoop( WV_TAIL_SWINGX );
		wani.startLoop( HORN_DANCE01_LR );

		characterNode.addControl(physicsCharacter);
		getPhysicsSpace().add(physicsCharacter);
		physicsCharacter.setPhysicsLocation(new Vector3f(-2f, 2f, 2f));
		rootNode.attachChild( SkyFactory.createSky(
			assetManager, "dist/sky.png", true
		));

		cam.setLocation( new Vector3f( 0f, 1f, 10f ) );

		flyCam.setEnabled(false);

	}//}}}
	@Override
	public void simpleUpdate(float tpf_)
	{//{{{
		synchronized( evState ){
			if( state.forward != evState.forward ){
				if( evState.forward ){
					wani.startLoop( WV_WHEEL_FORWARD );
					wani.startLoop( WV_SHEETS_DANCE01 );
					wani.getItem( WV_TAIL_SWINGX ).setSpeed( 2.0f );
					wani.getItem( WV_TAIL_SWINGX ).reset( false );
					wani.getItem( WV_TAIL_SWINGX ).startLoop();
				}
				else{
					wani.reset( WV_WHEEL_FORWARD );
					wani.reset( WV_SHEETS_DANCE01 );
					wani.getItem( WV_TAIL_SWINGX ).setSpeed( 1.0f );
					wani.getItem( WV_TAIL_SWINGX ).reset( false );
					wani.getItem( WV_TAIL_SWINGX ).startLoop();
					hornDance = !hornDance;
					if( hornDance ){
						wani.reset( HORN_DANCE01_LR );
						wani.startLoop( HORN_DANCE02_LR );
					}
					else{
						wani.reset( HORN_DANCE02_LR );
						wani.startLoop( HORN_DANCE01_LR );
					}
				}
				state.forward = evState.forward;
			}
			if( state.backward != evState.backward ){
				if( evState.backward ){
					wani.startLoop( WV_WHEEL_BACKWARD );
					wani.startLoop( WV_SHEETS_DANCE01 );
				}
				else{
					wani.reset( WV_WHEEL_BACKWARD );
					wani.reset( WV_SHEETS_DANCE01 );
				}
				state.backward = evState.backward;
			}
			if( state.leftRotate != evState.leftRotate ){
				state.leftRotate = evState.leftRotate;
			}
			if( state.rightRotate != evState.rightRotate ){
				state.rightRotate = evState.rightRotate;
			}
		}
		if( state.forward ){
			Quaternion q_ = physicsCharacter.getPhysicsRotation(null);
			physicsCharacter.setLinearVelocity( q_.mult(new Vector3f( 0f, 0f, 2f )) );
		}
		else if( state.backward ){
			Quaternion q_ = physicsCharacter.getPhysicsRotation(null);
			physicsCharacter.setLinearVelocity( q_.mult(new Vector3f( 0f, 0f, -2f )) );
		}
		if( state.leftRotate ){
			physicsCharacter.setAngularVelocity( new Vector3f( 0f, 1f, 0f ) );
		}
		else if( state.rightRotate ){
			physicsCharacter.setAngularVelocity( new Vector3f( 0f, -1f, 0f ) );
		}
		cam.lookAt( physicsCharacter.getPhysicsLocation(), Vector3f.UNIT_Y );
	}//}}}
	private PhysicsSpace getPhysicsSpace()
	{//{{{
		return bulletAppState.getPhysicsSpace();
	}//}}}
	@Override
	public void simpleRender(RenderManager rm)
	{//{{{
		//TODO: add render code
	}//}}}
}//}}}
