/*
   This file is provided under the LGPL license ver 2.1.
   Written by K.Tanaka & Katsumi
   http://www.ze.em-net.ne.jp/~kenken/index.html
   http://hp.vector.co.jp/authors/VA016157/
*/

#include <xc.h>
#include "api.h"
#include "compiler.h"
#include "editor.h"

/* Prototypes */
char* init_file(char* buff,char* appname);
char* compile_file();
void wait60thsec(unsigned short n);
extern FSFILE* g_fhandle;

char* printdec(int num){
	char str[11];
	int i;
	if (num<0) {
		printchar('-');
		num=0-num;
	}
	for(i=10;0<i;i--){
		if (num==0 && i<10) break;
		str[i]='0'+rem10_32(num);
		num=div10_32(num);
	}
	for(i++;i<11;i++) {
		printchar(str[i]);
	}
}

int runbasic(char *appname){
// BASIC\[X̃RpCƎs
// ߂l
//@@0:I
//@@-1:t@CG[
//@@-2:NG[
//@@1ȏ:RpCG[̔sisԍł͂Ȃt@C̉sڂj
	int i;
	char* buff;
	char* err;

	// Set grobal pointer
	g_gp=get_gp();
	// Set source positions
	buff=(char*)&(RAM[RAMSIZE-512]);
	g_source=(char*)(&buff[0]);
	g_srcpos=0;
	// Set object positions
	g_object=(int*)(&RAM[0]);
	g_objpos=0;
	g_objmax=g_object+RAMSIZE-512; // Buffer area excluded.
	// Initialize SD card file system
	err=init_file(buff,appname);
	if (err) {
		setcursorcolor(COLOR_ERRORTEXT);
		printstr("Can't Open ");
		printstr(appname);
		printchar('\n');
		return -1;
	}

	g_rnd_seed=0x3045;
	clearscreen();
	setcursor(0,0,7);
	printstr("BASIC KM-1110\n");
	wait60thsec(15);
	// Initialize music
	init_music();

	printstr("Compiling...");

	// Compile the file
	err=compile_file();
	FSfclose(g_fhandle);
	if (err) {
		printstr(err);
		if (0<=g_srcpos) {
			// Compile error
			printstr("\nAround: '");
			for(i=0;i<5;i++){
				printchar(g_source[g_srcpos-2+i]);
			}
			printstr("' in line ");
			printdec(g_line);
			printstr("\n");
			for(i=g_srcpos;0x20<=g_source[i];i++);
			g_source[i]=0x00;
			for(i=g_srcpos;0x20<=g_source[i];i--);
			printstr(g_source+i);
			return g_fileline;
		} else {
			// Link error
			printstr(resolve_label(g_label));
			return -2;
		}
	}
	printstr("done\n");
	wait60thsec(15);

	// Enable Break key
	g_disable_break=0;
	// Assign memory
	set_free_area((void*)(g_object+g_objpos),(void*)(&RAM[RAMSIZE]));
	// Execute program
	// Start program from the beginning of RAM.
	// Work area (used for A-Z values) is next to the object code area.
	start_program((void*)(&(RAM[0])),(void*)(&g_var_mem[0]));
	printstr("\nOK\n");

	return 0;
}
