/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ir.server;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Build;
import android.util.ArrayMap;
import android.util.Log;
import android.widget.Toast;
import com.android.tools.ir.server.MonkeyPatcher;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Restarter {
    public static void restartActivityOnUiThread(final Activity activity) {
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)"Resources updated: notify activities");
                }
                Restarter.updateActivity(activity);
            }
        });
    }

    private static void restartActivity(Activity activity) {
        if (Log.isLoggable((String)"InstantRun", (int)2)) {
            Log.v((String)"InstantRun", (String)("About to restart " + activity.getClass().getSimpleName()));
        }
        while (activity.getParent() != null) {
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)(activity.getClass().getSimpleName() + " is not a top level activity; restarting " + activity.getParent().getClass().getSimpleName() + " instead"));
            }
            activity = activity.getParent();
        }
        activity.recreate();
    }

    public static void restartApp(Context appContext, Collection<Activity> knownActivities, boolean toast) {
        if (!knownActivities.isEmpty()) {
            Activity foreground = Restarter.getForegroundActivity(appContext);
            if (foreground != null) {
                if (toast) {
                    Restarter.showToast(foreground, "Restarting app to apply incompatible changes");
                }
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)"RESTARTING APP");
                }
                Activity context = foreground;
                Intent intent = new Intent((Context)context, foreground.getClass());
                int intentId = 0;
                PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)intentId, (Intent)intent, (int)0x10000000);
                AlarmManager mgr = (AlarmManager)context.getSystemService("alarm");
                mgr.set(1, System.currentTimeMillis() + 100L, pendingIntent);
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)("Scheduling activity " + foreground + " to start after exiting process"));
                }
            } else {
                Restarter.showToast(knownActivities.iterator().next(), "Unable to restart app");
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)"Couldn't find any foreground activities to restart for resource refresh");
                }
            }
            System.exit(0);
        }
    }

    static void showToast(final Activity activity, final String text) {
        if (Log.isLoggable((String)"InstantRun", (int)2)) {
            Log.v((String)"InstantRun", (String)("About to show toast for activity " + activity + ": " + text));
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        Context base;
                        Context context = activity.getApplicationContext();
                        if (context instanceof ContextWrapper && (base = ((ContextWrapper)context).getBaseContext()) == null) {
                            if (Log.isLoggable((String)"InstantRun", (int)5)) {
                                Log.w((String)"InstantRun", (String)"Couldn't show toast: no base context");
                            }
                            return;
                        }
                        int duration = 0;
                        if (text.length() >= 60 || text.indexOf(10) != -1) {
                            duration = 1;
                        }
                        Toast.makeText((Context)activity, (CharSequence)text, (int)duration).show();
                    }
                    catch (Throwable e) {
                        if (!Log.isLoggable((String)"InstantRun", (int)5)) break block5;
                        Log.w((String)"InstantRun", (String)"Couldn't show toast", (Throwable)e);
                    }
                }
            }
        });
    }

    public static Activity getForegroundActivity(Context context) {
        List<Activity> list = Restarter.getActivities(context, true);
        return list.isEmpty() ? null : list.get(0);
    }

    public static List<Activity> getActivities(Context context, boolean foregroundOnly) {
        ArrayList<Activity> list;
        block9: {
            list = new ArrayList<Activity>();
            try {
                Collection c;
                HashMap activities;
                Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
                Object activityThread = MonkeyPatcher.getActivityThread(context, activityThreadClass);
                Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
                activitiesField.setAccessible(true);
                if (Restarter.hasAppCrashed(context, activityThreadClass, activityThread)) {
                    return new ArrayList<Activity>();
                }
                Object collection = activitiesField.get(activityThread);
                if (collection instanceof HashMap) {
                    activities = (HashMap)collection;
                    c = activities.values();
                } else if (Build.VERSION.SDK_INT >= 19 && collection instanceof ArrayMap) {
                    activities = (ArrayMap)collection;
                    c = activities.values();
                } else {
                    return list;
                }
                for (Object activityClientRecord : c) {
                    Class<?> activityClientRecordClass = activityClientRecord.getClass();
                    if (foregroundOnly) {
                        Field pausedField = activityClientRecordClass.getDeclaredField("paused");
                        pausedField.setAccessible(true);
                        if (pausedField.getBoolean(activityClientRecord)) continue;
                    }
                    Field activityField = activityClientRecordClass.getDeclaredField("activity");
                    activityField.setAccessible(true);
                    Activity activity = (Activity)activityField.get(activityClientRecord);
                    if (activity == null) continue;
                    list.add(activity);
                }
            }
            catch (Throwable e) {
                if (!Log.isLoggable((String)"InstantRun", (int)5)) break block9;
                Log.w((String)"InstantRun", (String)"Error retrieving activities", (Throwable)e);
            }
        }
        return list;
    }

    private static boolean hasAppCrashed(Context context, Class activityThreadClass, Object activityThread) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (context == null || activityThread == null) {
            return false;
        }
        String currentPackageName = Restarter.getPackageName(activityThreadClass, activityThread);
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List processesInErrorState = manager.getProcessesInErrorState();
        if (processesInErrorState != null) {
            for (ActivityManager.ProcessErrorStateInfo info : processesInErrorState) {
                if (!info.processName.equals(currentPackageName) || info.condition == 0) continue;
                if (Log.isLoggable((String)"InstantRun", (int)2)) {
                    Log.v((String)"InstantRun", (String)"App Thread has crashed, return empty activity list.");
                }
                return true;
            }
        }
        return false;
    }

    private static String getPackageName(Class activityThreadClass, Object activityThread) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method currentPackageNameMethod = activityThreadClass.getDeclaredMethod("currentPackageName", new Class[0]);
        return (String)currentPackageNameMethod.invoke(activityThread, new Object[0]);
    }

    private static void updateActivity(Activity activity) {
        Restarter.restartActivity(activity);
    }
}

