package com.tryjava.io.log;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * Apache Log4jを使ってみる。
 *
 * <ul>
 * <li>Apache Log4j 2.4 は、Java7以上が必要。
 * <li>Apache Log4j 2.0 は、Java6以上が必要。
 * <li>Java1.4では、Apache Log4j 1.2以下を使用可能。
 * </ul>
 *
 * Apache Log4j 1.2 の参考
 * <ul>
 * <li>Apache log4j 1.2 - Short introduction to log4j<br>
 * http://logging.apache.org/log4j/1.2/manual.html
 * </ul>
 *
 * Apache Log4j 2.x の参考
 * <ul>
 * <li>Log4j – Maven, Ivy, and Gradle Artifacts - Apache Log4j 2<br>
 * http://logging.apache.org/log4j/2.x/maven-artifacts.html
 * <li>Log4j – Log4j 2 API - Apache Log4j 2<br>
 * http://logging.apache.org/log4j/2.x/manual/api.html
 * <li>Log4j – Log4j 2 Layouts - Apache Log4j 2<br>
 * https://logging.apache.org/log4j/2.x/manual/layouts.html#PatternLayout
 * <li>Log4j2を試してみる - CLOVER<br>
 * http://d.hatena.ne.jp/Kazuhira/20140628/1403959552
 * <li>log4j2の設定ファイル(XML) - Qiita<br>
 * http://qiita.com/pica/items/f801c74848f748f76b58
 * </ul>
 *
 * @since 2016/5/4
 */
public class Log4j01 {
	public void run() {
		log();
	}

	/**
	 * Log4j 2.xでの書き方
	 */
	void log() {
		// Log4j2では、Logger#getLoggerメソッドがなくなった。
		Logger logger = LogManager.getLogger(Log4j01.class);

		logger.trace("TRACEログです。");
		logger.debug("DEBUGログです。");
		logger.info("INFOログです。");
		logger.warn("WARNログです。");
		logger.error("ERRORログです。");
		logger.fatal("FATALログです。");

		// Log4j2では、パラメータの埋め込みが使えるようになった。
		logger.info("Hello, {}!", "World");
	}
}
