package com.tryjava.lang.lambda;

import java.util.function.Consumer;

/**
 * ラムダ式を使ってみる。
 *
 * ラムダ式を受け付けるメソッドを作成して、呼び出す。
 *
 * @since 2016/4/20
 */
public class Lambda02 {
	public static void main(String[] args) {
		// 従来の書き方
		step0();

		// Java8での書き方
		step1();
		step2();
		step3();
	}

	/**
	 * 従来の書き方
	 */
	private static void step0() {
		runLambda1(new Runnable() {
			@Override
			public void run() {
				System.out.println("Hello World");
			}
		});
	}

	/**
	 * ラムダ式による書き方1
	 */
	private static void step1() {
		runLambda1(() -> {
			System.out.println("Hello World");
		});
	}

	/**
	 * ラムダ式の受け渡しが可能なメソッド1
	 * @param runnable
	 */
	private static void runLambda1(Runnable runnable) {
		runnable.run();
	}

	/**
	 * ラムダ式による書き方2
	 */
	private static void step2() {
		runLambda2((msg) -> {
			System.out.println(msg);
		});
	}

	// ラムダ式の受け渡しが可能なメソッド2
	private static void runLambda2(Consumer<String> action) {
		action.accept("Hello World");
	}

	/**
	 * ラムダ式による書き方3
	 */
	private static void step3() {
		runLambda3((msg) -> {
			System.out.println(msg);
		});
	}

	// ラムダ式の受け渡しが可能なメソッド3
	private static void runLambda3(FuncInterface action) {
		action.run("Hello World");
	}

	// 独自の関数型インタフェース
	private interface FuncInterface {
		public void run(String msg);
	}
}
