package com.tryjava.net;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import com.tryjava.util.AppUtil;

/**
 * HTTPクライアントを作成してみる。（Apache HttpComponents HttpClient 4.2）
 *
 * Java5では、Apache HttpComponents HttpClient
 * 4.3以降のバージョンも使用可能であるが、ここでは4.3以前の動作確認をするため、4.2を使用する。
 *
 * 色々な操作を試してみる。
 *
 * 参考<br>
 * JavaでのHttpClientサンプル - CLOVER
 * http://d.hatena.ne.jp/Kazuhira/20131026/1382796711<br>
 * Apache HttpComponents - HttpClient Quick Start
 * https://hc.apache.org/httpcomponents-client-4.2.x/quickstart.html<br>
 * Java apache HttpClient 4.3からの大幅なインターフェース変更に対応 - Qiita
 * http://qiita.com/mychaelstyle/items/e02b3011d1e71bfa26c5<br>
 *
 * @since 2016/5/26
 */
public class ApacheHttpClient02 {

	public void run() {
		doGet();
		doPost();
		doPut();
	}

	void doGet() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		try {
			HttpClient client = new DefaultHttpClient();

			// リクエスト作成
			// GETパラメータは、URLエンコードされる。
			// TODO 日本語の設定は、これでよい？UTF-8固定？
			URIBuilder builder = new URIBuilder("http://localhost:8080/tryjava-dummy-web/echo")
					.addParameter("param1", "value1") //
					.addParameter("UrlEncode", "+-/_") //
					.addParameter("text", "日本語");
			HttpGet request = new HttpGet(builder.build());
			request.addHeader("Accept-Language", "ja");
			request.addHeader("X-Header1", "value1");
			System.out.println(request.getRequestLine());

			try {
				// 接続
				HttpResponse response = client.execute(request);

				// レスポンスコード取得
				StatusLine statusLine = response.getStatusLine();
				System.out.println(statusLine);
				if (statusLine.getStatusCode() != HttpStatus.SC_OK) {
					throw new RuntimeException("エラーレスポンスを受信しました。statusLine=" + statusLine);
				}

				// レスポンスヘッダ取得
				for (Header header : response.getAllHeaders()) {
					System.out.println(header);
				}

				// レスポンスボディ取得
				HttpEntity entity = response.getEntity();
				String content = EntityUtils.toString(entity);
				System.out.println();
				System.out.println(content);
			} finally {
				request.releaseConnection();
			}
		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		}
	}

	void doPost() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		try {
			HttpClient client = new DefaultHttpClient();

			// リクエスト作成
			// POSTパラメータは、URLエンコードされる。
			HttpPost request = new HttpPost("http://localhost:8080/tryjava-dummy-web/echo");
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("param1", "value1"));
			params.add(new BasicNameValuePair("UrlEncode", "+-/_"));
			params.add(new BasicNameValuePair("text", "日本語"));
			request.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));
			request.addHeader("Accept-Language", "ja");
			request.addHeader("X-Header1", "value1");
			System.out.println(request.getRequestLine());

			try {
				// 接続
				HttpResponse response = client.execute(request);

				// レスポンスコード取得
				StatusLine statusLine = response.getStatusLine();
				System.out.println(statusLine);
				if (statusLine.getStatusCode() != HttpStatus.SC_OK) {
					throw new RuntimeException("エラーレスポンスを受信しました。statusLine=" + statusLine);
				}

				// レスポンスヘッダ取得
				for (Header header : response.getAllHeaders()) {
					System.out.println(header);
				}

				// レスポンスボディ取得
				HttpEntity entity = response.getEntity();
				String content = EntityUtils.toString(entity);
				System.out.println();
				System.out.println(content);
			} finally {
				request.releaseConnection();
			}
		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		}
	}

	void doPut() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		try {
			HttpClient client = new DefaultHttpClient();

			// リクエスト作成
			HttpPut request = new HttpPut("http://localhost:8080/tryjava-dummy-web/echo");
			// パラメータ
			// ※URLエンコードされる。
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("param1", "value1"));
			params.add(new BasicNameValuePair("UrlEncode", "+-/_"));
			params.add(new BasicNameValuePair("text", "日本語"));
			request.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));
			// ヘッダー設定
			request.addHeader("Accept-Language", "ja");
			request.addHeader("X-Header1", "value1");
			System.out.println(request.getRequestLine());

			try {
				// 接続
				HttpResponse response = client.execute(request);

				// レスポンスコード取得
				StatusLine statusLine = response.getStatusLine();
				System.out.println(statusLine);
				if (statusLine.getStatusCode() != HttpStatus.SC_OK) {
					throw new RuntimeException("エラーレスポンスを受信しました。statusLine=" + statusLine);
				}

				// レスポンスヘッダ取得
				for (Header header : response.getAllHeaders()) {
					System.out.println(header);
				}

				// レスポンスボディ取得
				HttpEntity entity = response.getEntity();
				String content = EntityUtils.toString(entity);
				System.out.println();
				System.out.println(content);
			} finally {
				request.releaseConnection();
			}
		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		}
	}
}
