package com.tryjava.io.log;

import java.io.IOException;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/**
 * Java標準APIのロガーを使ってみる。
 *
 * Java標準APIのロガーは、1.4から使えるようになった。
 *
 * 参考
 * <ul>
 * <li>やっとわかった、java.util.logging – Akira Koyasu's WebLog<br>
 * http://www.akirakoyasu.net/2011/11/06/finally-understood-java-util-logging/
 * </ul>
 *
 * @since 2016/5/3
 */
public class JavaLog01 {
	public void run() {
		log();
	}

	/**
	 * Java1.4での書き方
	 */
	void log() {
		// プロパティファイル読み込み
		try {
			LogManager.getLogManager().readConfiguration(this.getClass().getResourceAsStream("logging.properties"));
		} catch (SecurityException e) {
			throw new RuntimeException(e);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}

		// ログ出力
		Logger logger = Logger.getLogger(JavaLog01.class.getName());
		logger.finest("FINESTメッセージです。");
		logger.finer("FINERメッセージです。");
		logger.fine("FINEメッセージです。");
		logger.config("CONFIGメッセージです。");
		logger.info("INFOメッセージです。");
		logger.warning("WARNINGメッセージです。");
		logger.severe("SEVEREメッセージです。");
	}
}
