package com.tryjava.io.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Apache Commons Loggingを使ってみる。
 *
 * Apache Commons Loggingは、汎用インターフェースを提供するのみ。 実際のログ出力は、Log4jやJava標準APIなどを使用する。
 *
 * <ul>
 * <li>Apache Commons Logging 1.2では、Java1.1以上が必要。
 * </ul>
 *
 * 参考
 * <ul>
 * <li>Apache Commons Logging - User Guide<br>
 * https://commons.apache.org/proper/commons-logging/guide.html
 * </ul>
 *
 * @since 2016/5/4
 */
public class CommonsLogging01 {
	public void run() {
		log();
	}

	void log() {
		Log log = LogFactory.getLog(this.getClass());
		log.trace("TRACEログです。");
		log.debug("DEBUGログです。");
		log.info("INFOログです。");
		log.warn("WARNログです。");
		log.error("ERRORログです。");
		log.fatal("FATALログです。");
	}
}
