package com.tryjava.net;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.io.IOUtils;

import com.tryjava.util.AppUtil;

/**
 * HTTPクライアントを作成してみる。（Java標準APIのみ）
 *
 * まずはシンプルにアクセスしてみる。
 *
 * 参考<br>
 * JavaでのHttpClientサンプル - CLOVER<br>
 * http://d.hatena.ne.jp/Kazuhira/20131026/1382796711<br>
 *
 * @since 2016/5/26
 */
public class JavaHttpClient01 {

	public void run() {
		doGet();
	}

	void doGet() {
		System.out.println("--- " + AppUtil.getMethod() + " ---");

		HttpURLConnection con = null;
		try {
			// リクエスト作成
			URL url = new URL("http://localhost:8080/tryjava-dummy-web/echo");
			con = (HttpURLConnection) url.openConnection();
			con.setRequestMethod("GET");

			// レスポンスコード取得
			int statusCode = con.getResponseCode();
			System.out.println(statusCode + " " + con.getResponseMessage());
			if (statusCode != HttpURLConnection.HTTP_OK) {
				throw new RuntimeException("エラーレスポンスを受信しました。statusCode=" + statusCode);
			}

			// レスポンスボディ取得
			System.out.println(con.getContentType());
			InputStream is = con.getInputStream();
			String encoding = getEncoding(con);
			String content = IOUtils.toString(is, encoding);
			System.out.println(content);

		} catch (Exception e) {
			throw new RuntimeException("HTTP通信に失敗しました。", e);
		} finally {
			if (con != null) {
				con.disconnect();
			}
		}
	}

	/**
	 * 簡易的な文字コード判定処理
	 */
	String getEncoding(HttpURLConnection con) {
		String encoding = null;
		Matcher matcher = Pattern.compile("charset=(.*)", Pattern.CASE_INSENSITIVE).matcher(con.getContentType());
		if (matcher.find()) {
			encoding = matcher.group(1);
		}
		System.out.println("encoding=" + encoding);
		return encoding;
	}
}
