package example.tryspring.c2_di_xml;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import example.tryspring.c2_di.Product;
import example.tryspring.c2_di.ProductService;

/**
 * Javaアプリケーションとして実行するクラス.
 */
public class ProductSampleRun {

	public static void main(String[] args) {
		ProductSampleRun productSampleRun = new ProductSampleRun();
		productSampleRun.execute();
	}

	public void execute() {
		BeanFactory beanFactory = new ClassPathXmlApplicationContext(
				"/example/tryspring/c2_di_xml/applicationContext.xml");
		ProductService productService = beanFactory
				.getBean(ProductService.class);
		Product product = productService.findProduct();
		System.out.println(product);
	}

}
