package example.tryspring.c3_aop_xml;

import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;

import example.tryspring.c2_di.Product;

/**
 * Aspectクラス.
 */
public class MyFirstAspect {
	public void before() {
		System.out.println("MyFirstAspect#beforeメソッド");
	}

	public void before2(JoinPoint jp) {
		Signature sig = jp.getSignature();
		String name = sig.getName();
		String args = StringUtils.join(jp.getArgs(), ",");
		System.out.println("MyFirstAspect#before2メソッド" + " メソッド名=" + name
				+ " 引数=" + args);
	}

	public void after() {
		System.out.println("MyFirstAspect#afterメソッド");
	}

	public void after2(JoinPoint jp) {
		Signature sig = jp.getSignature();
		String name = sig.getName();
		String args = StringUtils.join(jp.getArgs(), ",");
		System.out.println("MyFirstAspect#after2メソッド" + " メソッド名=" + name
				+ " 引数=" + args);
	}

	public Product around(ProceedingJoinPoint pjp) throws Throwable {
		System.out.println("MyFirstAspect#aroundメソッド 開始");
		Product product = (Product) pjp.proceed();
		System.out.println("MyFirstAspect#aroundメソッド 終了");
		return product;
	}

	public void afterReturning(Product product) {
		System.out.println("MyFirstAspect#afterReturningメソッド product="
				+ product.toString());
	}

	public void afterThrowing(Throwable ex) {
		System.out.println("MyFirstAspect#afterThrowingメソッド ex="
				+ ex.toString());
	}

}
