package example.tryspring.c5_transaction;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import example.tryspring.c4_db.Product;
import example.tryspring.c4_db.ProductDao;

/**
 * サービスクラスです。
 */
@Component
public class ProductServiceImpl implements ProductService {

	@Autowired
	private ProductDao productDao;

	@Override
	public void queryForCount() {
		print("count=" + productDao.count());
	}

	@Override
	public void queryForData() {
		int i = 0;
		for (Product product : productDao.findAll()) {
			print("product(" + i + ")=" + product);
		}
	}

	@Override
	public void updateForInsert() {
		print("insert=" + productDao.insert(new Product("定規", 50)));
	}

	@Override
	public void updateForInsertThrowException() {
		print("insert前のcount=" + productDao.count());
		print("insert=" + productDao.insert(new Product("dummy", 50)));
		print("insert後のcount=" + productDao.count());
		throw new RuntimeException("例外送信");
	}

	@Override
	public void updateForDelete() {
		print("delete=" + productDao.delete(new Product("定規", 0)));
		productDao.delete(new Product("dummy", 0));
	}

	private void print(String msg) {
		System.out.println(msg);
	}

}
